/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.temp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.TempFile;

public class AesZipFileZipEntrySource
implements ZipEntrySource {
    private static final POILogger LOG = POILogFactory.getLogger(AesZipFileZipEntrySource.class);
    private final File tmpFile;
    private final ZipFile zipFile;
    private final Cipher ci;
    private boolean closed;

    public AesZipFileZipEntrySource(File tmpFile, Cipher ci) throws IOException {
        this.tmpFile = tmpFile;
        this.zipFile = new ZipFile(tmpFile);
        this.ci = ci;
        this.closed = false;
    }

    @Override
    public Enumeration<? extends ZipEntry> getEntries() {
        return this.zipFile.entries();
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        InputStream is = this.zipFile.getInputStream(entry);
        return new CipherInputStream(is, this.ci);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.zipFile.close();
            if (!this.tmpFile.delete()) {
                LOG.log(5, this.tmpFile.getAbsolutePath() + " can't be removed (or was already removed.");
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public static AesZipFileZipEntrySource createZipEntrySource(InputStream is) throws IOException, GeneralSecurityException {
        SecureRandom sr = new SecureRandom();
        byte[] ivBytes = new byte[16];
        byte[] keyBytes = new byte[16];
        sr.nextBytes(ivBytes);
        sr.nextBytes(keyBytes);
        File tmpFile = TempFile.createTempFile("protectedXlsx", ".zip");
        AesZipFileZipEntrySource.copyToFile(is, tmpFile, CipherAlgorithm.aes128, keyBytes, ivBytes);
        IOUtils.closeQuietly(is);
        return AesZipFileZipEntrySource.fileToSource(tmpFile, CipherAlgorithm.aes128, keyBytes, ivBytes);
    }

    private static void copyToFile(InputStream is, File tmpFile, CipherAlgorithm cipherAlgorithm, byte[] keyBytes, byte[] ivBytes) throws IOException, GeneralSecurityException {
        ZipEntry ze;
        SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, cipherAlgorithm.jceId);
        Cipher ciEnc = CryptoFunctions.getCipher(skeySpec, cipherAlgorithm, ChainingMode.cbc, ivBytes, 1, "PKCS5Padding");
        ZipInputStream zis = new ZipInputStream(is);
        FileOutputStream fos = new FileOutputStream(tmpFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        while ((ze = zis.getNextEntry()) != null) {
            ZipEntry zeNew = new ZipEntry(ze.getName());
            zeNew.setComment(ze.getComment());
            zeNew.setExtra(ze.getExtra());
            zeNew.setTime(ze.getTime());
            zos.putNextEntry(zeNew);
            FilterOutputStream fos2 = new FilterOutputStream(zos){

                @Override
                public void close() {
                }
            };
            CipherOutputStream cos2 = new CipherOutputStream(fos2, ciEnc);
            IOUtils.copy(zis, cos2);
            cos2.close();
            fos2.close();
            zos.closeEntry();
            zis.closeEntry();
        }
        zos.close();
        fos.close();
        zis.close();
    }

    private static AesZipFileZipEntrySource fileToSource(File tmpFile, CipherAlgorithm cipherAlgorithm, byte[] keyBytes, byte[] ivBytes) throws ZipException, IOException {
        SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, cipherAlgorithm.jceId);
        Cipher ciDec = CryptoFunctions.getCipher(skeySpec, cipherAlgorithm, ChainingMode.cbc, ivBytes, 2, "PKCS5Padding");
        return new AesZipFileZipEntrySource(tmpFile, ciDec);
    }
}

