/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.NPropertyTable;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.IOUtils;

public class POIFSDump {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Must specify at least one file to dump");
            System.exit(1);
        }
        boolean dumpProps = false;
        boolean dumpMini = false;
        for (String filename : args) {
            NPOIFSFileSystem fs;
            if (filename.equalsIgnoreCase("-dumprops") || filename.equalsIgnoreCase("-dump-props") || filename.equalsIgnoreCase("-dump-properties")) {
                dumpProps = true;
                continue;
            }
            if (filename.equalsIgnoreCase("-dumpmini") || filename.equalsIgnoreCase("-dump-mini") || filename.equalsIgnoreCase("-dump-ministream") || filename.equalsIgnoreCase("-dump-mini-stream")) {
                dumpMini = true;
                continue;
            }
            System.out.println("Dumping " + filename);
            FileInputStream is = new FileInputStream(filename);
            try {
                fs = new NPOIFSFileSystem(is);
            }
            finally {
                is.close();
            }
            try {
                DirectoryNode root2 = fs.getRoot();
                String filenameWithoutPath = new File(filename).getName();
                File dumpDir = new File(filenameWithoutPath + "_dump");
                File file = new File(dumpDir, root2.getName());
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Could not create directory " + file);
                }
                POIFSDump.dump(root2, file);
                if (dumpProps) {
                    HeaderBlock header = fs.getHeaderBlock();
                    POIFSDump.dump(fs, header.getPropertyStart(), "properties", file);
                }
                if (!dumpMini) continue;
                NPropertyTable props = fs.getPropertyTable();
                int startBlock = props.getRoot().getStartBlock();
                if (startBlock == -2) {
                    System.err.println("No Mini Stream in file");
                    continue;
                }
                POIFSDump.dump(fs, startBlock, "mini-stream", file);
            }
            finally {
                fs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(DirectoryEntry root2, File parent) throws IOException {
        Iterator<Entry> it = root2.getEntries();
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry instanceof DocumentNode) {
                DocumentNode node = (DocumentNode)entry;
                DocumentInputStream is = new DocumentInputStream(node);
                byte[] bytes = IOUtils.toByteArray(is);
                is.close();
                FileOutputStream out = new FileOutputStream(new File(parent, node.getName().trim()));
                try {
                    ((OutputStream)out).write(bytes);
                    continue;
                }
                finally {
                    ((OutputStream)out).close();
                    continue;
                }
            }
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry dir = (DirectoryEntry)entry;
                File file = new File(parent, entry.getName());
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Could not create directory " + file);
                }
                POIFSDump.dump(dir, file);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(NPOIFSFileSystem fs, int startBlock, String name, File parent) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        try {
            NPOIFSStream stream = new NPOIFSStream(fs, startBlock);
            byte[] b = new byte[fs.getBigBlockSize()];
            for (ByteBuffer bb : stream) {
                int len = bb.remaining();
                bb.get(b);
                out.write(b, 0, len);
            }
        }
        finally {
            out.close();
        }
    }
}

