/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LocaleUtil;

public enum FileMagic {
    OLE2(-2226271756974174256L),
    OOXML(new byte[][]{POIFSConstants.OOXML_FILE_HEADER}),
    XML(new byte[][]{POIFSConstants.RAW_XML_FILE_HEADER}),
    BIFF2(new byte[][]{{9, 0, 4, 0, 0, 0, 112, 0}}),
    BIFF3(new byte[][]{{9, 2, 6, 0, 0, 0, 112, 0}}),
    BIFF4({9, 4, 6, 0, 0, 0, 112, 0}, {9, 4, 6, 0, 0, 0, 0, 1}),
    MSWRITE({49, -66, 0, 0}, {50, -66, 0, 0}),
    RTF("{\\rtf"),
    PDF("%PDF"),
    UNKNOWN(new byte[][]{new byte[0]});

    final byte[][] magic;

    private FileMagic(long magic) {
        this.magic = new byte[1][8];
        LittleEndian.putLong(this.magic[0], 0, magic);
    }

    private FileMagic(byte[] ... magic) {
        this.magic = magic;
    }

    private FileMagic(String magic) {
        this(new byte[][]{magic.getBytes(LocaleUtil.CHARSET_1252)});
    }

    public static FileMagic valueOf(byte[] magic) {
        for (FileMagic fm : FileMagic.values()) {
            int i = 0;
            boolean found = true;
            byte[][] arr$ = fm.magic;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte[] ma;
                for (byte m3 : ma = arr$[i$]) {
                    byte d;
                    if ((d = magic[i++]) == m3 || m3 == 112 && (d == 16 || d == 32 || d == 64)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return fm;
            }
        }
        return UNKNOWN;
    }

    public static FileMagic valueOf(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            throw new IOException("getFileMagic() only operates on streams which support mark(int)");
        }
        byte[] data = IOUtils.peekFirst8Bytes(inp);
        return FileMagic.valueOf(data);
    }

    public static InputStream prepareToCheckMagic(InputStream stream) {
        if (stream.markSupported()) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }
}

