/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class PropertyTableBase
implements BATManaged {
    private static final POILogger _logger = POILogFactory.getLogger(PropertyTableBase.class);
    private final HeaderBlock _header_block;
    protected final List<Property> _properties;

    public PropertyTableBase(HeaderBlock header_block) {
        this._header_block = header_block;
        this._properties = new ArrayList<Property>();
        this.addProperty(new RootProperty());
    }

    public PropertyTableBase(HeaderBlock header_block, List<Property> properties) throws IOException {
        this._header_block = header_block;
        this._properties = properties;
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    private void populatePropertyTree(DirectoryProperty root2) throws IOException {
        int index = root2.getChildIndex();
        if (!Property.isValidIndex(index)) {
            return;
        }
        Stack<Property> children = new Stack<Property>();
        children.push(this._properties.get(index));
        while (!children.empty()) {
            Property property = (Property)children.pop();
            if (property == null) continue;
            root2.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (this.isValidIndex(index = property.getPreviousChildIndex())) {
                children.push(this._properties.get(index));
            }
            if (!this.isValidIndex(index = property.getNextChildIndex())) continue;
            children.push(this._properties.get(index));
        }
    }

    protected boolean isValidIndex(int index) {
        if (!Property.isValidIndex(index)) {
            return false;
        }
        if (index < 0 || index >= this._properties.size()) {
            _logger.log(5, "Property index " + index + "outside the valid range 0.." + this._properties.size());
            return false;
        }
        return true;
    }

    public int getStartBlock() {
        return this._header_block.getPropertyStart();
    }

    @Override
    public void setStartBlock(int index) {
        this._header_block.setPropertyStart(index);
    }
}

