/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookFactory {
    public static Workbook create(POIFSFileSystem fs) throws IOException {
        return new HSSFWorkbook(fs);
    }

    public static Workbook create(NPOIFSFileSystem fs) throws IOException {
        try {
            return WorkbookFactory.create(fs, null);
        }
        catch (InvalidFormatException e2) {
            throw new IOException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook create(NPOIFSFileSystem fs, String password) throws IOException, InvalidFormatException {
        DirectoryNode root2 = fs.getRoot();
        if (root2.hasEntry("EncryptedPackage")) {
            InputStream stream = DocumentFactoryHelper.getDecryptedStream(fs, password);
            OPCPackage pkg = OPCPackage.open(stream);
            return WorkbookFactory.create(pkg);
        }
        boolean passwordSet = false;
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
            passwordSet = true;
        }
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(root2, true);
            return hSSFWorkbook;
        }
        finally {
            if (passwordSet) {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }

    public static Workbook create(OPCPackage pkg) throws IOException {
        return new XSSFWorkbook(pkg);
    }

    public static Workbook create(InputStream inp) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(inp, null);
    }

    public static Workbook create(InputStream inp, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        InputStream is = FileMagic.prepareToCheckMagic(inp);
        FileMagic fm = FileMagic.valueOf(is);
        switch (fm) {
            case OLE2: {
                NPOIFSFileSystem fs = new NPOIFSFileSystem(is);
                return WorkbookFactory.create(fs, password);
            }
            case OOXML: {
                return new XSSFWorkbook(OPCPackage.open(is));
            }
        }
        throw new InvalidFormatException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Workbook create(File file) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, null);
    }

    public static Workbook create(File file, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, password, false);
    }

    public static Workbook create(File file, String password, boolean readOnly) throws IOException, InvalidFormatException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(file, readOnly);
            try {
                return WorkbookFactory.create(fs, password);
            }
            catch (RuntimeException e2) {
                IOUtils.closeQuietly(fs);
                throw e2;
            }
        }
        catch (OfficeXmlFileException e3) {
            OPCPackage pkg = OPCPackage.open(file, readOnly ? PackageAccess.READ : PackageAccess.READ_WRITE);
            try {
                return new XSSFWorkbook(pkg);
            }
            catch (Exception ioe) {
                pkg.revert();
                if (ioe instanceof IOException) {
                    throw (IOException)ioe;
                }
                if (ioe instanceof RuntimeException) {
                    throw (RuntimeException)ioe;
                }
                throw new IOException(ioe);
            }
        }
    }
}

