/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.simple.JsonKey;
import org.json.simple.Jsonable;
import org.json.simple.Jsoner;

public class JsonObject
extends HashMap<String, Object>
implements Jsonable {
    private static final long serialVersionUID = 2L;

    public JsonObject() {
    }

    public JsonObject(Map<String, ?> map) {
        super(map);
    }

    public void requireKeys(JsonKey ... keys) {
        HashSet<JsonKey> missing = new HashSet<JsonKey>();
        for (JsonKey k : keys) {
            if (this.containsKey(k.getKey())) continue;
            missing.add(k);
        }
        if (!missing.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (JsonKey k : missing) {
                sb.append(k.getKey()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            String s2 = missing.size() > 1 ? "s" : "";
            throw new NoSuchElementException("A JsonObject is missing required key" + s2 + ": " + sb.toString());
        }
    }

    public BigDecimal getBigDecimal(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    @Deprecated
    public BigDecimal getBigDecimal(String key) {
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public BigDecimal getBigDecimalOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    @Deprecated
    public BigDecimal getBigDecimalOrDefault(String key, BigDecimal defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public Boolean getBoolean(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    @Deprecated
    public Boolean getBoolean(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Boolean getBooleanOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    @Deprecated
    public Boolean getBooleanOrDefault(String key, boolean defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable instanceof String) {
            returnable = Boolean.valueOf((String)returnable);
        }
        return (Boolean)returnable;
    }

    public Byte getByte(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    @Deprecated
    public Byte getByte(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public Byte getByteOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    @Deprecated
    public Byte getByteOrDefault(String key, byte defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).byteValue();
    }

    public <T extends Collection<?>> T getCollection(JsonKey key) {
        return (T)((Collection)this.get(key.getKey()));
    }

    @Deprecated
    public <T extends Collection<?>> T getCollection(String key) {
        return (T)((Collection)this.get(key));
    }

    public <T extends Collection<?>> T getCollectionOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        return (T)((Collection)returnable);
    }

    @Deprecated
    public <T extends Collection<?>> T getCollectionOrDefault(String key, T defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        return (T)((Collection)returnable);
    }

    public Double getDouble(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    @Deprecated
    public Double getDouble(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    public Double getDoubleOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    @Deprecated
    public Double getDoubleOrDefault(String key, double defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).doubleValue();
    }

    @Deprecated
    public <T extends Enum<T>> T getEnum(JsonKey key) throws ClassNotFoundException {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        String[] splitValues = value.split("\\.");
        int numberOfSplitValues = splitValues.length;
        StringBuilder returnTypeName = new StringBuilder();
        StringBuilder enumName = new StringBuilder();
        for (int i = 0; i < numberOfSplitValues; ++i) {
            if (i == numberOfSplitValues - 1) {
                enumName.append(splitValues[i]);
                continue;
            }
            if (i == numberOfSplitValues - 2) {
                returnTypeName.append(splitValues[i]);
                continue;
            }
            returnTypeName.append(splitValues[i]);
            returnTypeName.append(".");
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    @Deprecated
    public <T extends Enum<T>> T getEnum(String key) throws ClassNotFoundException {
        String value = this.getStringOrDefault(key, "");
        if (value == null) {
            return null;
        }
        String[] splitValues = value.split("\\.");
        int numberOfSplitValues = splitValues.length;
        StringBuilder returnTypeName = new StringBuilder();
        StringBuilder enumName = new StringBuilder();
        for (int i = 0; i < numberOfSplitValues; ++i) {
            if (i == numberOfSplitValues - 1) {
                enumName.append(splitValues[i]);
                continue;
            }
            if (i == numberOfSplitValues - 2) {
                returnTypeName.append(splitValues[i]);
                continue;
            }
            returnTypeName.append(splitValues[i]);
            returnTypeName.append(".");
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    @Deprecated
    public <T extends Enum<T>> T getEnumOrDefault(JsonKey key) throws ClassNotFoundException {
        Enum returnable;
        if (this.containsKey(key)) {
            String value = this.getStringOrDefault(key.getKey(), "");
            if (value == null) {
                return null;
            }
            String[] splitValues = value.split("\\.");
            int numberOfSplitValues = splitValues.length;
            StringBuilder returnTypeName = new StringBuilder();
            StringBuilder enumName = new StringBuilder();
            for (int i = 0; i < numberOfSplitValues; ++i) {
                if (i == numberOfSplitValues - 1) {
                    enumName.append(splitValues[i]);
                    continue;
                }
                if (i == numberOfSplitValues - 2) {
                    returnTypeName.append(splitValues[i]);
                    continue;
                }
                returnTypeName.append(splitValues[i]);
                returnTypeName.append(".");
            }
            Class<?> returnType = Class.forName(returnTypeName.toString());
            returnable = Enum.valueOf(returnType, enumName.toString());
        } else {
            returnable = (Enum)key.getValue();
        }
        return (T)returnable;
    }

    @Deprecated
    public <T extends Enum<T>> T getEnumOrDefault(String key, T defaultValue) throws ClassNotFoundException {
        StringBuilder enumName;
        StringBuilder returnTypeName;
        if (this.containsKey(key)) {
            String value = this.getStringOrDefault(key, "");
            if (value == null) {
                return null;
            }
            String[] splitValues = value.split("\\.");
            int numberOfSplitValues = splitValues.length;
            returnTypeName = new StringBuilder();
            enumName = new StringBuilder();
            for (int i = 0; i < numberOfSplitValues; ++i) {
                if (i == numberOfSplitValues - 1) {
                    enumName.append(splitValues[i]);
                    continue;
                }
                if (i == numberOfSplitValues - 2) {
                    returnTypeName.append(splitValues[i]);
                    continue;
                }
                returnTypeName.append(splitValues[i]);
                returnTypeName.append(".");
            }
        } else {
            return defaultValue;
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    public Float getFloat(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    @Deprecated
    public Float getFloat(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Float getFloatOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    @Deprecated
    public Float getFloatOrDefault(String key, float defaultValue) {
        if (!this.containsKey(key)) {
            return Float.valueOf(defaultValue);
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Integer getInteger(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    @Deprecated
    public Integer getInteger(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Integer getIntegerOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    @Deprecated
    public Integer getIntegerOrDefault(String key, int defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).intValue();
    }

    public Long getLong(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    @Deprecated
    public Long getLong(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public Long getLongOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    @Deprecated
    public Long getLongOrDefault(String key, long defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).longValue();
    }

    public <T extends Map<?, ?>> T getMap(JsonKey key) {
        return (T)((Map)this.get(key.getKey()));
    }

    @Deprecated
    public <T extends Map<?, ?>> T getMap(String key) {
        return (T)((Map)this.get(key));
    }

    public <T extends Map<?, ?>> T getMapOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        return (T)((Map)returnable);
    }

    @Deprecated
    public <T extends Map<?, ?>> T getMapOrDefault(String key, T defaultValue) {
        Object returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        return returnable;
    }

    public Short getShort(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    @Deprecated
    public Short getShort(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    public Short getShortOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    @Deprecated
    public Short getShortOrDefault(String key, short defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable == null) {
            return null;
        }
        if (returnable instanceof String) {
            returnable = new BigDecimal((String)returnable);
        }
        return ((Number)returnable).shortValue();
    }

    public String getString(JsonKey key) {
        Object returnable = this.get(key.getKey());
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    @Deprecated
    public String getString(String key) {
        Object returnable = this.get(key);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    public String getStringOrDefault(JsonKey key) {
        Object returnable = this.containsKey(key.getKey()) ? this.get(key.getKey()) : key.getValue();
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    @Deprecated
    public String getStringOrDefault(String key, String defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Object returnable = this.get(key);
        if (returnable instanceof Boolean) {
            returnable = returnable.toString();
        } else if (returnable instanceof Number) {
            returnable = returnable.toString();
        }
        return (String)returnable;
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstEntry = true;
        Iterator entries = this.entrySet().iterator();
        writable.write(123);
        while (entries.hasNext()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                writable.write(44);
            }
            Map.Entry entry = entries.next();
            writable.write(Jsoner.serialize(entry.getKey()));
            writable.write(58);
            writable.write(Jsoner.serialize(entry.getValue()));
        }
        writable.write(125);
    }
}

