/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.LicenseException;

public class LicenseExceptionJSONFile
extends AbstractJsonFile {
    private boolean deprecated;
    private LicenseException exception;

    public LicenseExceptionJSONFile() {
    }

    public LicenseExceptionJSONFile(LicenseException exception, boolean deprecated) {
        this.setException(exception, deprecated);
    }

    public void setException(LicenseException exception, boolean deprecated) {
        this.exception = exception;
        this.deprecated = deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    private Object isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("licenseExceptionId", this.exception.getLicenseExceptionId());
        jsonObject.put("name", this.exception.getName());
        String[] seeAlsos = this.exception.getSeeAlso();
        if (seeAlsos != null && seeAlsos.length > 0) {
            JSONArray seeAlsoArray = new JSONArray();
            for (String seeAlso : seeAlsos) {
                seeAlsoArray.add(seeAlso);
            }
            jsonObject.put("seeAlso", seeAlsoArray);
        }
        jsonObject.put("licenseComments", this.exception.getComment());
        jsonObject.put("licenseExceptionText", this.exception.getLicenseExceptionText().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        jsonObject.put("example", this.exception.getExample());
        jsonObject.put("isDeprecatedLicenseId", this.isDeprecated());
        return jsonObject;
    }
}

