/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;

@Deprecated
public class DOAPProject
implements Cloneable {
    public static final String UNKNOWN_URI = "UNKNOWN";
    private String name = null;
    private String homePage = null;
    private Node projectNode = null;
    private Resource projectResource = null;
    private Model model = null;
    private String uri = null;

    static DOAPProject getExistingProject(Model model, String projectUrl) throws InvalidSPDXAnalysisException {
        Resource projectResource = model.createResource(projectUrl);
        model.read(projectUrl);
        return new DOAPProject(model, projectResource.asNode());
    }

    public DOAPProject(Model model, Node node) throws InvalidSPDXAnalysisException {
        Triple t;
        this.model = model;
        this.projectNode = node;
        if (this.projectNode.isBlank()) {
            this.projectResource = model.createResource(new AnonId(node.getBlankNodeId()));
        } else if (this.projectNode.isURI()) {
            this.projectResource = model.createResource(node.getURI());
            this.uri = node.getURI();
        } else {
            throw new InvalidSPDXAnalysisException("Can not create a DOAP project from a literal node");
        }
        Node p = model.getProperty("http://usefulinc.com/ns/doap#", "name").asNode();
        Triple m3 = Triple.createMatch(this.projectNode, p, null);
        ExtendedIterator<Triple> tripleIter = model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.name = t.getObject().toString(false);
        }
        p = model.getProperty("http://usefulinc.com/ns/doap#", "homepage").asNode();
        m3 = Triple.createMatch(this.projectNode, p, null);
        tripleIter = model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.homePage = t.getObject().toString(false);
        }
    }

    public DOAPProject(String projectName, String homePage) {
        this.name = projectName;
        this.homePage = homePage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.projectNode != null && this.model != null) {
            Property p = this.model.createProperty("http://usefulinc.com/ns/doap#", "name");
            this.model.removeAll(this.projectResource, p, null);
            p = this.model.createProperty("http://usefulinc.com/ns/doap#", "name");
            this.projectResource.addProperty(p, name);
        }
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
        if (this.projectNode != null && this.model != null) {
            Property p = this.model.createProperty("http://usefulinc.com/ns/doap#", "homepage");
            this.model.removeAll(this.projectResource, p, null);
            if (homePage != null) {
                p = this.model.createProperty("http://usefulinc.com/ns/doap#", "homepage");
                Resource homePageResource = this.model.createResource(homePage);
                this.projectResource.addProperty(p, homePageResource);
            }
        }
    }

    public String getProjectUri() {
        if (this.projectNode == null) {
            if (this.uri == null || this.uri.isEmpty()) {
                return UNKNOWN_URI;
            }
            return this.uri;
        }
        if (this.projectNode.isURI()) {
            return this.projectNode.getURI();
        }
        return UNKNOWN_URI;
    }

    public Resource createResource(Model model) {
        Resource type = model.createResource("http://usefulinc.com/ns/doap#Project");
        Resource retval = this.uri != null && !this.uri.isEmpty() && !this.uri.equals(UNKNOWN_URI) ? model.createResource(this.uri, type) : model.createResource(type);
        this.populateModel(model, retval);
        return retval;
    }

    private void populateModel(Model model, Resource projectResource) {
        Property p;
        this.model = model;
        this.projectNode = projectResource.asNode();
        this.projectResource = projectResource;
        if (this.name != null) {
            p = model.createProperty("http://usefulinc.com/ns/doap#", "name");
            projectResource.addProperty(p, this.name);
        }
        if (this.homePage != null) {
            p = model.createProperty("http://usefulinc.com/ns/doap#", "homepage");
            projectResource.addProperty(p, this.homePage);
        }
    }

    public List<String> verify() {
        return Lists.newArrayList();
    }

    public void setUri(String uri) throws InvalidSPDXAnalysisException {
        if (this.projectResource != null && !this.projectResource.hasURI(uri)) {
            throw new InvalidSPDXAnalysisException("Can not set a URI value for a resource which has already been created.");
        }
        if (!uri.equals(UNKNOWN_URI) && !SpdxVerificationHelper.isValidUri(uri)) {
            throw new InvalidSPDXAnalysisException("Invalid URI for DOAP Project " + this.name + ": " + uri);
        }
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DOAPProject)) {
            return false;
        }
        DOAPProject compare = (DOAPProject)o;
        if (compare.getProjectUri() != null && this.getProjectUri() != null && !compare.getProjectUri().equals(UNKNOWN_URI) && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return this.getProjectUri().equals(compare.getProjectUri());
        }
        if (compare.getProjectUri() != null && !compare.getProjectUri().equals(UNKNOWN_URI) || this.getProjectUri() != null && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return false;
        }
        if (compare.getHomePage() != null && this.getHomePage() != null) {
            return compare.getHomePage().equals(this.getHomePage()) && compare.getName().equals(this.getName());
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (this.getProjectUri() != null && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return this.getProjectUri().hashCode();
        }
        if (this.getHomePage() != null) {
            return this.getHomePage().hashCode();
        }
        return super.hashCode();
    }

    public Resource getResource() {
        return this.projectResource;
    }

    public DOAPProject clone() {
        DOAPProject retval = new DOAPProject(this.getName(), this.getHomePage());
        if (this.getProjectUri() != null) {
            try {
                retval.setUri(this.getProjectUri());
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return retval;
    }
}

