/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.DOAPProject;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.SPDXChecksum;
import org.spdx.rdfparser.SPDXDocument;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.DuplicateExtractedLicenseIdException;
import org.spdx.rdfparser.license.LicenseInfoFactory;

@Deprecated
public class SPDXFile
implements Comparable<SPDXFile>,
Cloneable {
    static final Logger logger = LoggerFactory.getLogger(SPDXFile.class.getName());
    IModelContainer modelContainer;
    private Model model = null;
    private Resource resource = null;
    private String name;
    private AnyLicenseInfo concludedLicenses;
    private SPDXChecksum sha1;
    private String type;
    private AnyLicenseInfo[] seenLicenses;
    private String licenseComments;
    private String copyright;
    private DOAPProject[] artifactOf;
    private String comment = null;
    private SPDXFile[] fileDependencies;
    private String[] contributors;
    private String noticeText;
    public static final Map<String, String> FILE_TYPE_TO_RESOURCE = Maps.newHashMap();
    public static final Map<String, String> RESOURCE_TO_FILE_TYPE = Maps.newHashMap();

    public SPDXFile(IModelContainer modelContainer, Node fileNode) throws InvalidSPDXAnalysisException {
        Triple t;
        Triple t2;
        Triple t3;
        this.modelContainer = modelContainer;
        this.model = modelContainer.getModel();
        this.resource = RdfParserHelper.convertToResource(this.model, fileNode);
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
        Triple m3 = Triple.createMatch(fileNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            this.name = t3.getObject().toString(false);
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            this.sha1 = new SPDXChecksum(this.model, t3.getObject());
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileType").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t3 = (Triple)tripleIter.next();
            if (t3.getObject().isLiteral()) {
                this.type = t3.getObject().toString(false);
                continue;
            }
            if (t3.getObject().isURI()) {
                this.type = RESOURCE_TO_FILE_TYPE.get(t3.getObject().getURI());
                if (this.type != null) continue;
                throw new InvalidSPDXAnalysisException("Invalid URI for file type resource - must be one of the individual file types in http://spdx.org/rdf/terms");
            }
            throw new InvalidSPDXAnalysisException("Invalid file type property - must be a URI type specified in http://spdx.org/rdf/terms");
        }
        ArrayList<AnyLicenseInfo> alLic = Lists.newArrayList();
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(modelContainer, t2.getObject()));
        }
        if (alLic.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many concluded licenses for file");
        }
        if (alLic.size() == 0) {
            throw new InvalidSPDXAnalysisException("Missing required concluded license");
        }
        this.concludedLicenses = (AnyLicenseInfo)alLic.get(0);
        alLic.clear();
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(modelContainer, t2.getObject()));
        }
        this.seenLicenses = alLic.toArray(new AnyLicenseInfo[alLic.size()]);
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileDependency").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        ArrayList<SPDXFile> alDependencies = Lists.newArrayList();
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alDependencies.add(new SPDXFile(modelContainer, t.getObject()));
        }
        this.fileDependencies = alDependencies.toArray(new SPDXFile[alDependencies.size()]);
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseComments").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.licenseComments = t.getObject().toString(false);
        }
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "copyrightText").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            if (t.getObject().isURI()) {
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                    this.copyright = "NOASSERTION";
                    continue;
                }
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                    this.copyright = "NONE";
                    continue;
                }
                this.copyright = t.getObject().toString(false);
                continue;
            }
            this.copyright = t.getObject().toString(false);
        }
        p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            this.comment = ((Triple)tripleIter.next()).getObject().toString(false);
        }
        ArrayList<String> alContributors = Lists.newArrayList();
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileContributor").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            Triple t4 = (Triple)tripleIter.next();
            alContributors.add(t4.getObject().toString(false));
        }
        this.contributors = alContributors.toArray(new String[alContributors.size()]);
        ArrayList<DOAPProject> alProjects = Lists.newArrayList();
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "artifactOf").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            Triple t5 = (Triple)tripleIter.next();
            alProjects.add(new DOAPProject(this.model, t5.getObject()));
        }
        this.artifactOf = alProjects.toArray(new DOAPProject[alProjects.size()]);
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
        m3 = Triple.createMatch(fileNode, p, null);
        tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            this.noticeText = ((Triple)tripleIter.next()).getObject().toString(false);
        }
    }

    public Resource createResource(SPDXDocument doc, String uri) throws InvalidSPDXAnalysisException {
        this.modelContainer = doc;
        Model model = doc.getModel();
        Resource type = model.createResource("http://spdx.org/rdf/terms#File");
        Resource retval = SPDXFile.findFileResource(model, this);
        if (retval == null) {
            retval = model.createResource(uri, type);
        }
        this.populateModel(doc, retval);
        this.resource = retval;
        return retval;
    }

    private void populateModel(SPDXDocument doc, Resource fileResource) throws InvalidSPDXAnalysisException {
        Model model = doc.getModel();
        Property p = model.createProperty("http://spdx.org/rdf/terms#", "fileName");
        fileResource.addProperty(p, this.getName());
        p = model.createProperty("http://spdx.org/rdf/terms#", "checksum");
        model.removeAll(fileResource, p, null);
        if (this.sha1 != null) {
            Resource cksumResource = this.sha1.getResource();
            if (cksumResource == null) {
                cksumResource = this.sha1.createResource(model);
            }
            fileResource.addProperty(p, cksumResource);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileType");
        model.removeAll(fileResource, p, null);
        Resource fileTypeResource = SPDXFile.fileTypeStringToTypeResource(this.getType(), model);
        fileResource.addProperty(p, fileTypeResource);
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
        model.removeAll(fileResource, p, null);
        if (this.concludedLicenses != null) {
            Resource lic = this.concludedLicenses.createResource(doc);
            fileResource.addProperty(p, lic);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
        model.removeAll(fileResource, p, null);
        if (this.seenLicenses != null && this.seenLicenses.length > 0) {
            for (int i = 0; i < this.seenLicenses.length; ++i) {
                Resource lic = this.seenLicenses[i].createResource(doc);
                fileResource.addProperty(p, lic);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
        model.removeAll(fileResource, p, null);
        if (this.fileDependencies != null && this.fileDependencies.length > 0) {
            for (int i = 0; i < this.fileDependencies.length; ++i) {
                Resource dep = this.fileDependencies[i].getResource();
                if (dep == null && (dep = SPDXFile.findFileResource(model, this.fileDependencies[i])) == null) {
                    dep = this.fileDependencies[i].createResource(doc, doc.getDocumentNamespace() + doc.getNextSpdxElementRef());
                }
                fileResource.addProperty(p, dep);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
        model.removeAll(fileResource, p, null);
        if (this.licenseComments != null) {
            fileResource.addProperty(p, this.getLicenseComments());
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
        model.removeAll(fileResource, p, null);
        if (this.copyright != null) {
            Resource r;
            if (this.copyright.equals("NONE")) {
                r = model.createResource("http://spdx.org/rdf/terms#none");
                fileResource.addProperty(p, r);
            } else if (this.copyright.equals("NOASSERTION")) {
                r = model.createResource("http://spdx.org/rdf/terms#noassertion");
                fileResource.addProperty(p, r);
            } else {
                fileResource.addProperty(p, this.getCopyright());
            }
        }
        p = model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
        model.removeAll(fileResource, p, null);
        if (this.comment != null) {
            fileResource.addProperty(p, this.comment);
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
        model.removeAll(fileResource, p, null);
        if (this.artifactOf != null) {
            p = model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            for (int i = 0; i < this.artifactOf.length; ++i) {
                Resource projectResource = this.artifactOf[i].createResource(model);
                fileResource.addProperty(p, projectResource);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
        model.removeAll(fileResource, p, null);
        if (this.contributors != null) {
            for (int i = 0; i < this.contributors.length; ++i) {
                fileResource.addProperty(p, this.contributors[i]);
            }
        }
        p = model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
        model.removeAll(fileResource, p, null);
        if (this.noticeText != null) {
            fileResource.addProperty(p, this.getNoticeText());
        }
        this.model = model;
        this.resource = fileResource;
    }

    protected static Resource findFileResource(Model model, SPDXFile spdxFile) throws InvalidSPDXAnalysisException {
        Node fileNameProperty = model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
        Triple fileNameMatch = Triple.createMatch(null, fileNameProperty, NodeFactory.createLiteral(spdxFile.getName()));
        ExtendedIterator<Triple> filenameMatchIter = model.getGraph().find(fileNameMatch);
        if (filenameMatchIter.hasNext()) {
            Triple checksumMatchTriple;
            SPDXChecksum cksum;
            Triple fileMatchTriple = (Triple)filenameMatchIter.next();
            Node fileNode = fileMatchTriple.getSubject();
            Node checksumProperty = model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
            Triple checksumMatch = Triple.createMatch(fileNode, checksumProperty, null);
            ExtendedIterator<Triple> checksumMatchIterator = model.getGraph().find(checksumMatch);
            if (checksumMatchIterator.hasNext() && (cksum = new SPDXChecksum(model, (checksumMatchTriple = (Triple)checksumMatchIterator.next()).getObject())).getValue().compareToIgnoreCase(spdxFile.sha1.getValue()) == 0) {
                return RdfParserHelper.convertToResource(model, fileNode);
            }
        }
        return null;
    }

    public SPDXFile(String name, String type, String sha1, AnyLicenseInfo concludedLicenses, AnyLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf, String comment, SPDXFile[] fileDependencies, String[] contributors, String noticeText) {
        this.name = name;
        this.type = type;
        this.sha1 = new SPDXChecksum("SHA1", sha1);
        this.concludedLicenses = concludedLicenses;
        this.seenLicenses = seenLicenses;
        this.licenseComments = licenseComments;
        this.copyright = copyright;
        this.artifactOf = artifactOf;
        this.comment = comment;
        this.fileDependencies = fileDependencies == null ? new SPDXFile[0] : fileDependencies;
        this.contributors = contributors == null ? new String[0] : contributors;
        this.noticeText = noticeText;
    }

    public SPDXFile(String name, String type, String sha1, AnyLicenseInfo concludedLicenses, AnyLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf) {
        this(name, type, sha1, concludedLicenses, seenLicenses, licenseComments, copyright, artifactOf, null, null, null, null);
    }

    public SPDXFile(String name, String type, String sha1, AnyLicenseInfo concludedLicenses, AnyLicenseInfo[] seenLicenses, String licenseComments, String copyright, DOAPProject[] artifactOf, String comment) {
        this(name, type, sha1, concludedLicenses, seenLicenses, licenseComments, copyright, artifactOf, comment, null, null, null);
    }

    public AnyLicenseInfo[] getSeenLicenses() {
        if (this.model != null && this.resource != null) {
            try {
                ArrayList<Node> alLicNode = Lists.newArrayList();
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alLicNode.add(t.getObject());
                }
                boolean seenLicensesMatch = this.seenLicenses.length == alLicNode.size();
                int i = 0;
                while (seenLicensesMatch && i < this.seenLicenses.length) {
                    Resource licResource;
                    if ((licResource = this.seenLicenses[i++].getResource()) == null) {
                        seenLicensesMatch = false;
                        continue;
                    }
                    boolean found = false;
                    for (int j = 0; j < alLicNode.size(); ++j) {
                        if (!((Node)alLicNode.get(j)).equals(licResource.asNode())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    seenLicensesMatch = false;
                }
                if (!seenLicensesMatch) {
                    this.seenLicenses = new AnyLicenseInfo[alLicNode.size()];
                    int k = 0;
                    while (i < this.seenLicenses.length) {
                        this.seenLicenses[k] = LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, (Node)alLicNode.get(k));
                        ++k;
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.seenLicenses;
    }

    public void setSeenLicenses(AnyLicenseInfo[] seenLicenses) throws InvalidSPDXAnalysisException {
        this.seenLicenses = seenLicenses;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoInFile");
            for (int i = 0; i < seenLicenses.length; ++i) {
                Resource lic;
                try {
                    lic = seenLicenses[i].createResource(this.modelContainer);
                }
                catch (DuplicateExtractedLicenseIdException e2) {
                    throw new InvalidSPDXAnalysisException("Seen licenses contains a non-standard license ID  which already exists in the model with different license text:" + seenLicenses[i].toString());
                }
                this.resource.addProperty(p, lic);
            }
        }
    }

    public String getLicenseComments() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseComments").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                this.licenseComments = t.getObject().toString(false);
            }
        }
        return this.licenseComments;
    }

    public void setLicenseComments(String licenseComments) {
        this.licenseComments = licenseComments;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseComments");
            this.resource.addProperty(p, this.getLicenseComments());
        }
    }

    public String getNoticeText() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                this.noticeText = ((Triple)tripleIter.next()).getObject().toString(false);
            }
        }
        return this.noticeText;
    }

    public void setNoticeText(String noticeText) {
        this.noticeText = noticeText;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
            this.model.removeAll(this.resource, p, null);
            if (this.noticeText != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "noticeText");
                this.resource.addProperty(p, this.getNoticeText());
            }
        }
    }

    public String getComment() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                this.comment = ((Triple)tripleIter.next()).getObject().toString(false);
            }
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.resource.addProperty(p, this.comment);
        }
    }

    public String getCopyright() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "copyrightText").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                if (t.getObject().isURI()) {
                    if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                        this.copyright = "NOASSERTION";
                        continue;
                    }
                    if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                        this.copyright = "NONE";
                        continue;
                    }
                    this.copyright = t.getObject().toString(false);
                    continue;
                }
                this.copyright = t.getObject().toString(false);
            }
        }
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "copyrightText");
            if (copyright.equals("NONE")) {
                Resource r = this.model.createResource("http://spdx.org/rdf/terms#none");
                this.resource.addProperty(p, r);
            } else if (copyright.equals("NOASSERTION")) {
                Resource r = this.model.createResource("http://spdx.org/rdf/terms#noassertion");
                this.resource.addProperty(p, r);
            } else {
                this.resource.addProperty(p, this.getCopyright());
            }
        }
    }

    public String getName() {
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                this.name = t.getObject().toString(false);
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileName");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileName");
            this.resource.addProperty(p, this.getName());
        }
    }

    public AnyLicenseInfo getConcludedLicenses() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                Triple t = null;
                while (tripleIter.hasNext()) {
                    t = (Triple)tripleIter.next();
                    if (this.concludedLicenses == null || !t.getObject().equals(this.concludedLicenses.getResource().asNode())) continue;
                }
                if (this.concludedLicenses == null || !t.getObject().equals(this.concludedLicenses.getResource().asNode())) {
                    this.concludedLicenses = LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject());
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.concludedLicenses;
    }

    public void setConcludedLicenses(AnyLicenseInfo fileLicenses) throws InvalidSPDXAnalysisException {
        this.concludedLicenses = fileLicenses;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
            Resource lic = null;
            try {
                lic = fileLicenses.createResource(this.modelContainer);
            }
            catch (DuplicateExtractedLicenseIdException e2) {
                throw new InvalidSPDXAnalysisException("Concluded licenses contains a non-standard license with inconsistent text with                                    an existing license: " + fileLicenses.toString());
            }
            this.resource.addProperty(p, lic);
        }
    }

    public String getSha1() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                Triple t = null;
                while (tripleIter.hasNext()) {
                    t = (Triple)tripleIter.next();
                    if (this.sha1 == null || !this.nodesEquals(this.sha1.getResource().asNode(), t.getObject())) continue;
                }
                if (this.sha1 == null || !this.nodesEquals(this.sha1.getResource().asNode(), t.getObject())) {
                    this.sha1 = new SPDXChecksum(this.model, t.getObject());
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.sha1.getValue();
    }

    private boolean nodesEquals(Node n1, Node n2) {
        return n1.equals(n2);
    }

    public void setSha1(String sha1) {
        this.sha1 = new SPDXChecksum("SHA1", sha1);
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
            this.model.removeAll(this.resource, p, null);
            Resource cksumResource = this.sha1.createResource(this.model);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
            this.resource.addProperty(p, cksumResource);
        }
    }

    public String getType() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileType").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    if (t.getObject().isLiteral()) {
                        this.type = t.getObject().toString(false);
                        continue;
                    }
                    if (t.getObject().isURI()) {
                        this.type = RESOURCE_TO_FILE_TYPE.get(t.getObject().getURI());
                        if (this.type != null) continue;
                        throw new InvalidSPDXAnalysisException("Invalid URI for file type resource - must be one of the individual file types in http://spdx.org/rdf/terms");
                    }
                    throw new InvalidSPDXAnalysisException("Invalid file type property - must be a URI type specified in http://spdx.org/rdf/terms");
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.type;
    }

    public void setType(String type) throws InvalidSPDXAnalysisException {
        this.type = type;
        if (this.model != null && this.resource != null) {
            Resource typeResource = SPDXFile.fileTypeStringToTypeResource(type, this.model);
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileType");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileType");
            this.resource.addProperty(p, typeResource);
        }
    }

    public static Resource fileTypeStringToTypeResource(String fileType, Model model) throws InvalidSPDXAnalysisException {
        String resourceUri = FILE_TYPE_TO_RESOURCE.get(fileType);
        if (resourceUri == null) {
            throw new InvalidSPDXAnalysisException("Invalid file type: " + fileType);
        }
        Resource retval = model.createResource(resourceUri);
        return retval;
    }

    public static String fileTypeResourceToString(Resource fileTypeResource) throws InvalidSPDXAnalysisException {
        if (!fileTypeResource.isURIResource()) {
            throw new InvalidSPDXAnalysisException("File type resource must be a URI.");
        }
        String retval = fileTypeResource.getURI();
        if (retval == null) {
            throw new InvalidSPDXAnalysisException("Not a recognized file type for an SPDX document.");
        }
        return retval;
    }

    public DOAPProject[] getArtifactOf() {
        if (this.model != null && this.resource != null) {
            try {
                int i;
                ArrayList<Node> alProjectNodes = Lists.newArrayList();
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "artifactOf").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alProjectNodes.add(t.getObject());
                }
                ArrayList<DOAPProject> alProjects = Lists.newArrayList();
                boolean projectsDifferent = this.artifactOf.length != alProjectNodes.size();
                for (i = 0; i < this.artifactOf.length; ++i) {
                    Resource projectResource = this.artifactOf[i].getResource();
                    if (projectResource == null) {
                        projectsDifferent = true;
                        continue;
                    }
                    boolean found = false;
                    for (int j = 0; j < alProjectNodes.size(); ++j) {
                        if (!((Node)alProjectNodes.get(j)).equals(projectResource.asNode())) continue;
                        found = true;
                        alProjects.add(this.artifactOf[i]);
                        alProjectNodes.remove(j);
                        break;
                    }
                    if (found) continue;
                    projectsDifferent = true;
                }
                if (projectsDifferent) {
                    for (i = 0; i < alProjectNodes.size(); ++i) {
                        alProjects.add(new DOAPProject(this.model, (Node)alProjectNodes.get(i)));
                    }
                    this.artifactOf = alProjects.toArray(new DOAPProject[alProjects.size()]);
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.artifactOf;
    }

    public void setArtifactOf(DOAPProject[] artifactOf) {
        this.artifactOf = artifactOf;
        if (this.model != null && this.resource != null && this.name != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "artifactOf");
            for (int i = 0; i < artifactOf.length; ++i) {
                Resource projectResource = null;
                String uri = artifactOf[i].getProjectUri();
                projectResource = uri != null && !uri.isEmpty() && !uri.equals("UNKNOWN") ? this.model.createResource(uri) : artifactOf[i].createResource(this.model);
                this.resource.addProperty(p, projectResource);
            }
        }
    }

    public List<String> verify() {
        int count;
        ExtendedIterator<Triple> tripleIter;
        Triple m3;
        String checksum;
        int i;
        String fileType;
        ArrayList<String> retval = Lists.newArrayList();
        String fileName = this.getName();
        if (fileName == null || fileName.isEmpty()) {
            retval.add("Missing required name for file");
            fileName = "UNKNOWN";
        }
        if ((fileType = this.getType()) == null || fileType.isEmpty()) {
            retval.add("Missing required file type");
        } else {
            String verifyFileType = SpdxVerificationHelper.verifyFileType(fileType);
            if (verifyFileType != null) {
                retval.add(verifyFileType + "; File - " + fileName);
            }
        }
        String copyrightText = this.getCopyright();
        if (copyrightText == null || copyrightText.isEmpty()) {
            retval.add("Missing required copyright text for file " + fileName);
        }
        this.getLicenseComments();
        AnyLicenseInfo concludedLicense = this.getConcludedLicenses();
        if (concludedLicense == null) {
            retval.add("Missing required concluded license for file " + fileName);
        } else {
            retval.addAll(concludedLicense.verify());
        }
        AnyLicenseInfo[] licenseInfosInFile = this.getSeenLicenses();
        if (licenseInfosInFile == null || licenseInfosInFile.length == 0) {
            retval.add("Missing required license information in file for file " + fileName);
        } else {
            for (i = 0; i < licenseInfosInFile.length; ++i) {
                retval.addAll(licenseInfosInFile[i].verify());
            }
        }
        if (this.fileDependencies != null) {
            for (i = 0; i < this.fileDependencies.length; ++i) {
                List<String> verifyFileDependency = this.fileDependencies[i].verify();
                for (int j = 0; j < verifyFileDependency.size(); ++j) {
                    retval.add("Invalid file dependency for file named " + this.fileDependencies[i].getName() + ": " + verifyFileDependency.get(j));
                }
            }
        }
        if ((checksum = this.getSha1()) == null || checksum.isEmpty()) {
            retval.add("Missing required checksum for file " + fileName);
        } else {
            String verify = SpdxVerificationHelper.verifyChecksumString(checksum);
            if (verify != null) {
                retval.add(verify + "; file " + fileName);
            }
        }
        DOAPProject[] projects = this.getArtifactOf();
        if (projects != null) {
            for (int i2 = 0; i2 < projects.length; ++i2) {
                retval.addAll(projects[i2].verify());
            }
        }
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
            m3 = Triple.createMatch(this.resource.asNode(), p, null);
            tripleIter = this.model.getGraph().find(m3);
            count = 0;
            while (tripleIter.hasNext()) {
                tripleIter.next();
                ++count;
            }
            if (count > 1) {
                retval.add("More than one file comment for file " + this.name);
            }
        }
        if (this.model != null && this.resource != null) {
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "noticeText").asNode();
            m3 = Triple.createMatch(this.resource.asNode(), p, null);
            tripleIter = this.model.getGraph().find(m3);
            count = 0;
            while (tripleIter.hasNext()) {
                tripleIter.next();
                ++count;
            }
            if (count > 1) {
                retval.add("More than one file notice for file " + this.name);
            }
        }
        return retval;
    }

    public SPDXFile[] getFileDependencies() {
        if (this.model != null && this.resource != null) {
            try {
                Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileDependency").asNode();
                Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
                ArrayList<Node> alDependencyNodes = Lists.newArrayList();
                ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
                while (tripleIter.hasNext()) {
                    Triple t = (Triple)tripleIter.next();
                    alDependencyNodes.add(t.getObject());
                }
                boolean fileDependenciesMatch = this.fileDependencies.length == alDependencyNodes.size();
                int i = 0;
                while (i < this.fileDependencies.length && fileDependenciesMatch) {
                    Resource fileDependencyResource;
                    if ((fileDependencyResource = this.fileDependencies[i++].getResource()) == null) {
                        fileDependenciesMatch = false;
                        continue;
                    }
                    Node fileDependancyNode = fileDependencyResource.asNode();
                    boolean found = false;
                    for (int j = 0; j < alDependencyNodes.size(); ++j) {
                        if (!((Node)alDependencyNodes.get(j)).equals(fileDependancyNode)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fileDependenciesMatch = false;
                }
                if (!fileDependenciesMatch) {
                    this.fileDependencies = new SPDXFile[alDependencyNodes.size()];
                    for (int k = 0; k < this.fileDependencies.length; ++k) {
                        this.fileDependencies[k] = new SPDXFile(this.modelContainer, (Node)alDependencyNodes.get(k));
                    }
                }
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return this.fileDependencies;
    }

    public void setFileDependencies(SPDXFile[] fileDependencies, SPDXDocument doc) throws InvalidSPDXAnalysisException {
        this.fileDependencies = fileDependencies == null ? new SPDXFile[0] : fileDependencies;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileDependency");
            for (int i = 0; i < this.fileDependencies.length; ++i) {
                Resource dep = this.fileDependencies[i].getResource();
                if (dep == null) {
                    dep = this.fileDependencies[i].createResource(doc, doc.getDocumentNamespace() + doc.getNextSpdxElementRef());
                }
                this.resource.addProperty(p, dep);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SPDXFile)) {
            return false;
        }
        SPDXFile compareFile = (SPDXFile)o;
        if (this.model != null && this.resource != null) {
            Resource compareFileResource = compareFile.getResource();
            return this.resourcesEqual(this.resource, compareFileResource);
        }
        Resource compareFileResource = compareFile.getResource();
        if (compareFileResource != null) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (this.model != null && this.resource != null) {
            if (this.resource.isAnon()) {
                return this.resource.getId().hashCode();
            }
            if (this.resource.isURIResource()) {
                return this.resource.getURI().hashCode();
            }
            return this.resource.hashCode();
        }
        return super.hashCode();
    }

    private boolean resourcesEqual(Resource r1, Resource r2) {
        if (r2 == null) {
            return false;
        }
        if (r1.isAnon()) {
            if (!r2.isAnon()) {
                return false;
            }
            return r1.getId().equals(r2.getId());
        }
        if (!r2.isURIResource()) {
            return false;
        }
        return r1.getURI().equals(r2.getURI());
    }

    protected Resource getResource() {
        if (this.model == null) {
            return null;
        }
        return this.resource;
    }

    public String[] getContributors() {
        if (this.model != null && this.resource != null) {
            ArrayList<String> alContributors = Lists.newArrayList();
            Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "fileContributor").asNode();
            Triple m3 = Triple.createMatch(this.resource.asNode(), p, null);
            ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alContributors.add(t.getObject().toString(false));
            }
            this.contributors = alContributors.toArray(new String[alContributors.size()]);
        }
        return this.contributors;
    }

    public void setContributors(String[] contributors) {
        this.contributors = contributors == null ? new String[0] : contributors;
        if (this.model != null && this.resource != null) {
            Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
            this.model.removeAll(this.resource, p, null);
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "fileContributor");
            for (int i = 0; i < this.contributors.length; ++i) {
                this.resource.addProperty(p, this.contributors[i]);
            }
        }
    }

    @Override
    public int compareTo(SPDXFile file) {
        return this.getName().compareTo(file.getName());
    }

    public SPDXFile clone(SPDXDocument doc, String fileUri) throws InvalidSPDXAnalysisException {
        SPDXFile retval = this.clone();
        retval.createResource(doc, fileUri);
        return retval;
    }

    public SPDXFile clone() {
        AnyLicenseInfo[] clonedSeenLicenses;
        DOAPProject[] cloneArtifactOfs;
        SPDXFile[] cloneFileDependencies;
        if (this.fileDependencies == null) {
            cloneFileDependencies = new SPDXFile[]{};
        } else {
            cloneFileDependencies = new SPDXFile[this.fileDependencies.length];
            for (int i = 0; i < cloneFileDependencies.length; ++i) {
                cloneFileDependencies[i] = this.fileDependencies[i].clone();
            }
        }
        if (this.artifactOf == null) {
            cloneArtifactOfs = new DOAPProject[]{};
        } else {
            cloneArtifactOfs = new DOAPProject[this.artifactOf.length];
            for (int i = 0; i < cloneArtifactOfs.length; ++i) {
                cloneArtifactOfs[i] = this.artifactOf[i].clone();
            }
        }
        AnyLicenseInfo clonedConcludedLicense = this.concludedLicenses.clone();
        if (this.seenLicenses == null) {
            clonedSeenLicenses = new AnyLicenseInfo[]{};
        } else {
            clonedSeenLicenses = new AnyLicenseInfo[this.seenLicenses.length];
            for (int i = 0; i < clonedSeenLicenses.length; ++i) {
                if (this.seenLicenses[i] == null) continue;
                clonedSeenLicenses[i] = this.seenLicenses[i].clone();
            }
        }
        SPDXChecksum clonedChecksum = this.sha1.clone();
        return new SPDXFile(this.getName(), this.getType(), clonedChecksum.getValue(), clonedConcludedLicense, clonedSeenLicenses, this.getLicenseComments(), this.getCopyright(), cloneArtifactOfs, this.getComment(), cloneFileDependencies, this.getContributors(), this.getNoticeText());
    }

    public boolean equivalent(SPDXFile compareToFile) {
        if (!SpdxVerificationHelper.equivalentArray(this.artifactOf, compareToFile.getArtifactOf())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.comment, compareToFile.getComment())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.concludedLicenses, compareToFile.getConcludedLicenses())) {
            return false;
        }
        if (!SpdxVerificationHelper.equivalentArray(this.contributors, compareToFile.getContributors())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.copyright, compareToFile.getCopyright())) {
            return false;
        }
        if (!this.equivalentFileDependencies(this.fileDependencies, compareToFile.getFileDependencies())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.licenseComments, compareToFile.getLicenseComments())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.name, compareToFile.getName())) {
            return false;
        }
        if (!SpdxVerificationHelper.equalsWithNull(this.noticeText, compareToFile.getNoticeText())) {
            return false;
        }
        if (!SpdxVerificationHelper.equivalentArray(this.seenLicenses, compareToFile.getSeenLicenses())) {
            return false;
        }
        if (this.sha1 == null) {
            if (compareToFile.getSha1() != null) {
                return false;
            }
        } else {
            if (compareToFile.getSha1() == null) {
                return false;
            }
            if (!SpdxVerificationHelper.equalsWithNull(this.sha1.getValue(), compareToFile.getSha1())) {
                return false;
            }
        }
        return SpdxVerificationHelper.equalsWithNull(this.type, compareToFile.getType());
    }

    private boolean equivalentFileDependencies(SPDXFile[] dependencies1, SPDXFile[] dependencies2) {
        if (dependencies1 == null) {
            return dependencies2 == null;
        }
        if (dependencies2 == null) {
            return false;
        }
        if (dependencies1.length != dependencies2.length) {
            return false;
        }
        for (int i = 0; i < dependencies1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < dependencies2.length; ++j) {
                if (!dependencies1[i].equivalent(dependencies2[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    static {
        FILE_TYPE_TO_RESOURCE.put("SOURCE", "http://spdx.org/rdf/terms#fileType_source");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_source", "SOURCE");
        FILE_TYPE_TO_RESOURCE.put("BINARY", "http://spdx.org/rdf/terms#fileType_binary");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_binary", "BINARY");
        FILE_TYPE_TO_RESOURCE.put("ARCHIVE", "http://spdx.org/rdf/terms#fileType_archive");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_archive", "ARCHIVE");
        FILE_TYPE_TO_RESOURCE.put("OTHER", "http://spdx.org/rdf/terms#fileType_other");
        RESOURCE_TO_FILE_TYPE.put("http://spdx.org/rdf/terms#fileType_other", "OTHER");
    }
}

