/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.license.DisjunctiveLicenseSet;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseExpressionParser;
import org.spdx.rdfparser.license.LicenseParserException;
import org.spdx.rdfparser.license.ListedExceptions;
import org.spdx.rdfparser.license.ListedLicenses;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.rdfparser.license.WithExceptionOperator;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class LicenseInfoFactory {
    static final Logger logger = LoggerFactory.getLogger(LicenseInfoFactory.class.getName());
    public static final String NOASSERTION_LICENSE_NAME = "NOASSERTION";
    public static final String NONE_LICENSE_NAME = "NONE";

    public static AnyLicenseInfo getLicenseInfoFromModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (!node.isURI() && !node.isBlank()) {
            throw new InvalidSPDXAnalysisException("Can not create a LicenseInfo from a literal node");
        }
        AnyLicenseInfo retval = null;
        if (node.isURI()) {
            retval = LicenseInfoFactory.getLicenseInfoByUri(modelContainer, node);
        }
        if (retval == null) {
            retval = LicenseInfoFactory.getLicenseInfoByType(modelContainer, node);
        }
        if (retval == null) {
            retval = LicenseInfoFactory.getLicenseInfoById(modelContainer, node);
        }
        if (retval == null) {
            logger.error("Could not determine the type for a license");
            throw new InvalidSPDXAnalysisException("Could not determine the type for a license");
        }
        return retval;
    }

    private static AnyLicenseInfo getLicenseInfoByUri(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (!node.isURI()) {
            return null;
        }
        if (node.getURI().equals("http://spdx.org/rdf/terms#none")) {
            return new SpdxNoneLicense(modelContainer, node);
        }
        if (node.getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
            return new SpdxNoAssertionLicense(modelContainer, node);
        }
        if (node.getURI().startsWith("http://spdx.org/licenses/")) {
            try {
                return ListedLicenses.getListedLicenses().getLicenseFromStdLicModel(modelContainer, node);
            }
            catch (Exception ex) {
                logger.warn("Unable to get license from SPDX listed license model for " + node.getURI());
                return null;
            }
        }
        return null;
    }

    public static SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedLicenseById(licenseId);
    }

    private static AnyLicenseInfo getLicenseInfoById(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Node licenseIdPredicate = modelContainer.getModel().getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
        Triple m3 = Triple.createMatch(node, licenseIdPredicate, null);
        ExtendedIterator<Triple> tripleIter = modelContainer.getModel().getGraph().find(m3);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            String id = triple.getObject().toString(false);
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one ID associated with license " + id);
            }
            if (LicenseInfoFactory.isSpdxListedLicenseID(id)) {
                return new SpdxListedLicense(modelContainer, node);
            }
            if (id.startsWith("LicenseRef-")) {
                return new ExtractedLicenseInfo(modelContainer, node);
            }
            return null;
        }
        throw new InvalidSPDXAnalysisException("No ID associated with a license");
    }

    private static AnyLicenseInfo getLicenseInfoByType(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = modelContainer.getModel().getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Triple m3 = Triple.createMatch(node, rdfTypePredicate, null);
        ExtendedIterator<Triple> tripleIter = modelContainer.getModel().getGraph().find(m3);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one type associated with a licenseInfo");
            }
            Node typeNode = triple.getObject();
            if (!typeNode.isURI()) {
                throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo - not a URI");
            }
            String typeUri = typeNode.getURI();
            if (!typeUri.startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo - not an SPDX type");
            }
            String type = typeUri.substring("http://spdx.org/rdf/terms#".length());
            if (type.equals("ConjunctiveLicenseSet")) {
                return new ConjunctiveLicenseSet(modelContainer, node);
            }
            if (type.equals("DisjunctiveLicenseSet")) {
                return new DisjunctiveLicenseSet(modelContainer, node);
            }
            if (type.equals("ExtractedLicensingInfo")) {
                return new ExtractedLicenseInfo(modelContainer, node);
            }
            if (type.equals("License")) {
                return new SpdxListedLicense(modelContainer, node);
            }
            if (type.equals("OrLaterOperator")) {
                return new OrLaterOperator(modelContainer, node);
            }
            if (type.equals("WithExceptionOperator")) {
                return new WithExceptionOperator(modelContainer, node);
            }
            throw new InvalidSPDXAnalysisException("Invalid type for licenseInfo '" + type + "'");
        }
        return null;
    }

    public static AnyLicenseInfo parseSPDXLicenseString(String licenseString, SpdxDocumentContainer container2) throws InvalidLicenseStringException {
        try {
            return LicenseExpressionParser.parseLicenseExpression(licenseString, container2);
        }
        catch (LicenseParserException e2) {
            throw new InvalidLicenseStringException(e2.getMessage(), e2);
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new InvalidLicenseStringException("Unexpected SPDX error parsing license string");
        }
    }

    public static AnyLicenseInfo parseSPDXLicenseString(String licenseString) throws InvalidLicenseStringException {
        return LicenseInfoFactory.parseSPDXLicenseString(licenseString, null);
    }

    public static boolean isSpdxListedLicenseID(String licenseID) {
        return ListedLicenses.getListedLicenses().isSpdxListedLicenseID(licenseID);
    }

    public static String[] getSpdxListedLicenseIds() {
        return ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
    }

    public static String getLicenseListVersion() {
        return ListedLicenses.getListedLicenses().getLicenseListVersion();
    }

    public static boolean isSPdxListedExceptionID(String id) {
        return ListedExceptions.getListedExceptions().isSpdxListedLExceptionID(id);
    }

    public static LicenseException getListedExceptionById(String id) throws InvalidSPDXAnalysisException {
        return ListedExceptions.getListedExceptions().getListedExceptionById(id);
    }
}

