/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.IRdfModel;

public abstract class LicenseSet
extends AnyLicenseInfo {
    protected Set<AnyLicenseInfo> licenseInfos = Sets.newHashSet();

    public LicenseSet(IModelContainer modelContainer, Node licenseInfoNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseInfoNode);
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
        Triple m3 = Triple.createMatch(licenseInfoNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            this.licenseInfos.add(LicenseInfoFactory.getLicenseInfoFromModel(modelContainer, t.getObject()));
        }
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.licenseInfos.clear();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "member").asNode();
        Triple m3 = Triple.createMatch(this.node, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m3);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            this.licenseInfos.add(LicenseInfoFactory.getLicenseInfoFromModel(this.modelContainer, t.getObject()));
        }
    }

    public LicenseSet(AnyLicenseInfo[] licenseInfos) {
        if (licenseInfos != null) {
            for (int i = 0; i < licenseInfos.length; ++i) {
                this.licenseInfos.add(licenseInfos[i]);
            }
        }
    }

    public void setMembers(AnyLicenseInfo[] licenseInfos) throws InvalidSPDXAnalysisException {
        this.licenseInfos.clear();
        if (licenseInfos != null) {
            for (int i = 0; i < licenseInfos.length; ++i) {
                this.licenseInfos.add(licenseInfos[i]);
            }
        }
        if (this.model != null && this.node != null) {
            Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            this.model.removeAll(this.resource, licProperty, null);
            licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
            for (int i = 0; i < licenseInfos.length; ++i) {
                Resource licResource = licenseInfos[i].createResource(this.modelContainer);
                this.resource.addProperty(licProperty, licResource);
            }
        }
    }

    public AnyLicenseInfo[] getMembers() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.getPropertiesFromModel();
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.warn("Error getting properites from model, using stored values.", e2);
            }
        }
        AnyLicenseInfo[] retval = new AnyLicenseInfo[this.licenseInfos.size()];
        retval = this.licenseInfos.toArray(retval);
        return retval;
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        Iterator<AnyLicenseInfo> iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            retval.addAll(iter.next().verify());
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof LicenseSet)) {
            return false;
        }
        return RdfModelHelper.arraysEquivalent(this.getMembers(), ((LicenseSet)compare).getMembers());
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        Property licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        this.model.removeAll(this.resource, licProperty, null);
        licProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "member");
        for (AnyLicenseInfo licenseInfo : this.licenseInfos) {
            Resource licResource = licenseInfo.createResource(this.modelContainer);
            this.resource.addProperty(licProperty, licResource);
        }
    }
}

