/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ExceptionJsonTOC;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.ListedLicenses;
import org.spdx.rdfparser.license.NoListedLicenseRdfModel;
import org.spdx.rdfparser.model.IRdfModel;

public class ListedExceptions
implements IModelContainer {
    static final Logger logger = LoggerFactory.getLogger(ListedExceptions.class.getName());
    static final String LISTED_LICENSE_ID_URL = "http://spdx.org/licenses/";
    private static final String EXCEPTION_TOC_FILENAME = "exceptions.json";
    private Model listedExceptionModel = null;
    Set<String> listdExceptionIds = null;
    Map<String, ListedLicenseException> listedExceptionCache = null;
    Map<IModelContainer, Map<Node, ListedLicenseException>> listedExceptionNodeCache = Maps.newHashMap();
    boolean onlyUseLocalLicenses;
    File localLicensesDir = null;
    String licenseListVersion = "3.5";
    private static volatile ListedExceptions listedExceptions = null;
    private static final ReadWriteLock listedExceptionModificationLock = new ReentrantReadWriteLock();
    private static final String JSONLD_URL_SUFFIX = ".jsonld";
    int nextId = 0;

    private ListedExceptions() {
        this.onlyUseLocalLicenses = ListedLicenses.getListedLicenses().onlyUseLocalLicenses;
        this.localLicensesDir = ListedLicenses.getListedLicenses().localLicensesDir;
        this.loadListedExceptionIDs();
    }

    public static ListedExceptions getListedExceptions() {
        if (listedExceptions == null) {
            listedExceptionModificationLock.writeLock().lock();
            try {
                if (listedExceptions == null) {
                    listedExceptions = new ListedExceptions();
                }
            }
            finally {
                listedExceptionModificationLock.writeLock().unlock();
            }
        }
        return listedExceptions;
    }

    public static ListedExceptions resetListedExceptions() {
        listedExceptionModificationLock.writeLock().lock();
        try {
            ListedExceptions listedExceptions = ListedExceptions.listedExceptions = new ListedExceptions();
            return listedExceptions;
        }
        finally {
            listedExceptionModificationLock.writeLock().unlock();
        }
    }

    @Override
    public Model getModel() {
        listedExceptionModificationLock.writeLock().lock();
        try {
            if (this.listedExceptionModel == null) {
                this.listedExceptionModel = ModelFactory.createDefaultModel();
            }
        }
        finally {
            listedExceptionModificationLock.writeLock().unlock();
        }
        return this.listedExceptionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListedLicenseException getExceptionFromUri(String uri) throws InvalidSPDXAnalysisException {
        ListedLicenseException retval;
        URL exceptionUrl = null;
        try {
            exceptionUrl = new URL(uri);
        }
        catch (MalformedURLException e2) {
            throw new InvalidSPDXAnalysisException("Invalid listed exception URL: " + e2.getMessage());
        }
        String id = this.urlToId(exceptionUrl);
        listedExceptionModificationLock.readLock().lock();
        try {
            if (this.listedExceptionCache.containsKey(id)) {
                ListedLicenseException listedLicenseException = this.listedExceptionCache.get(id);
                return listedLicenseException;
            }
        }
        finally {
            listedExceptionModificationLock.readLock().unlock();
        }
        String base = LISTED_LICENSE_ID_URL + id;
        final Model localExceptionModel = this.getExceptionModel(uri, base);
        if (localExceptionModel == null) {
            throw new InvalidSPDXAnalysisException("No listed exception was found at " + uri);
        }
        Resource exceptionResource = localExceptionModel.getResource(base);
        if (exceptionResource == null || !localExceptionModel.containsResource(localExceptionModel.asRDFNode(exceptionResource.asNode()))) {
            throw new InvalidSPDXAnalysisException("No listed exception was found at " + uri);
        }
        final String localExceptionNamespace = this.getDocumentNamespace();
        IModelContainer localExceptionContainer = new IModelContainer(){

            @Override
            public Model getModel() {
                return localExceptionModel;
            }

            @Override
            public String getDocumentNamespace() {
                return localExceptionNamespace;
            }

            @Override
            public String getNextSpdxElementRef() {
                return null;
            }

            @Override
            public boolean spdxElementRefExists(String elementRef) {
                return false;
            }

            @Override
            public void addSpdxElementRef(String elementRef) {
            }

            @Override
            public String documentNamespaceToId(String externalNamespace) {
                return null;
            }

            @Override
            public String externalDocumentIdToNamespace(String docId) {
                return null;
            }

            @Override
            public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
                return null;
            }

            @Override
            public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
                return true;
            }
        };
        if (this.getModel().equals(localExceptionModel)) {
            retval = new ListedLicenseException(localExceptionContainer, exceptionResource.asNode());
        } else {
            ListedLicenseException localException = new ListedLicenseException(localExceptionContainer, exceptionResource.asNode());
            retval = (ListedLicenseException)localException.clone();
            retval.createResource(this);
        }
        listedExceptionModificationLock.writeLock().lock();
        try {
            this.listedExceptionCache.put(id, retval);
        }
        finally {
            listedExceptionModificationLock.writeLock().unlock();
        }
        return retval;
    }

    private String urlToId(URL exceptionUrl) {
        String[] pathParts = exceptionUrl.getFile().split("/");
        String id = pathParts[pathParts.length - 1];
        if (id.endsWith(JSONLD_URL_SUFFIX)) {
            id = id.substring(0, id.length() - JSONLD_URL_SUFFIX.length());
        }
        return id;
    }

    /*
     * Exception decompiling
     */
    private Model getExceptionModel(String uri, String base) throws NoListedLicenseRdfModel {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadListedExceptionIDs() {
        listedExceptionModificationLock.writeLock().lock();
        try {
            this.listedExceptionCache = Maps.newHashMap();
            this.listdExceptionIds = Sets.newHashSet();
            InputStream tocStream = null;
            BufferedReader reader = null;
            try {
                String line;
                if (this.onlyUseLocalLicenses) {
                    if (Objects.nonNull(this.localLicensesDir)) {
                        try {
                            tocStream = new FileInputStream(new File(this.localLicensesDir.getAbsolutePath() + File.separator + EXCEPTION_TOC_FILENAME));
                        }
                        catch (IOException e2) {
                            logger.error("Json TOC local file missing or invalid - using installed licenses");
                        }
                    }
                } else {
                    try {
                        URL tocUrl = new URL("https://spdx.org/licenses/exceptions.json");
                        tocStream = tocUrl.openStream();
                    }
                    catch (MalformedURLException e3) {
                        logger.error("Json TOC URL invalid, using local TOC file");
                        tocStream = null;
                    }
                    catch (IOException e4) {
                        logger.error("I/O error opening Json TOC URL, using local TOC file");
                        tocStream = null;
                    }
                }
                if (tocStream == null) {
                    String fileName = "resources/stdlicenses/exceptions.json";
                    tocStream = LicenseInfoFactory.class.getResourceAsStream("/" + fileName);
                }
                if (tocStream == null) {
                    logger.error("Unable to load exception ID's from JSON TOC file");
                }
                reader = new BufferedReader(new InputStreamReader(tocStream));
                StringBuilder tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                Gson gson = new Gson();
                ExceptionJsonTOC jsonToc = gson.fromJson(tocJsonStr.toString(), ExceptionJsonTOC.class);
                this.listdExceptionIds = jsonToc.getExceptionIds();
                this.licenseListVersion = jsonToc.getLicenseListVersion();
            }
            catch (IOException e5) {
                logger.error("I/O error reading JSON TOC file");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e6) {
                        logger.warn("Unable to close JSON TOC reader");
                    }
                } else if (tocStream != null) {
                    try {
                        tocStream.close();
                    }
                    catch (IOException e7) {
                        logger.warn("Unable to close JSON TOC input stream");
                    }
                }
            }
        }
        finally {
            listedExceptionModificationLock.writeLock().unlock();
        }
    }

    public String[] getSpdxListedExceptionIds() {
        listedExceptionModificationLock.readLock().lock();
        try {
            String[] stringArray = this.listdExceptionIds.toArray(new String[this.listdExceptionIds.size()]);
            return stringArray;
        }
        finally {
            listedExceptionModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public ListedLicenseException getLicenseFromStdLicModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Map<Node, ListedLicenseException> modelNodeCache = this.listedExceptionNodeCache.get(modelContainer);
        if (modelNodeCache == null) {
            modelNodeCache = Maps.newHashMap();
            this.listedExceptionNodeCache.put(modelContainer, modelNodeCache);
        }
        if (modelNodeCache.containsKey(node)) {
            return modelNodeCache.get(node);
        }
        ListedLicenseException retval = new ListedLicenseException(modelContainer, node);
        if (!this.equals(modelContainer)) {
            String exceptionId = retval.getLicenseExceptionId();
            if (exceptionId == null) {
                URL exceptionUrl;
                try {
                    exceptionUrl = new URL(node.getURI());
                }
                catch (MalformedURLException e2) {
                    throw new InvalidSPDXAnalysisException("Invalid exception URL");
                }
                exceptionId = this.urlToId(exceptionUrl);
            }
            try {
                ListedLicenseException licenseFromModel = this.getListedExceptionById(exceptionId);
                retval.copyFrom(licenseFromModel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        modelNodeCache.put(node, retval);
        return retval;
    }

    @Override
    public String getDocumentNamespace() {
        return LISTED_LICENSE_ID_URL;
    }

    @Override
    public synchronized String getNextSpdxElementRef() {
        ++this.nextId;
        return "SpdxLicenseGeneratedId-" + String.valueOf(this.nextId);
    }

    @Override
    public boolean spdxElementRefExists(String elementRef) {
        return this.listdExceptionIds.contains(elementRef);
    }

    @Override
    public void addSpdxElementRef(String elementRef) {
        this.listdExceptionIds.add(elementRef);
    }

    @Override
    public String documentNamespaceToId(String externalNamespace) {
        return null;
    }

    @Override
    public String externalDocumentIdToNamespace(String docId) {
        return null;
    }

    @Override
    public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
        if (duplicate != null) {
            return duplicate;
        }
        if (uri == null) {
            return this.listedExceptionModel.createResource(this.getType(this.listedExceptionModel));
        }
        return this.listedExceptionModel.createResource(uri, this.getType(this.listedExceptionModel));
    }

    private Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#LicenseException");
    }

    @Override
    public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
        return true;
    }

    public boolean isSpdxListedLExceptionID(String id) {
        try {
            listedExceptionModificationLock.readLock().lock();
            boolean bl = this.listdExceptionIds.contains(id);
            return bl;
        }
        finally {
            listedExceptionModificationLock.readLock().unlock();
        }
    }

    public ListedLicenseException getListedExceptionById(String id) throws InvalidSPDXAnalysisException {
        ListedLicenseException retval = this.getExceptionFromUri("https://spdx.org/licenses/" + id + JSONLD_URL_SUFFIX);
        if (retval != null) {
            retval = (ListedLicenseException)retval.clone();
        }
        return retval;
    }
}

