/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.SpdxElement;

public abstract class SinglePointer
extends RdfModelObject
implements Comparable<SinglePointer> {
    static final Logger logger = LoggerFactory.getLogger(SinglePointer.class);
    protected SpdxElement reference;

    public SinglePointer(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    public SinglePointer(SpdxElement reference) {
        this.reference = reference;
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.reference == null) {
            retval.add("Missing required reference field");
        } else {
            retval.addAll(this.reference.verify());
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        SpdxElement myReference;
        SpdxElement compFile;
        if (!(compare instanceof SinglePointer)) {
            return false;
        }
        try {
            compFile = ((SinglePointer)compare).getReference();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting reference from comparison", e2);
            return false;
        }
        try {
            myReference = this.getReference();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.error("Error getting my reference from comparison", e3);
            return false;
        }
        if (myReference == null) {
            return compFile == null;
        }
        if (compFile == null) {
            return false;
        }
        return myReference.equivalent(compFile, false);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.reference = this.findElementPropertyValue("http://www.w3.org/2009/pointers#", "reference");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "reference", this.reference);
    }

    public SpdxElement getReference() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.reference = this.findElementPropertyValue("http://www.w3.org/2009/pointers#", "reference");
        }
        return this.reference;
    }

    public void setReference(SpdxElement reference) throws InvalidSPDXAnalysisException {
        this.reference = reference;
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "reference", this.reference);
    }

    public SinglePointer clone() {
        throw new RuntimeException("Can not clone an abstract single pointer class");
    }

    protected int compareReferences(SinglePointer o) {
        if (o == null) {
            return 1;
        }
        SpdxElement compRef = null;
        try {
            compRef = o.getReference();
            if (this.reference == null) {
                if (compRef == null) {
                    return 0;
                }
                return -1;
            }
            if (compRef == null) {
                return 1;
            }
            String myName = this.reference.getName();
            if (myName != null) {
                return myName.compareTo(compRef.getName());
            }
            if (compRef.getName() == null) {
                return 0;
            }
            return -1;
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting comparison reference element", e2);
            return -1;
        }
    }
}

