/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.DocumentInfoSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class OriginsSheetV1d2
extends DocumentInfoSheet {
    static final int NUM_COLS = 9;
    static final int SPDX_VERSION_COL = 1;
    static final int CREATED_BY_COL = 2;
    static final int CREATED_COL = 3;
    static final int DATA_LICENSE_COL = 4;
    static final int LICENSE_LIST_VERSION_COL = 5;
    static final int AUTHOR_COMMENTS_COL = 6;
    static final int DOCUMENT_COMMENT_COL = 7;
    static final int USER_DEFINED_COL = 8;
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, true, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"Spreadsheet Version", "SPDX Version", "Creator", "Created", "Data License", "License List Version", "Creator Comment", "Document Comment", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{20, 20, 30, 16, 40, 20, 70, 70, 70};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, true, false, true, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, false, true, false, false, false, false, false};

    public OriginsSheetV1d2(Workbook workbook, String sheetName, String version2) {
        super(workbook, sheetName, version2);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Origins does not exist";
            }
            this.version = this.getDataCellStringValue(0);
            if (this.version == null) {
                return "Invalid origins spreadsheet - no spreadsheet version found";
            }
            if (!SPDXSpreadsheet.verifyVersion(this.version)) {
                return "Spreadsheet version " + this.version + " not supported.";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 8; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Origins worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(1) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Origins work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 9; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum() + " in Origins Spreadsheet");
            }
            if (i != 3 || cell.getCellTypeEnum() == CellType.NUMERIC) continue;
            return "Created column in origin spreadsheet is not of type Date";
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
        Row dataRow = sheet.createRow(1);
        Cell ssVersionCell = dataRow.createCell(0);
        ssVersionCell.setCellValue("2.2.0");
    }

    @Override
    public void setAuthorComments(String comments) {
        this.setDataCellStringValue(6, comments);
    }

    public void setCreatedBy(String createdBy) {
        this.setDataCellStringValue(2, createdBy);
    }

    @Override
    public void setDataLicense(String dataLicense) {
        this.setDataCellStringValue(4, dataLicense);
    }

    @Override
    public void setSPDXVersion(String version2) {
        this.setDataCellStringValue(1, version2);
    }

    public void setSpreadsheetVersion(String version2) {
        this.setDataCellStringValue(0, version2);
    }

    @Override
    public String getAuthorComments() {
        return this.getDataCellStringValue(6);
    }

    @Override
    public Date getCreated() {
        return this.getDataCellDateValue(3);
    }

    @Override
    public String getDataLicense() {
        return this.getDataCellStringValue(4);
    }

    @Override
    public String getSPDXVersion() {
        return this.getDataCellStringValue(1);
    }

    public String getSpreadsheetVersion() {
        return this.getDataCellStringValue(0);
    }

    @Override
    public void setCreatedBy(String[] createdBy) {
        Cell cell;
        Row row;
        int i;
        if (createdBy == null || createdBy.length < 1) {
            this.setDataCellStringValue(2, "");
            int i2 = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i2);
            while (nextRow != null) {
                Cell createdByCell = nextRow.getCell(2);
                if (createdByCell != null) {
                    createdByCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i2);
            }
            return;
        }
        this.setDataCellStringValue(2, createdBy[0]);
        for (i = 1; i < createdBy.length; ++i) {
            row = this.getDataRow(i);
            cell = row.getCell(2);
            if (cell == null) {
                cell = row.createCell(2);
            }
            cell.setCellValue(createdBy[i]);
        }
        for (i = this.firstRowNum + 1 + createdBy.length; i <= this.lastRowNum; ++i) {
            row = this.sheet.getRow(i);
            cell = row.getCell(2);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    @Override
    public String[] getCreatedBy() {
        int numRows = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + numRows) != null && this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(2) != null && !this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(2).getStringCellValue().isEmpty()) {
            ++numRows;
        }
        String[] retval = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            retval[i] = this.sheet.getRow(this.firstRowNum + 1 + i).getCell(2).getStringCellValue();
        }
        return retval;
    }

    @Override
    public void setCreated(Date created) {
        this.setDataCellDateValue(3, created);
    }

    @Override
    public String getDocumentComment() {
        return this.getDataCellStringValue(7);
    }

    @Override
    public void setDocumentComment(String docComment) {
        this.setDataCellStringValue(7, docComment);
    }

    @Override
    public String getLicenseListVersion() {
        return this.getDataCellStringValue(5);
    }

    @Override
    public void setLicenseListVersion(String licenseVersion) {
        this.setDataCellStringValue(5, licenseVersion);
    }

    @Override
    public String getNamespace() {
        return "";
    }

    @Override
    public void addDocument(SpdxDocument doc) throws SpreadsheetException {
        String licenseListVersion;
        String comments;
        AnyLicenseInfo dataLicense;
        SPDXCreatorInformation creator;
        this.setSPDXVersion(doc.getSpecVersion());
        try {
            creator = doc.getCreationInfo();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the creation info: " + e1.getMessage());
        }
        String[] createdBys = creator.getCreators();
        this.setCreatedBy(createdBys);
        try {
            dataLicense = doc.getDataLicense();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the data license info: " + e1.getMessage());
        }
        if (dataLicense != null && dataLicense instanceof SimpleLicensingInfo) {
            this.setDataLicense(((SimpleLicensingInfo)dataLicense).getLicenseId());
        }
        if ((comments = creator.getComment()) != null && !comments.isEmpty()) {
            this.setAuthorComments(comments);
        }
        String created = creator.getCreated();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            this.setCreated(dateFormat.parse(created));
        }
        catch (ParseException e2) {
            throw new SpreadsheetException("Invalid created date - unable to parse");
        }
        String docComment = doc.getComment();
        if (docComment != null) {
            this.setDocumentComment(docComment);
        }
        try {
            licenseListVersion = doc.getCreationInfo().getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error getting the license list info: " + e3.getMessage());
        }
        if (licenseListVersion != null) {
            this.setLicenseListVersion(licenseListVersion);
        }
    }

    @Override
    public String getSpdxId() {
        return null;
    }

    @Override
    public void setSpdxId(String id) {
    }

    @Override
    public String getDocumentName() {
        return null;
    }

    @Override
    public void setDocumentName(String documentName) {
    }

    @Override
    public String[] getDocumentContents() {
        return new String[0];
    }

    @Override
    public void setDocumentDescribes(String[] contents) {
    }

    @Override
    public ExternalDocumentRef[] getExternalDocumentRefs() {
        return new ExternalDocumentRef[0];
    }

    @Override
    public void setExternalDocumentRefs(ExternalDocumentRef[] externalDocumentRefs) {
    }
}

