/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.DocumentInfoSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tag.BuildDocument;
import org.spdx.tag.InvalidSpdxTagFileException;

public class OriginsSheetV2d0
extends DocumentInfoSheet {
    static final int NUM_COLS = 14;
    static final int SPDX_VERSION_COL = 1;
    static final int DATA_LICENSE_COL = 2;
    static final int SPDX_ID_COL = 3;
    static final int LICENSE_LIST_VERSION_COL = 4;
    static final int DOCUMENT_NAME_COL = 5;
    static final int NAMESPACE_COL = 6;
    static final int DOCUMENT_DESCRIBES_COL = 7;
    static final int EXTERNAL_DOC_REFS_COL = 8;
    static final int DOCUMENT_COMMENT_COL = 9;
    static final int CREATED_BY_COL = 10;
    static final int CREATED_COL = 11;
    static final int AUTHOR_COMMENTS_COL = 12;
    static final int USER_DEFINED_COL = 13;
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, false, true, true, true, false, false, true, true, false, false};
    static final String[] HEADER_TITLES = new String[]{"Spreadsheet Version", "SPDX Version", "Data License", "SPDX Identifier", "License List Version", "Document Name", "Document Namespace", "Document Contents", "External Document References", "Document Comment", "Creator", "Created", "Creator Comment", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{20, 16, 20, 20, 16, 40, 80, 50, 140, 70, 60, 20, 70, 60};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, false, false, false, true, true, true, true, true, true, false, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, true, true, true, false, false, false, false, false, false, true, false, false};

    public OriginsSheetV2d0(Workbook workbook, String sheetName, String version2) {
        super(workbook, sheetName, version2);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Origins does not exist";
            }
            this.version = this.getDataCellStringValue(0);
            if (this.version == null) {
                return "Invalid origins spreadsheet - no spreadsheet version found";
            }
            if (!SPDXSpreadsheet.verifyVersion(this.version)) {
                return "Spreadsheet version " + this.version + " not supported.";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 13; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Origins worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(1) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Origins work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 14; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum() + " in Origins Spreadsheet");
            }
            if (i != 11 || cell.getCellTypeEnum() == CellType.NUMERIC) continue;
            return "Created column in origin spreadsheet is not of type Date";
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
        Row dataRow = sheet.createRow(1);
        Cell ssVersionCell = dataRow.createCell(0);
        ssVersionCell.setCellValue("2.2.0");
    }

    @Override
    public void setAuthorComments(String comments) {
        this.setDataCellStringValue(12, comments);
    }

    public void setCreatedBy(String createdBy) {
        this.setDataCellStringValue(10, createdBy);
    }

    @Override
    public void setDataLicense(String dataLicense) {
        this.setDataCellStringValue(2, dataLicense);
    }

    @Override
    public void setSPDXVersion(String version2) {
        this.setDataCellStringValue(1, version2);
    }

    public void setSpreadsheetVersion(String version2) {
        this.setDataCellStringValue(0, version2);
    }

    @Override
    public String getAuthorComments() {
        return this.getDataCellStringValue(12);
    }

    @Override
    public Date getCreated() {
        return this.getDataCellDateValue(11);
    }

    @Override
    public String getDataLicense() {
        return this.getDataCellStringValue(2);
    }

    @Override
    public String getSPDXVersion() {
        return this.getDataCellStringValue(1);
    }

    public String getSpreadsheetVersion() {
        return this.getDataCellStringValue(0);
    }

    @Override
    public void setCreatedBy(String[] createdBy) {
        Cell cell;
        Row row;
        int i;
        if (createdBy == null || createdBy.length < 1) {
            this.setDataCellStringValue(10, "");
            int i2 = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i2);
            while (nextRow != null) {
                Cell createdByCell = nextRow.getCell(10);
                if (createdByCell != null) {
                    createdByCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i2);
            }
            return;
        }
        this.setDataCellStringValue(10, createdBy[0]);
        for (i = 1; i < createdBy.length; ++i) {
            row = this.getDataRow(i);
            cell = row.getCell(10);
            if (cell == null) {
                cell = row.createCell(10);
            }
            cell.setCellValue(createdBy[i]);
        }
        for (i = this.firstRowNum + 1 + createdBy.length; i <= this.lastRowNum; ++i) {
            row = this.sheet.getRow(i);
            cell = row.getCell(10);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    @Override
    public String[] getCreatedBy() {
        int numRows = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + numRows) != null && this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(10) != null && !this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(10).getStringCellValue().isEmpty()) {
            ++numRows;
        }
        String[] retval = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            retval[i] = this.sheet.getRow(this.firstRowNum + 1 + i).getCell(10).getStringCellValue();
        }
        return retval;
    }

    @Override
    public void setCreated(Date created) {
        this.setDataCellDateValue(11, created);
    }

    @Override
    public String getDocumentComment() {
        return this.getDataCellStringValue(9);
    }

    @Override
    public void setDocumentComment(String docComment) {
        this.setDataCellStringValue(9, docComment);
    }

    @Override
    public String getLicenseListVersion() {
        return this.getDataCellStringValue(4);
    }

    @Override
    public void setLicenseListVersion(String licenseVersion) {
        this.setDataCellStringValue(4, licenseVersion);
    }

    @Override
    public String getNamespace() {
        return this.getDataCellStringValue(6);
    }

    @Override
    public void addDocument(SpdxDocument doc) throws SpreadsheetException {
        String licenseListVersion;
        String created;
        String comments;
        AnyLicenseInfo dataLicense;
        SPDXCreatorInformation creator;
        this.setSPDXVersion(doc.getSpecVersion());
        try {
            creator = doc.getCreationInfo();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the creation info: " + e1.getMessage());
        }
        String[] createdBys = creator.getCreators();
        this.setCreatedBy(createdBys);
        try {
            dataLicense = doc.getDataLicense();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the data license info: " + e1.getMessage());
        }
        if (dataLicense != null && dataLicense instanceof SimpleLicensingInfo) {
            this.setDataLicense(((SimpleLicensingInfo)dataLicense).getLicenseId());
        }
        if ((comments = creator.getComment()) != null && !comments.isEmpty()) {
            this.setAuthorComments(comments);
        }
        if ((created = creator.getCreated()) == null) {
            throw new SpreadsheetException("Missing created date");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            this.setCreated(dateFormat.parse(created));
        }
        catch (ParseException e2) {
            throw new SpreadsheetException("Invalid created date - unable to parse");
        }
        String docComment = doc.getComment();
        if (docComment != null) {
            this.setDocumentComment(docComment);
        }
        try {
            licenseListVersion = doc.getCreationInfo().getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error getting the license list info: " + e3.getMessage());
        }
        if (licenseListVersion != null) {
            this.setLicenseListVersion(licenseListVersion);
        }
        this.setSpdxId(doc.getId());
        this.setDocumentName(doc.getName());
        try {
            this.setNamespace(doc.getDocumentNamespace());
        }
        catch (InvalidSPDXAnalysisException e4) {
            throw new SpreadsheetException("Error getting the document namespace: " + e4.getMessage());
        }
        SpdxItem[] contents = null;
        try {
            contents = doc.getDocumentDescribes();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new SpreadsheetException("Error getting the document describes: " + e1.getMessage());
        }
        Object[] contentIds = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            contentIds[i] = contents[i].getId();
        }
        Arrays.sort(contentIds);
        this.setDocumentDescribes((String[])contentIds);
        try {
            this.setExternalDocumentRefs(doc.getExternalDocumentRefs());
        }
        catch (InvalidSPDXAnalysisException e5) {
            throw new SpreadsheetException("Error getting the external document references: " + e5.getMessage());
        }
    }

    private void setNamespace(String namespace2) {
        this.setDataCellStringValue(6, namespace2);
    }

    @Override
    public String getSpdxId() {
        return this.getDataCellStringValue(3);
    }

    @Override
    public void setSpdxId(String id) {
        this.setDataCellStringValue(3, id);
    }

    @Override
    public String getDocumentName() {
        return this.getDataCellStringValue(5);
    }

    @Override
    public void setDocumentName(String documentName) {
        this.setDataCellStringValue(5, documentName);
    }

    @Override
    public String[] getDocumentContents() {
        int numRows = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + numRows) != null && this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(7) != null && !this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(7).getStringCellValue().isEmpty()) {
            ++numRows;
        }
        String[] retval = new String[numRows];
        for (int i = 0; i < numRows; ++i) {
            retval[i] = this.sheet.getRow(this.firstRowNum + 1 + i).getCell(7).getStringCellValue();
        }
        return retval;
    }

    @Override
    public void setDocumentDescribes(String[] contents) {
        Cell cell;
        Row row;
        int i;
        if (contents == null || contents.length < 1) {
            this.setDataCellStringValue(7, "");
            int i2 = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i2);
            while (nextRow != null) {
                Cell documentDescribesCell = nextRow.getCell(7);
                if (documentDescribesCell != null) {
                    documentDescribesCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i2);
            }
            return;
        }
        this.setDataCellStringValue(7, contents[0]);
        for (i = 1; i < contents.length; ++i) {
            row = this.getDataRow(i);
            cell = row.getCell(7);
            if (cell == null) {
                cell = row.createCell(7);
            }
            cell.setCellValue(contents[i]);
        }
        for (i = this.firstRowNum + 1 + contents.length; i <= this.lastRowNum; ++i) {
            row = this.sheet.getRow(i);
            cell = row.getCell(7);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    @Override
    public ExternalDocumentRef[] getExternalDocumentRefs() throws SpreadsheetException {
        int numRows = 0;
        while (this.sheet.getRow(this.firstRowNum + 1 + numRows) != null && this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(8) != null && !this.sheet.getRow(this.firstRowNum + 1 + numRows).getCell(8).getStringCellValue().isEmpty()) {
            ++numRows;
        }
        ExternalDocumentRef[] retval = new ExternalDocumentRef[numRows];
        for (int i = 0; i < numRows; ++i) {
            try {
                retval[i] = BuildDocument.parseExternalDocumentRef(this.sheet.getRow(this.firstRowNum + 1 + i).getCell(8).getStringCellValue(), this.firstRowNum + 1 + i);
                continue;
            }
            catch (InvalidSpdxTagFileException e2) {
                throw new SpreadsheetException("Invalid external document reference string: " + this.sheet.getRow(this.firstRowNum + 1 + i).getCell(8).getStringCellValue());
            }
        }
        return retval;
    }

    @Override
    public void setExternalDocumentRefs(ExternalDocumentRef[] externalDocumentRefs) throws SpreadsheetException {
        Cell cell;
        Row row;
        int i;
        if (externalDocumentRefs == null || externalDocumentRefs.length < 1) {
            this.setDataCellStringValue(8, "");
            int i2 = this.firstRowNum + 1 + 1;
            Row nextRow = this.sheet.getRow(i2);
            while (nextRow != null) {
                Cell externalDocRefsCell = nextRow.getCell(8);
                if (externalDocRefsCell != null) {
                    externalDocRefsCell.setCellValue("");
                }
                nextRow = this.sheet.getRow(++i2);
            }
            return;
        }
        try {
            this.setDataCellStringValue(8, this.externalDocRefToStr(externalDocumentRefs[0]));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting external document reference", e2);
        }
        for (i = 1; i < externalDocumentRefs.length; ++i) {
            row = this.getDataRow(i);
            cell = row.getCell(8);
            if (cell == null) {
                cell = row.createCell(8);
            }
            try {
                cell.setCellValue(this.externalDocRefToStr(externalDocumentRefs[i]));
                continue;
            }
            catch (InvalidSPDXAnalysisException e3) {
                throw new SpreadsheetException("Error getting external document reference", e3);
            }
        }
        for (i = this.firstRowNum + 1 + externalDocumentRefs.length; i <= this.lastRowNum; ++i) {
            row = this.sheet.getRow(i);
            cell = row.getCell(8);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    private String externalDocRefToStr(ExternalDocumentRef externalDocumentRef) throws InvalidSPDXAnalysisException {
        if (externalDocumentRef == null) {
            return "";
        }
        return externalDocumentRef.getExternalDocumentId() + " " + externalDocumentRef.getSpdxDocumentNamespace() + " " + Checksum.CHECKSUM_ALGORITHM_TO_TAG.get((Object)externalDocumentRef.getChecksum().getAlgorithm()) + " " + externalDocumentRef.getChecksum().getValue();
    }
}

