/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCommentInputStream
extends InputStream {
    static final Logger logger = LoggerFactory.getLogger(NoCommentInputStream.class.getName());
    private static final CharSequence START_TEXT_TAG = "<text>";
    private static final CharSequence END_TEXT_TAG = "</text>";
    private static final char COMMENT_CHAR = '#';
    private InputStream inputStream;
    private InputStreamReader reader;
    private BufferedReader bufferedReader;
    private String currentLine;
    private int bytesIndex;
    private byte[] currentBytes;
    boolean inText = false;
    private int currentLineNo = 0;

    public NoCommentInputStream(InputStream in) throws IOException {
        this.inputStream = in;
        this.reader = new InputStreamReader(this.inputStream, "UTF-8");
        this.bufferedReader = new BufferedReader(this.reader);
        this.readNextLine();
    }

    private void readNextLine() throws IOException {
        do {
            this.currentLine = this.bufferedReader.readLine();
            if (this.currentLine == null) {
                return;
            }
            ++this.currentLineNo;
        } while (!this.inText && (this.currentLine.length() == 0 || this.currentLine.charAt(0) == '#'));
        if (this.inText) {
            if (this.currentLine.contains(END_TEXT_TAG)) {
                this.inText = false;
            }
        } else if (this.currentLine.contains(START_TEXT_TAG) && !this.currentLine.contains(END_TEXT_TAG)) {
            this.inText = true;
        }
        this.bytesIndex = 0;
        this.currentBytes = this.currentLine.getBytes("UTF-8");
    }

    @Override
    public int read() throws IOException {
        if (this.currentLine == null) {
            return -1;
        }
        if (this.bytesIndex >= this.currentBytes.length) {
            this.readNextLine();
            if (this.currentLine == null) {
                return -1;
            }
            return 10;
        }
        return this.currentBytes[this.bytesIndex++];
    }

    @Override
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException e2) {
                logger.error("IO Error closing buffered reader: " + e2.getMessage());
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e3) {
                logger.error("IO Error closing reader: " + e3.getMessage());
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e4) {
                logger.error("IO Error closing input stream: " + e4.getMessage());
            }
        }
    }

    public int getCurrentLineNo() {
        return this.currentLineNo;
    }

    public String readLine() throws IOException {
        if (this.bytesIndex >= this.currentBytes.length) {
            this.readNextLine();
        }
        if (this.currentLine == null) {
            return null;
        }
        String retval = this.currentLine.substring(this.bytesIndex);
        this.bytesIndex = this.currentBytes.length;
        return retval;
    }
}

