/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.stringtemplate.v4.misc.Coordinate;

public class Misc {
    public static final String newline = System.getProperty("line.separator");

    public static String join(Iterator iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String strip(String s2, int n) {
        return s2.substring(n, s2.length() - n);
    }

    public static String trimOneStartingNewline(String s2) {
        if (s2.startsWith("\r\n")) {
            s2 = s2.substring(2);
        } else if (s2.startsWith("\n")) {
            s2 = s2.substring(1);
        }
        return s2;
    }

    public static String trimOneTrailingNewline(String s2) {
        if (s2.endsWith("\r\n")) {
            s2 = s2.substring(0, s2.length() - 2);
        } else if (s2.endsWith("\n")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    public static String stripLastPathElement(String f) {
        int slash = f.lastIndexOf(47);
        if (slash < 0) {
            return f;
        }
        return f.substring(0, slash);
    }

    public static String getFileNameNoSuffix(String f) {
        if (f == null) {
            return null;
        }
        f = Misc.getFileName(f);
        return f.substring(0, f.lastIndexOf(46));
    }

    public static String getFileName(String fullFileName) {
        if (fullFileName == null) {
            return null;
        }
        File f = new File(fullFileName);
        return f.getName();
    }

    public static String getParent(String name) {
        if (name == null) {
            return null;
        }
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            return name.substring(0, lastSlash);
        }
        if (lastSlash == 0) {
            return "/";
        }
        return "";
    }

    public static String getPrefix(String name) {
        String parent;
        if (name == null) {
            return "/";
        }
        String prefix = parent = Misc.getParent(name);
        if (!parent.endsWith("/")) {
            prefix = prefix + '/';
        }
        return prefix;
    }

    public static String replaceEscapes(String s2) {
        s2 = s2.replaceAll("\n", "\\\\n");
        s2 = s2.replaceAll("\r", "\\\\r");
        s2 = s2.replaceAll("\t", "\\\\t");
        return s2;
    }

    public static boolean urlExists(URL url) {
        try {
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            is.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static Coordinate getLineCharPosition(String s2, int index) {
        int line = 1;
        int charPos = 0;
        for (int p = 0; p < index; ++p) {
            if (s2.charAt(p) == '\n') {
                ++line;
                charPos = 0;
                continue;
            }
            ++charPos;
        }
        return new Coordinate(line, charPos);
    }

    public static Object accessField(Field f, Object o, Object value) throws IllegalAccessException {
        try {
            f.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        value = f.get(o);
        return value;
    }

    public static Object invokeMethod(Method m3, Object o, Object value) throws IllegalAccessException, InvocationTargetException {
        try {
            m3.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        value = m3.invoke(o, (Object[])null);
        return value;
    }

    public static Method getMethod(Class c, String methodName) {
        Method m3;
        try {
            m3 = c.getMethod(methodName, null);
        }
        catch (NoSuchMethodException nsme) {
            m3 = null;
        }
        return m3;
    }
}

