/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.NonNumericLicenseIdException;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxElementFactory;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SpdxDocumentContainer
implements IModelContainer,
SpdxRdfConstants {
    public static final String POINT_EIGHT_SPDX_VERSION = "SPDX-0.8";
    public static final String POINT_NINE_SPDX_VERSION = "SPDX-0.9";
    public static final String ONE_DOT_ZERO_SPDX_VERSION = "SPDX-1.0";
    public static final String ONE_DOT_ONE_SPDX_VERSION = "SPDX-1.1";
    public static final String ONE_DOT_TWO_SPDX_VERSION = "SPDX-1.2";
    public static final String TWO_POINT_ZERO_VERSION = "SPDX-2.0";
    public static final String TWO_POINT_ONE_VERSION = "SPDX-2.1";
    public static final String TWO_POINT_TWO_VERSION = "SPDX-2.2";
    public static final String CURRENT_SPDX_VERSION = "SPDX-2.2";
    public static final String CURRENT_IMPLEMENTATION_VERSION = "2.2.3";
    static Set<String> SUPPORTED_SPDX_VERSIONS = Sets.newHashSet();
    Set<String> spdxRefs = Sets.newHashSet();
    Map<String, ExtractedLicenseInfo> licenseIdToExtractedLicense = Maps.newHashMap();
    Map<String, ExternalDocumentRef> externalDocIdToRef = Maps.newHashMap();
    Map<String, ExternalDocumentRef> externalDocNamespaceToRef = Maps.newHashMap();
    Map<Node, List<IRdfModel>> nodeModelMap = Maps.newHashMap();
    private Model model;
    private String documentNamespace;
    private Node documentNode;
    private SpdxDocument spdxDocument;
    protected int nextLicenseRef = 1;
    private AtomicInteger nextElementRef = new AtomicInteger(0);

    public SpdxDocumentContainer(Model model) throws InvalidSPDXAnalysisException {
        this.model = model;
        this.documentNode = this.getSpdxDocNode();
        if (this.documentNode == null) {
            throw new InvalidSPDXAnalysisException("Invalid model - must contain an SPDX Document");
        }
        if (!this.documentNode.isURI()) {
            throw new InvalidSPDXAnalysisException("SPDX Documents must have a unique URI");
        }
        String docUri = this.documentNode.getURI();
        this.documentNamespace = this.formDocNamespace(docUri);
        this.initializeExternalDocumentRefs();
        this.spdxDocument = new SpdxDocument(this, this.documentNode);
        this.initializeNextLicenseRef();
        this.initializeNextElementRef();
        if (this.spdxDocument.getDocumentDescribes().length == 0) {
            this.upgradeDescribesToRelationship();
        }
    }

    private void upgradeDescribesToRelationship() throws InvalidSPDXAnalysisException {
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "describesPackage").asNode();
        Triple m = Triple.createMatch((Node)this.documentNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        ArrayList describedPackages = Lists.newArrayList();
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            describedPackages.add(new SpdxPackage(this, t.getObject()));
        }
        for (SpdxPackage pkg : describedPackages) {
            Relationship describes = new Relationship(pkg, Relationship.RelationshipType.DESCRIBES, "");
            this.getSpdxDocument().addRelationship(describes);
        }
    }

    public SpdxDocumentContainer(String uri) throws InvalidSPDXAnalysisException {
        this(uri, "SPDX-2.2");
    }

    public SpdxDocumentContainer(String uri, String spdxVersion) throws InvalidSPDXAnalysisException {
        this.model = ModelFactory.createDefaultModel();
        String v = this.verifySpdxVersion(spdxVersion);
        if (v != null) {
            throw new InvalidSPDXAnalysisException("Invalid SPDX Version: " + v);
        }
        this.model.setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
        this.model.setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        this.model.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.model.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.documentNamespace = this.formDocNamespace(uri);
        this.model.setNsPrefix("", this.documentNamespace);
        Resource spdxAnalysisType = this.model.createResource("http://spdx.org/rdf/terms#SpdxDocument");
        this.model.createResource(this.documentNamespace + "SPDXRef-DOCUMENT", spdxAnalysisType);
        this.addSpdxElementRef("SPDXRef-DOCUMENT");
        this.nextElementRef.set(1);
        this.nextLicenseRef = 1;
        this.documentNode = this.getSpdxDocNode();
        this.spdxDocument = new SpdxDocument(this, this.documentNode);
        this.spdxDocument.setSpecVersion(spdxVersion);
        if (!spdxVersion.equals(POINT_EIGHT_SPDX_VERSION) && !spdxVersion.equals(POINT_NINE_SPDX_VERSION)) {
            try {
                AnyLicenseInfo dataLicense = spdxVersion.equals(ONE_DOT_ZERO_SPDX_VERSION) ? LicenseInfoFactory.parseSPDXLicenseString("PDDL-1.0", this) : LicenseInfoFactory.parseSPDXLicenseString("CC0-1.0", this);
                this.spdxDocument.setDataLicense(dataLicense);
            }
            catch (InvalidLicenseStringException e) {
                throw new InvalidSPDXAnalysisException("Unable to create data license", e);
            }
        }
    }

    private String formDocNamespace(String docUriString) {
        int fragmentIndex = docUriString.indexOf(35);
        if (fragmentIndex <= 0) {
            return docUriString + "#";
        }
        return docUriString.substring(0, fragmentIndex) + "#";
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    private Node getSpdxDocNode() {
        Node spdxDocNode = null;
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node spdxDocObject = this.model.getProperty("http://spdx.org/rdf/terms#", "SpdxDocument").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)spdxDocObject);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple docTriple = (Triple)tripleIter.next();
            spdxDocNode = docTriple.getSubject();
        }
        return spdxDocNode;
    }

    @Override
    public String getDocumentNamespace() {
        return this.documentNamespace;
    }

    private void initializeNextElementRef() {
        int highestElementRef = 0;
        Triple m = Triple.createMatch(null, null, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            String objectUri;
            int elementRefNum;
            String elementRef;
            String subjectUri;
            Triple trip = (Triple)tripleIter.next();
            if (trip.getSubject().isURI() && (subjectUri = trip.getSubject().getURI()).startsWith(this.documentNamespace)) {
                elementRef = subjectUri.substring(this.documentNamespace.length());
                this.spdxRefs.add(elementRef);
                if (SPDX_ELEMENT_REF_PATTERN.matcher(elementRef).matches() && (elementRefNum = SpdxDocumentContainer.getElementRefNumber(elementRef)) > highestElementRef) {
                    highestElementRef = elementRefNum;
                }
            }
            if (!trip.getObject().isURI() || !(objectUri = trip.getObject().getURI()).startsWith(this.documentNamespace)) continue;
            elementRef = objectUri.substring(this.documentNamespace.length());
            this.spdxRefs.add(elementRef);
            if (!SPDX_ELEMENT_REF_PATTERN.matcher(elementRef).matches() || (elementRefNum = SpdxDocumentContainer.getElementRefNumber(elementRef)) <= highestElementRef) continue;
            highestElementRef = elementRefNum;
        }
        this.nextElementRef.set(highestElementRef + 1);
    }

    public static int getElementRefNumber(String elementReference) {
        String numPart = elementReference.substring("SPDXRef-".length());
        try {
            return Integer.parseInt(numPart);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public SpdxElement findElementById(String id) throws InvalidSPDXAnalysisException {
        if ("SPDXRef-DOCUMENT".equals(id)) {
            return this.spdxDocument;
        }
        String uri = null;
        if (id.contains(":")) {
            String[] parts = id.split(":");
            if (parts.length != 2) {
                throw new InvalidSPDXAnalysisException("Invalid SPDX ID: " + id + " - must be an SPDX element ID or SPDXDocument ID: SpdxElement ID");
            }
            String nameSpace = this.externalDocumentIdToNamespace(parts[0]);
            if (nameSpace == null) {
                throw new InvalidSPDXAnalysisException("No external document ref found for SPDX ID " + id);
            }
            uri = nameSpace + "#" + parts[1];
        } else {
            if (!this.spdxElementRefExists(id)) {
                return null;
            }
            uri = this.getDocumentNamespace() + id;
        }
        Resource r = this.model.createResource(uri);
        return SpdxElementFactory.createElementFromModel(this, r.asNode());
    }

    public String verifySpdxVersion(String spdxVersion) {
        if (!spdxVersion.startsWith("SPDX-")) {
            return "Invalid spdx version - must start with 'SPDX-'";
        }
        Matcher docSpecVersionMatcher = SpdxRdfConstants.SPDX_VERSION_PATTERN.matcher(spdxVersion);
        if (!docSpecVersionMatcher.matches()) {
            return "Invalid spdx version format - must match 'SPDX-M.N'";
        }
        if (!SUPPORTED_SPDX_VERSIONS.contains(spdxVersion)) {
            return "Version " + spdxVersion + " is not supported by this version of the rdf parser";
        }
        return null;
    }

    public SpdxDocument getSpdxDocument() {
        return this.spdxDocument;
    }

    @Override
    public String getNextSpdxElementRef() {
        int nextSpdxElementNum = this.getAndIncrementNextElementRef();
        String retval = SpdxDocumentContainer.formSpdxElementRef(nextSpdxElementNum);
        while (this.spdxElementRefExists(retval)) {
            nextSpdxElementNum = this.getAndIncrementNextLicenseRef();
            retval = SpdxDocumentContainer.formSpdxElementRef(nextSpdxElementNum);
        }
        this.spdxRefs.add(retval);
        return retval;
    }

    public static String formSpdxElementRef(int refNum) {
        return "SPDXRef-" + String.valueOf(refNum);
    }

    private int getAndIncrementNextElementRef() {
        return this.nextElementRef.getAndIncrement();
    }

    @Override
    public boolean spdxElementRefExists(String elementRef) {
        return this.spdxRefs.contains(elementRef);
    }

    @Override
    public void addSpdxElementRef(String elementRef) throws InvalidSPDXAnalysisException {
        if (this.spdxElementRefExists(elementRef)) {
            throw new InvalidSPDXAnalysisException("Duplicate SPDX element reference: " + elementRef);
        }
        this.spdxRefs.add(elementRef);
    }

    public void initializeNextLicenseRef() throws InvalidSPDXAnalysisException {
        this.getExtractedLicenseInfosFromModel();
        ExtractedLicenseInfo[] existingLicenses = this.getExtractedLicenseInfos();
        if (existingLicenses == null) {
            this.nextLicenseRef = 1;
            return;
        }
        int highestNonStdLicense = 0;
        for (int i = 0; i < existingLicenses.length; ++i) {
            try {
                int idNum = this.getLicenseRefNum(existingLicenses[i].getLicenseId());
                if (idNum <= highestNonStdLicense) continue;
                highestNonStdLicense = idNum;
                continue;
            }
            catch (NonNumericLicenseIdException nonNumericLicenseIdException) {
                // empty catch block
            }
        }
        this.nextLicenseRef = highestNonStdLicense + 1;
    }

    public synchronized String getNextLicenseRef() {
        int nextLicNum = this.getAndIncrementNextLicenseRef();
        String retval = SpdxDocumentContainer.formNonStandardLicenseID(nextLicNum);
        return retval;
    }

    public int getLicenseRefNum(String licenseID) throws NonNumericLicenseIdException {
        Matcher matcher = LICENSE_ID_PATTERN_NUMERIC.matcher(licenseID);
        if (!matcher.matches()) {
            throw new NonNumericLicenseIdException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        int numGroups = matcher.groupCount();
        if (numGroups != 1) {
            throw new NonNumericLicenseIdException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        try {
            int idNum = Integer.parseInt(matcher.group(1));
            return idNum;
        }
        catch (NumberFormatException ex) {
            throw new NonNumericLicenseIdException("Error parsing number " + matcher.group(1));
        }
    }

    public static String formNonStandardLicenseID(int idNum) {
        return "LicenseRef-" + String.valueOf(idNum);
    }

    synchronized int getAndIncrementNextLicenseRef() {
        int retval = this.nextLicenseRef++;
        return retval;
    }

    public ExtractedLicenseInfo addNewExtractedLicenseInfo(String licenseText) throws InvalidSPDXAnalysisException {
        String licenseID = this.getNextLicenseRef();
        ExtractedLicenseInfo retval = new ExtractedLicenseInfo(licenseID, licenseText);
        this.addNewExtractedLicenseInfo(retval);
        return retval;
    }

    public void addNewExtractedLicenseInfo(ExtractedLicenseInfo license) throws InvalidSPDXAnalysisException {
        if (this.extractedLicenseExists(license.getLicenseId())) {
            throw new InvalidSPDXAnalysisException("Can not add license - ID " + license.getLicenseId() + " already exists.");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        Resource s = this.getResource(this.getSpdxDocNode());
        s.addProperty(p, (RDFNode)license.createResource(this));
        this.licenseIdToExtractedLicense.put(license.getLicenseId().toLowerCase(), license);
    }

    public boolean extractedLicenseExists(String id) throws InvalidSPDXAnalysisException {
        return this.licenseIdToExtractedLicense.containsKey(id.toLowerCase());
    }

    public ExtractedLicenseInfo getExtractedLicense(String id) throws InvalidSPDXAnalysisException {
        return this.licenseIdToExtractedLicense.get(id.toLowerCase());
    }

    public void getExtractedLicenseInfosFromModel() throws InvalidSPDXAnalysisException {
        AnyLicenseInfo[] extractedAnyLicenseInfo = this.spdxDocument.findAnyLicenseInfoPropertyValues("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        this.licenseIdToExtractedLicense.clear();
        for (int i = 0; i < extractedAnyLicenseInfo.length; ++i) {
            if (!(extractedAnyLicenseInfo[i] instanceof ExtractedLicenseInfo)) {
                throw new InvalidSPDXAnalysisException("Invalid type for extracted license infos: " + extractedAnyLicenseInfo[i]);
            }
            ExtractedLicenseInfo lic = (ExtractedLicenseInfo)extractedAnyLicenseInfo[i];
            this.licenseIdToExtractedLicense.put(lic.getLicenseId().toLowerCase(), lic);
        }
    }

    public ExtractedLicenseInfo[] getExtractedLicenseInfos() {
        return this.licenseIdToExtractedLicense.values().toArray(new ExtractedLicenseInfo[this.licenseIdToExtractedLicense.values().size()]);
    }

    public void setExtractedLicenseInfos(ExtractedLicenseInfo[] extractedLicenseInfos) throws InvalidSPDXAnalysisException {
        this.spdxDocument.setPropertyValues("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo", extractedLicenseInfos);
        this.initializeNextLicenseRef();
    }

    public void addExtractedLicenseInfos(ExtractedLicenseInfo license) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return;
        }
        try {
            int idNum = this.getLicenseRefNum(license.getLicenseId());
            if (idNum >= this.nextLicenseRef) {
                this.nextLicenseRef = idNum + 1;
            }
        }
        catch (NonNumericLicenseIdException nonNumericLicenseIdException) {
            // empty catch block
        }
        this.licenseIdToExtractedLicense.put(license.getLicenseId().toLowerCase(), license);
        this.spdxDocument.addPropertyValue("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo", license);
    }

    private Resource getResource(Node node) throws InvalidSPDXAnalysisException {
        Resource s;
        if (node.isURI()) {
            s = this.model.createResource(node.getURI());
        } else if (node.isBlank()) {
            s = this.model.createResource(new AnonId(node.getBlankNodeId()));
        } else {
            throw new InvalidSPDXAnalysisException("Node can not be a literal");
        }
        return s;
    }

    public SpdxFile[] getFileReferences() throws InvalidSPDXAnalysisException {
        ArrayList alFiles = Lists.newArrayList();
        Node rdfTypeNode = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        String fileTypeUri = "http://spdx.org/rdf/terms#File";
        Node fileTypeNode = this.model.getResource(fileTypeUri).asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypeNode, (Node)fileTypeNode);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alFiles.add(new SpdxFile(this, t.getSubject()));
        }
        SpdxFile[] retval = new SpdxFile[alFiles.size()];
        return alFiles.toArray(retval);
    }

    private void initializeExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        this.initializeExternalDocumentRefs(RdfModelObject.findExternalDocRefPropertyValues("http://spdx.org/rdf/terms#", "externalDocumentRef", this, this.documentNode));
    }

    private void initializeExternalDocumentRefs(ExternalDocumentRef[] externalDocumentRefs) throws InvalidSPDXAnalysisException {
        this.externalDocIdToRef.clear();
        this.externalDocNamespaceToRef.clear();
        if (externalDocumentRefs == null) {
            return;
        }
        for (int i = 0; i < externalDocumentRefs.length; ++i) {
            this.externalDocIdToRef.put(externalDocumentRefs[i].getExternalDocumentId(), externalDocumentRefs[i]);
            this.externalDocNamespaceToRef.put(externalDocumentRefs[i].getSpdxDocumentNamespace(), externalDocumentRefs[i]);
        }
    }

    @Override
    public String documentNamespaceToId(String externalNamespace) {
        ExternalDocumentRef ref = this.externalDocNamespaceToRef.get(externalNamespace);
        if (ref == null) {
            return null;
        }
        return ref.getExternalDocumentId();
    }

    @Override
    public String externalDocumentIdToNamespace(String docId) {
        ExternalDocumentRef ref = this.externalDocIdToRef.get(docId);
        if (ref == null) {
            return null;
        }
        return ref.getSpdxDocumentNamespace();
    }

    public ExternalDocumentRef[] getExternalDocumentRefs() {
        return this.externalDocIdToRef.values().toArray(new ExternalDocumentRef[this.externalDocIdToRef.values().size()]);
    }

    public void setExternalDocumentRefs(ExternalDocumentRef[] externalDocumentRefs) throws InvalidSPDXAnalysisException {
        this.initializeExternalDocumentRefs(externalDocumentRefs);
        this.spdxDocument.setPropertyValues("http://spdx.org/rdf/terms#", "externalDocumentRef", externalDocumentRefs);
    }

    public List<SpdxPackage> findAllPackages() throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node packageTypeObject = this.model.createResource("http://spdx.org/rdf/terms#Package").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)packageTypeObject);
        ArrayList retval = Lists.newArrayList();
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            retval.add((SpdxPackage)SpdxElementFactory.createElementFromModel(this, ((Triple)tripleIter.next()).getSubject()));
        }
        return retval;
    }

    public List<SpdxFile> findAllFiles() throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node fileTypeObject = this.model.createResource("http://spdx.org/rdf/terms#File").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)fileTypeObject);
        ArrayList retval = Lists.newArrayList();
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            retval.add((SpdxFile)SpdxElementFactory.createElementFromModel(this, ((Triple)tripleIter.next()).getSubject()));
        }
        return retval;
    }

    public void addElement(SpdxElement element) throws InvalidSPDXAnalysisException {
        element.createResource(this, true);
    }

    public List<SpdxElement> findAllElements() throws InvalidSPDXAnalysisException {
        ArrayList retval = Lists.newArrayList();
        retval.add(this.spdxDocument);
        retval.addAll(this.findAllFiles());
        retval.addAll(this.findAllPackages());
        retval.addAll(this.findAllSnippets());
        return retval;
    }

    @Override
    public synchronized Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel nodeObject) {
        Resource retval = duplicate != null ? duplicate : (uri == null ? this.model.createResource(type) : this.model.createResource(uri, type));
        Node node = retval.asNode();
        List<IRdfModel> existingModelObjects = this.nodeModelMap.get(node);
        if (existingModelObjects == null) {
            existingModelObjects = new ArrayList<IRdfModel>();
            this.nodeModelMap.put(node, existingModelObjects);
        }
        boolean found = false;
        for (IRdfModel existing : existingModelObjects) {
            if (existing != nodeObject) continue;
            found = true;
            break;
        }
        if (!found) {
            existingModelObjects.add(nodeObject);
        }
        if (existingModelObjects.size() == 1) {
            nodeObject.setSingleObjectForSameNode();
        } else {
            for (IRdfModel allNodeObjects : existingModelObjects) {
                allNodeObjects.setMultipleObjectsForSameNode();
            }
        }
        return retval;
    }

    @Override
    public synchronized boolean addCheckNodeObject(Node node, IRdfModel nodeObject) {
        List<IRdfModel> existingModelObjects = this.nodeModelMap.get(node);
        if (existingModelObjects == null) {
            existingModelObjects = new ArrayList<IRdfModel>();
            this.nodeModelMap.put(node, existingModelObjects);
        }
        boolean found = false;
        for (IRdfModel existing : existingModelObjects) {
            if (existing != nodeObject) continue;
            found = true;
            break;
        }
        if (found) {
            return existingModelObjects.size() != 1;
        }
        if (existingModelObjects.size() > 0) {
            for (IRdfModel existing : existingModelObjects) {
                existing.setMultipleObjectsForSameNode();
            }
            existingModelObjects.add(nodeObject);
            return true;
        }
        existingModelObjects.add(nodeObject);
        return false;
    }

    public List<SpdxSnippet> findAllSnippets() throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node snippetTypeObject = this.model.createResource("http://spdx.org/rdf/terms#Snippet").asNode();
        Triple m = Triple.createMatch(null, (Node)rdfTypePredicate, (Node)snippetTypeObject);
        ArrayList retval = Lists.newArrayList();
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            retval.add((SpdxSnippet)SpdxElementFactory.createElementFromModel(this, ((Triple)tripleIter.next()).getSubject()));
        }
        return retval;
    }

    static {
        SUPPORTED_SPDX_VERSIONS.add("SPDX-2.2");
        SUPPORTED_SPDX_VERSIONS.add(POINT_EIGHT_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(POINT_NINE_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ZERO_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ONE_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_TWO_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(TWO_POINT_ZERO_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(TWO_POINT_ONE_VERSION);
        SUPPORTED_SPDX_VERSIONS.add("SPDX-2.2");
    }
}

