/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.v3jsonldstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jimblackler.jsonschemafriend.GenerationException;
import net.jimblackler.jsonschemafriend.Schema;
import net.jimblackler.jsonschemafriend.SchemaException;
import net.jimblackler.jsonschemafriend.SchemaStore;
import net.jimblackler.jsonschemafriend.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.storage.PropertyDescriptor;

public class JsonLDSchema {
    static final Logger logger = LoggerFactory.getLogger(JsonLDSchema.class);
    private static final String ANY_CLASS_URI_SUFFIX = "/$defs/AnyClass";
    public static final Map<String, String> RESERVED_JAVA_WORDS = new HashMap<String, String>();
    public static final Map<String, String> REVERSE_JAVA_WORDS = new HashMap<String, String>();
    public static final Set<String> BOOLEAN_TYPES = new HashSet<String>();
    public static final Set<String> INTEGER_TYPES = new HashSet<String>();
    public static final Set<String> DOUBLE_TYPES = new HashSet<String>();
    public static final Set<String> STRING_TYPES = new HashSet<String>();
    static final ObjectMapper JSON_MAPPER;
    private static final String OBJECT_TYPE = "http://www.w3.org/2002/07/owl#ObjectProperty";
    private static final String INDIVIDUAL_TYPE = "http://www.w3.org/2002/07/owl#NamedIndividual";
    private JsonNode contexts;
    private Schema spdxRootSchema;
    private Map<String, JsonNode> modelStatements = new HashMap<String, JsonNode>();
    private Validator validator = new Validator();
    private List<String> elementTypes;
    private List<String> anyLicenseInfoTypes;

    public JsonLDSchema(String schemaFileName, String contextFileName, String modelFileName) throws GenerationException {
        JsonNode root;
        InputStream is;
        SchemaStore schemaStore = new SchemaStore();
        this.spdxRootSchema = schemaStore.loadSchema(JsonLDSchema.class.getResourceAsStream("/resources/" + schemaFileName));
        try {
            is = JsonLDSchema.class.getResourceAsStream("/resources/" + contextFileName);
            try {
                if (Objects.isNull(is)) {
                    throw new GenerationException("Unable to open JSON LD context file");
                }
                root = JSON_MAPPER.readTree(is);
                this.contexts = root.get("@context");
                if (Objects.isNull(this.contexts)) {
                    throw new GenerationException("Missing contexts");
                }
                if (!this.contexts.isObject()) {
                    throw new GenerationException("Contexts is not an object");
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e1) {
            throw new GenerationException("I/O Error loading JSON LD Context file", (Throwable)e1);
        }
        try {
            is = JsonLDSchema.class.getResourceAsStream("/resources/" + modelFileName);
            try {
                if (Objects.isNull(is)) {
                    throw new GenerationException("Unable to open JSON LD model file");
                }
                root = JSON_MAPPER.readTree(is);
                Iterator iter = root.elements();
                while (iter.hasNext()) {
                    JsonNode modelStatement = (JsonNode)iter.next();
                    if (!modelStatement.has("@id")) continue;
                    this.modelStatements.put(modelStatement.get("@id").asText(), modelStatement);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e1) {
            throw new GenerationException("I/O Error loading JSON LD model file", (Throwable)e1);
        }
        this.elementTypes = this.collectTypes("Element");
        this.anyLicenseInfoTypes = this.collectTypes("simplelicensing_AnyLicenseInfo");
    }

    private List<String> collectTypes(String superClass) {
        ArrayList<String> retval = new ArrayList<String>();
        for (Schema classSchema : this.getAllClasses()) {
            try {
                if (!this.isSubclassOf(superClass, classSchema)) continue;
                Optional<URI> typeUri = this.getTypeUri(classSchema);
                if (typeUri.isPresent()) {
                    retval.add(this.classUriToType(typeUri.get()));
                    continue;
                }
                logger.warn("No class type found for {}", (Object)classSchema.getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unexpected URI syntax error", e);
            }
        }
        return retval;
    }

    private String classUriToType(URI classUri) {
        String strClassUri = classUri.toString();
        String nameSpace = strClassUri.substring(0, classUri.toString().lastIndexOf(47));
        String profile = nameSpace.substring(nameSpace.lastIndexOf(47) + 1);
        profile = RESERVED_JAVA_WORDS.getOrDefault(profile, profile);
        String className = strClassUri.substring(strClassUri.lastIndexOf(47) + 1);
        className = RESERVED_JAVA_WORDS.getOrDefault(className, className);
        return profile + "." + className;
    }

    public Collection<Schema> getAllClasses() {
        for (Map.Entry entry : this.spdxRootSchema.getSubSchemas().entrySet()) {
            if (!((URI)entry.getKey()).toString().endsWith(ANY_CLASS_URI_SUFFIX)) continue;
            return ((Schema)entry.getValue()).getAnyOf();
        }
        return Collections.emptyList();
    }

    public boolean isSubclassOf(String superClassType, Schema subClass) throws URISyntaxException {
        URI superClassPropertyUri = new URI("#/$defs/" + superClassType + "_props");
        for (Schema allOfSchema : subClass.getAllOf()) {
            if (superClassPropertyUri.equals(allOfSchema.getUri())) {
                return true;
            }
            if (!Objects.nonNull(allOfSchema.getUri()) || !allOfSchema.getUri().toString().endsWith("_props") || !this.isSubclassOf(superClassType, allOfSchema)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProperty(String propertyName, Schema schema) {
        return this.hasProperty(propertyName, schema, new HashSet<Schema>());
    }

    private boolean hasProperty(String propertyName, Schema schema, Set<Schema> checkedSchemas) {
        if (checkedSchemas.contains(schema)) {
            return false;
        }
        checkedSchemas.add(schema);
        if (schema.getProperties().containsKey(propertyName)) {
            return true;
        }
        for (Schema subSchema : schema.getSubSchemas().values()) {
            if (!this.hasProperty(propertyName, subSchema, checkedSchemas)) continue;
            return true;
        }
        for (Schema allOfSchema : schema.getAllOf()) {
            if (!this.hasProperty(propertyName, allOfSchema, checkedSchemas)) continue;
            return true;
        }
        return false;
    }

    public Optional<Schema> getClassSchema(String className) {
        for (Map.Entry entry : this.spdxRootSchema.getSubSchemas().entrySet()) {
            if (!((URI)entry.getKey()).toString().endsWith("/$defs/" + className)) continue;
            return Optional.of((Schema)entry.getValue());
        }
        return Optional.empty();
    }

    public Optional<URI> getTypeUri(Schema classSchema) {
        Optional<String> type = this.getType(classSchema);
        if (type.isPresent()) {
            JsonNode typeUriNode = this.contexts.get(type.get());
            if (Objects.isNull(typeUriNode)) {
                logger.warn("No context entry for {}", (Object)type.get());
                return Optional.empty();
            }
            if (!typeUriNode.isTextual()) {
                logger.warn("Wrong context type for {}", (Object)type.get());
                return Optional.empty();
            }
            try {
                URI retval = new URI(typeUriNode.asText());
                return Optional.of(retval);
            }
            catch (URISyntaxException e) {
                logger.warn("Invalid URI string in context file for {}", (Object)type.get());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<String> getType(Schema classSchema) {
        Schema allOfSchema;
        Map properties;
        Collection allOfs = classSchema.getAllOf();
        if (Objects.isNull(allOfs)) {
            logger.warn("No allOfs for {}", (Object)classSchema.getUri());
            return Optional.empty();
        }
        Schema typeProperty = null;
        Iterator iterator = allOfs.iterator();
        while (iterator.hasNext() && !Objects.nonNull(typeProperty = (Schema)(properties = (allOfSchema = (Schema)iterator.next()).getProperties()).get("type"))) {
        }
        if (Objects.isNull(typeProperty)) {
            return Optional.empty();
        }
        Collection oneOf = typeProperty.getOneOf();
        if (Objects.isNull(oneOf) || oneOf.isEmpty()) {
            logger.warn("No OneOf for class schema type property {}", (Object)classSchema.getUri());
            return Optional.empty();
        }
        if (oneOf.size() > 1) {
            logger.warn("Too many OneOfs for class schema type property {}", (Object)classSchema.getUri());
            return Optional.empty();
        }
        Iterator iterator2 = oneOf.iterator();
        if (iterator2.hasNext()) {
            Schema oneOfSchema = (Schema)iterator2.next();
            Object typeString = oneOfSchema.getConst();
            if (Objects.isNull(typeString)) {
                logger.warn("Type string is null {}", (Object)classSchema.getUri());
                return Optional.empty();
            }
            if (typeString instanceof String) {
                return Optional.of((String)typeString);
            }
            logger.warn("Type string is not of type string {}", (Object)classSchema.getUri());
            return Optional.empty();
        }
        return Optional.empty();
    }

    public boolean validate(JsonNode root) {
        try {
            this.validator.validate(this.spdxRootSchema, JSON_MAPPER.treeToValue((TreeNode)root, Map.class));
            return true;
        }
        catch (SchemaException e) {
            logger.error("JSON object does not match schema: {}", (Object)e.getMessage());
            return false;
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to parse JSON object: {}", (Object)e.getMessage());
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public boolean validate(File spdxJsonFile) throws IOException {
        try {
            this.validator.validate(this.spdxRootSchema, spdxJsonFile);
            return true;
        }
        catch (SchemaException e) {
            logger.error("JSON object does not match schema: {}", (Object)e.getMessage());
            return false;
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to parse JSON object: {}", (Object)e.getMessage());
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public List<String> getElementTypes() {
        return this.elementTypes;
    }

    public List<String> getAnyLicenseInfoTypes() {
        return this.anyLicenseInfoTypes;
    }

    public Optional<String> getPropertyType(String propertyName) {
        JsonNode propertytNode = this.contexts.get(propertyName);
        if (Objects.isNull(propertytNode)) {
            return Optional.empty();
        }
        JsonNode typeNode = propertytNode.get("@type");
        return Objects.isNull(typeNode) ? Optional.empty() : Optional.of(typeNode.asText());
    }

    public Optional<String> getVocab(String propertyName) {
        JsonNode propertyNode = this.contexts.get(propertyName);
        if (Objects.isNull(propertyNode)) {
            return Optional.empty();
        }
        JsonNode contextNode = propertyNode.get("@context");
        if (Objects.isNull(contextNode)) {
            return Optional.empty();
        }
        JsonNode vocabNode = contextNode.get("@vocab");
        return Objects.isNull(vocabNode) ? Optional.empty() : Optional.of(vocabNode.asText());
    }

    public Optional<PropertyDescriptor> getPropertyDescriptor(String fieldName) {
        String propName = REVERSE_JAVA_WORDS.getOrDefault(fieldName, fieldName);
        JsonNode propertyNode = this.contexts.get(propName);
        if (Objects.isNull(propertyNode)) {
            return Optional.empty();
        }
        JsonNode idNode = propertyNode.get("@id");
        if (Objects.isNull(idNode)) {
            return Optional.empty();
        }
        String propertyUri = idNode.asText();
        String namespace = propertyUri.substring(0, propertyUri.lastIndexOf(47) + 1);
        String name = propertyUri.substring(propertyUri.lastIndexOf(47) + 1);
        return Optional.of(new PropertyDescriptor(name, namespace));
    }

    private Optional<JsonNode> getPropertyShacl(String propertyName) {
        JsonNode propertytNode = this.contexts.get(propertyName);
        if (Objects.isNull(propertytNode)) {
            return Optional.empty();
        }
        JsonNode idNode = propertytNode.get("@id");
        if (Objects.isNull(idNode)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.modelStatements.get(idNode.asText()));
    }

    public boolean isSpdxObject(String propertyName) {
        if (this.isEnum(propertyName)) {
            return false;
        }
        Optional<JsonNode> shacl = this.getPropertyShacl(propertyName);
        if (!shacl.isPresent()) {
            return false;
        }
        boolean objectType = false;
        JsonNode types = shacl.get().get("@type");
        if (Objects.isNull(types)) {
            return false;
        }
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            if (!OBJECT_TYPE.equals(((JsonNode)iter.next()).asText())) continue;
            objectType = true;
        }
        return objectType;
    }

    public boolean isIndividual(String propertyName, String propertyValue) {
        if (!this.isSpdxObject(propertyName)) {
            return false;
        }
        JsonNode context = this.contexts.get(propertyValue);
        String id = Objects.nonNull(context) && context.has("@id") ? context.get("@id").asText() : propertyValue;
        JsonNode shacl = this.modelStatements.get(id);
        if (Objects.isNull(shacl)) {
            return false;
        }
        JsonNode types = shacl.get("@type");
        Iterator iter = types.elements();
        while (iter.hasNext()) {
            if (!INDIVIDUAL_TYPE.equals(((JsonNode)iter.next()).asText())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnum(String propertyName) {
        Optional<String> type = this.getPropertyType(propertyName);
        if (!type.isPresent()) {
            return false;
        }
        if (!"@vocab".equals(type.get())) {
            return false;
        }
        Optional<String> vocab = this.getVocab(propertyName);
        return vocab.isPresent() && !vocab.get().endsWith("terms/Core/Element/");
    }

    static {
        RESERVED_JAVA_WORDS.put("Package", "SpdxPackage");
        REVERSE_JAVA_WORDS.put("SpdxPackage", "Package");
        RESERVED_JAVA_WORDS.put("package", "spdxPackage");
        REVERSE_JAVA_WORDS.put("spdxPackage", "package");
        RESERVED_JAVA_WORDS.put("File", "SpdxFile");
        REVERSE_JAVA_WORDS.put("SpdxFile", "File");
        RESERVED_JAVA_WORDS.put("file", "spdxFile");
        REVERSE_JAVA_WORDS.put("spdxFile", "file");
        RESERVED_JAVA_WORDS.put("import", "spdxImport");
        REVERSE_JAVA_WORDS.put("spdxImport", "import");
        BOOLEAN_TYPES.add("http://www.w3.org/2001/XMLSchema#boolean");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#integer");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#nonPositiveInteger");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#nonNegativeInteger");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#positiveInteger");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#negativeInteger");
        INTEGER_TYPES.add("http://www.w3.org/2001/XMLSchema#long");
        DOUBLE_TYPES.add("http://www.w3.org/2001/XMLSchema#decimal");
        DOUBLE_TYPES.add("http://www.w3.org/2001/XMLSchema#float");
        DOUBLE_TYPES.add("http://www.w3.org/2001/XMLSchema#double");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#duration");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#dateType");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#dateTimeStamp");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#time");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#date");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#string");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#normalizedString");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#token");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#language");
        STRING_TYPES.add("http://www.w3.org/2001/XMLSchema#anyURI");
        JSON_MAPPER = new ObjectMapper();
    }
}

