/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.v3jsonldstore;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jimblackler.jsonschemafriend.GenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SimpleUriValue;
import org.spdx.core.TypedValue;
import org.spdx.library.ListedLicenses;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;
import org.spdx.v3jsonldstore.JsonLDSchema;

public class JsonLDDeserializer {
    static final Logger logger = LoggerFactory.getLogger(JsonLDDeserializer.class);
    static final Set<String> ALL_SPDX_TYPES;
    static final Set<String> NON_PROPERTY_FIELD_NAMES;
    static final Map<String, String> JSON_PREFIX_TO_MODEL_PREFIX;
    static final String SPDX_ID_PROP = "spdxId";
    private static final String SPEC_VERSION_PROP = "specVersion";
    private final IModelStore modelStore;
    private final ModelCopyManager copyManager;
    private final ConcurrentMap<String, String> jsonAnonToStoreAnon = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, JsonLDSchema> versionToSchema = new ConcurrentHashMap<String, JsonLDSchema>();

    public JsonLDDeserializer(IModelStore modelStore) {
        this.modelStore = modelStore;
        this.copyManager = new ModelCopyManager();
    }

    public List<TypedValue> deserializeGraph(JsonNode graph) throws InvalidSPDXAnalysisException {
        ArrayList<TypedValue> nonAnonGraphItems = new ArrayList<TypedValue>();
        if (!graph.isArray()) {
            logger.error("Invalid type for deserializeGraph - must be an array");
            throw new InvalidSPDXAnalysisException("Invalid type for deserializeGraph - must be an array");
        }
        Map<String, String> creationInfoIdToSpecVersion = this.findCreationInfos(graph);
        HashMap<String, TypedValue> graphIdToTypedValue = new HashMap<String, TypedValue>();
        Iterator iter = graph.elements();
        while (iter.hasNext()) {
            String id;
            JsonNode graphNode = (JsonNode)iter.next();
            String string = id = graphNode.has(SPDX_ID_PROP) ? graphNode.get(SPDX_ID_PROP).asText() : graphNode.get("@id").asText();
            if (Objects.nonNull(id)) {
                Optional<String> type = this.typeNodeToType(graphNode.get("type"));
                if (!type.isPresent()) continue;
                String specVersion = this.getSpecVersionFromNode(graphNode, creationInfoIdToSpecVersion, SpdxModelFactory.getLatestSpecVersion());
                TypedValue tv = this.createTypedValueFromNode(id, type.get(), specVersion);
                this.modelStore.create(tv);
                graphIdToTypedValue.put(id, tv);
                if (this.modelStore.isAnon(id)) continue;
                nonAnonGraphItems.add(tv);
                continue;
            }
            logger.warn("Missing ID for one of the SPDX objects in the graph");
        }
        iter = graph.elements();
        while (iter.hasNext()) {
            try {
                this.deserializeCoreObject((JsonNode)iter.next(), SpdxModelFactory.getLatestSpecVersion(), creationInfoIdToSpecVersion, graphIdToTypedValue);
            }
            catch (GenerationException e) {
                throw new InvalidSPDXAnalysisException("Unable to open schema file");
            }
        }
        return nonAnonGraphItems;
    }

    private TypedValue createTypedValueFromNode(String id, String type, String specVersion) throws InvalidSPDXAnalysisException {
        String storeId;
        if (id.startsWith("_:")) {
            if (!this.jsonAnonToStoreAnon.containsKey(id)) {
                this.jsonAnonToStoreAnon.put(id, this.modelStore.getNextId(IModelStore.IdType.Anonymous));
            }
            storeId = (String)this.jsonAnonToStoreAnon.get(id);
        } else {
            storeId = id;
        }
        return new TypedValue(storeId, type, specVersion);
    }

    private Map<String, String> findCreationInfos(JsonNode graph) {
        HashMap<String, String> retval = new HashMap<String, String>();
        Iterator iter = graph.elements();
        while (iter.hasNext()) {
            String id;
            JsonNode graphNode = (JsonNode)iter.next();
            Optional<String> type = this.typeNodeToType(graphNode.get("type"));
            if (!type.isPresent() || !"Core.CreationInfo".equals(type.get())) continue;
            String string = id = graphNode.has(SPDX_ID_PROP) ? graphNode.get(SPDX_ID_PROP).asText() : graphNode.get("@id").asText();
            if (graphNode.has(SPEC_VERSION_PROP) && Objects.nonNull(id)) {
                retval.put(id, graphNode.get(SPEC_VERSION_PROP).asText());
                continue;
            }
            logger.warn("Unable to obtain spec version for a creation info: {}", (Object)(Objects.isNull(id) ? "[no ID]" : id));
        }
        return retval;
    }

    String getSpecVersionFromNode(JsonNode node, Map<String, String> creationInfoIdToSpecVersion, String defaultSpecVersion) {
        if (node.has(SPEC_VERSION_PROP)) {
            return node.get(SPEC_VERSION_PROP).asText();
        }
        if (node.has("creationInfo")) {
            JsonNode creationInfoNode = node.get("creationInfo");
            if (creationInfoNode.isObject()) {
                if (creationInfoNode.has(SPEC_VERSION_PROP)) {
                    return creationInfoNode.get(SPEC_VERSION_PROP).asText();
                }
                logger.warn("Missing creation info object spec version");
                return defaultSpecVersion;
            }
            String creationInfoId = creationInfoNode.asText();
            if (creationInfoIdToSpecVersion.containsKey(creationInfoId)) {
                return creationInfoIdToSpecVersion.get(creationInfoId);
            }
            logger.warn("Missing creation info string spec version");
            return defaultSpecVersion;
        }
        return defaultSpecVersion;
    }

    private synchronized TypedValue deserializeCoreObject(JsonNode node, String defaultSpecVersion, Map<String, String> creationInfoIdToSpecVersion, Map<String, TypedValue> graphIdToTypedValue) throws InvalidSPDXAnalysisException, GenerationException {
        TypedValue tv = this.getOrCreateCoreObject(node, graphIdToTypedValue, defaultSpecVersion, creationInfoIdToSpecVersion);
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            PropertyDescriptor property;
            Map.Entry field = (Map.Entry)fields.next();
            if (NON_PROPERTY_FIELD_NAMES.contains(field.getKey())) continue;
            try {
                Optional<PropertyDescriptor> optDesc = this.jsonFieldNameToProperty((String)field.getKey(), tv.getSpecVersion());
                if (optDesc.isEmpty()) {
                    throw new InvalidSPDXAnalysisException("No property descriptor for field " + (String)field.getKey());
                }
                property = optDesc.get();
            }
            catch (GenerationException e) {
                throw new InvalidSPDXAnalysisException("Unable to convert a JSON field name to a property", (Throwable)e);
            }
            if (((JsonNode)field.getValue()).isArray()) {
                Iterator elements = ((JsonNode)field.getValue()).elements();
                while (elements.hasNext()) {
                    this.modelStore.addValueToCollection(tv.getObjectUri(), property, this.toStoredObject((String)field.getKey(), (JsonNode)elements.next(), tv.getSpecVersion(), creationInfoIdToSpecVersion, graphIdToTypedValue));
                }
                continue;
            }
            this.modelStore.setValue(tv.getObjectUri(), property, this.toStoredObject((String)field.getKey(), (JsonNode)field.getValue(), tv.getSpecVersion(), creationInfoIdToSpecVersion, graphIdToTypedValue));
        }
        return tv;
    }

    private TypedValue getOrCreateCoreObject(JsonNode node, Map<String, TypedValue> graphIdToTypedValue, String defaultSpecVersion, Map<String, String> creationInfoIdToSpecVersion) throws InvalidSPDXAnalysisException {
        String id;
        String jsonNodeId;
        if (node.has("@id")) {
            jsonNodeId = node.get("@id").asText();
        } else {
            String string = jsonNodeId = node.has(SPDX_ID_PROP) ? node.get(SPDX_ID_PROP).asText() : null;
        }
        if (graphIdToTypedValue.containsKey(jsonNodeId)) {
            return graphIdToTypedValue.get(jsonNodeId);
        }
        if (Objects.isNull(jsonNodeId)) {
            id = this.modelStore.getNextId(IModelStore.IdType.Anonymous);
        } else if (jsonNodeId.startsWith("_:")) {
            if (!this.jsonAnonToStoreAnon.containsKey(jsonNodeId)) {
                this.jsonAnonToStoreAnon.put(jsonNodeId, this.modelStore.getNextId(IModelStore.IdType.Anonymous));
            }
            id = (String)this.jsonAnonToStoreAnon.get(jsonNodeId);
        } else {
            id = jsonNodeId;
        }
        Optional<String> type = this.typeNodeToType(node.get("type"));
        if (type.isEmpty()) {
            logger.error("Missing type for core object {}", (Object)node);
            throw new InvalidSPDXAnalysisException("Missing type for core object " + String.valueOf(node));
        }
        String specVersion = this.getSpecVersionFromNode(node, creationInfoIdToSpecVersion, defaultSpecVersion);
        TypedValue tv = new TypedValue(id, type.get(), specVersion);
        this.modelStore.create(tv);
        graphIdToTypedValue.put(id, tv);
        return tv;
    }

    private Object toStoredObject(String propertyName, JsonNode value, String specVersion, Map<String, String> creationInfoIdToSpecVersion, Map<String, TypedValue> graphIdToTypedValue) throws InvalidSPDXAnalysisException, GenerationException {
        Optional<String> propertyType = this.getOrCreateSchema(specVersion).getPropertyType(propertyName);
        switch (value.getNodeType()) {
            case ARRAY: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON array to a stored object");
            }
            case BOOLEAN: {
                if (propertyType.isEmpty() || JsonLDSchema.BOOLEAN_TYPES.contains(propertyType.get())) {
                    return value.asBoolean();
                }
                if (JsonLDSchema.STRING_TYPES.contains(propertyType.get())) {
                    return value.asText();
                }
                throw new InvalidSPDXAnalysisException("Type mismatch.  Expecting " + String.valueOf(propertyType) + " but was a JSON Boolean");
            }
            case NULL: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON NULL to a stored object");
            }
            case NUMBER: {
                if (propertyType.isEmpty() || JsonLDSchema.INTEGER_TYPES.contains(propertyType.get())) {
                    return value.asInt();
                }
                if (JsonLDSchema.DOUBLE_TYPES.contains(propertyType.get())) {
                    return value.asDouble();
                }
                if (JsonLDSchema.STRING_TYPES.contains(propertyType.get())) {
                    return value.asText();
                }
                throw new InvalidSPDXAnalysisException("Type mismatch.  Expecting " + String.valueOf(propertyType) + " but was a JSON Boolean");
            }
            case OBJECT: {
                return this.deserializeCoreObject(value, specVersion, creationInfoIdToSpecVersion, graphIdToTypedValue);
            }
            case STRING: {
                return this.jsonStringToStoredValue(propertyName, value, specVersion, graphIdToTypedValue);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported JSON node type: " + String.valueOf(value));
    }

    private Object jsonStringToStoredValue(String propertyName, JsonNode jsonValue, String specVersion, Map<String, TypedValue> graphIdToTypedValue) throws InvalidSPDXAnalysisException, GenerationException {
        JsonLDSchema schema = this.getOrCreateSchema(specVersion);
        if (schema.isSpdxObject(propertyName)) {
            return this.jsonStringToSpdxObject(jsonValue, specVersion, graphIdToTypedValue);
        }
        if (schema.isEnum(propertyName)) {
            Optional<String> vocab = schema.getVocab(propertyName);
            if (vocab.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Missing vocabulary for enum property " + propertyName);
            }
            return new SimpleUriValue(vocab.get() + jsonValue.asText());
        }
        Optional<String> propertyType = schema.getPropertyType(propertyName);
        if (propertyType.isEmpty()) {
            logger.warn("Missing property type for value {}.  Defaulting to a string type", (Object)jsonValue);
            return jsonValue.asText();
        }
        if (JsonLDSchema.STRING_TYPES.contains(propertyType.get())) {
            return jsonValue.asText();
        }
        if (JsonLDSchema.DOUBLE_TYPES.contains(propertyType.get())) {
            return Double.parseDouble(jsonValue.asText());
        }
        if (JsonLDSchema.INTEGER_TYPES.contains(propertyType.get())) {
            return Integer.parseInt(jsonValue.asText());
        }
        if (JsonLDSchema.BOOLEAN_TYPES.contains(propertyType.get())) {
            return Boolean.parseBoolean(jsonValue.asText());
        }
        throw new InvalidSPDXAnalysisException("Unknown type: " + propertyType.get() + " for property " + propertyName);
    }

    private Object jsonStringToSpdxObject(JsonNode jsonValue, String specVersion, Map<String, TypedValue> graphIdToTypedValue) throws InvalidSPDXAnalysisException {
        if (graphIdToTypedValue.containsKey(jsonValue.asText())) {
            return graphIdToTypedValue.get(jsonValue.asText());
        }
        if (jsonValue.asText().startsWith("http://spdx.org/licenses/")) {
            String licenseOrExceptionId = SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId((String)jsonValue.asText());
            if (ListedLicenses.getListedLicenses().isSpdxListedLicenseId(licenseOrExceptionId) || ListedLicenses.getListedLicenses().isSpdxListedExceptionId(licenseOrExceptionId)) {
                return this.copyManager.copy(this.modelStore, ListedLicenses.getListedLicenses().getLicenseModelStore(), jsonValue.asText(), specVersion, null);
            }
            return new SimpleUriValue(jsonValue.asText());
        }
        if (!jsonValue.asText().startsWith("_:")) {
            return new SimpleUriValue(jsonValue.asText());
        }
        throw new InvalidSPDXAnalysisException("Can not determine property type for " + jsonValue.asText());
    }

    private Optional<PropertyDescriptor> jsonFieldNameToProperty(String fieldName, String specVersion) throws GenerationException {
        JsonLDSchema schema = this.getOrCreateSchema(specVersion);
        return schema.getPropertyDescriptor(fieldName);
    }

    private JsonLDSchema getOrCreateSchema(String specVersion) throws GenerationException {
        JsonLDSchema schema = (JsonLDSchema)this.versionToSchema.get(specVersion);
        if (Objects.nonNull(schema)) {
            return schema;
        }
        try {
            schema = new JsonLDSchema(String.format("schema-v%s.json", specVersion), String.format("spdx-context-v%s.jsonld", specVersion), String.format("spdx-model-v%s.jsonld", specVersion));
            this.versionToSchema.put(specVersion, schema);
            return schema;
        }
        catch (GenerationException e) {
            logger.warn("Unable to get a schema for spec version {}.  Trying latest spec version.", (Object)specVersion);
            String latestVersion = SpdxModelFactory.getLatestSpecVersion();
            schema = (JsonLDSchema)this.versionToSchema.get(latestVersion);
            if (Objects.nonNull(schema)) {
                return schema;
            }
            try {
                schema = new JsonLDSchema(String.format("schema-v%s.json", latestVersion), String.format("spdx-context-v%s.jsonld", latestVersion), String.format("spdx-model-v%s.jsonld", specVersion));
                this.versionToSchema.put(latestVersion, schema);
                return schema;
            }
            catch (GenerationException e2) {
                logger.error("Unable to get JSON schema for latest version", (Throwable)e2);
                throw e2;
            }
        }
    }

    private Optional<String> typeNodeToType(JsonNode typeNode) {
        String retval;
        if (Objects.isNull(typeNode)) {
            return Optional.empty();
        }
        String jsonType = typeNode.asText();
        if (jsonType.contains("_")) {
            String[] typeParts = jsonType.split("_");
            String profile = JSON_PREFIX_TO_MODEL_PREFIX.get(JsonLDSchema.RESERVED_JAVA_WORDS.getOrDefault(typeParts[0], typeParts[0]));
            if (Objects.isNull(profile)) {
                return Optional.empty();
            }
            retval = profile + "." + JsonLDSchema.RESERVED_JAVA_WORDS.getOrDefault(typeParts[1], typeParts[1]);
        } else {
            retval = "Core." + JsonLDSchema.RESERVED_JAVA_WORDS.getOrDefault(jsonType, jsonType);
        }
        return ALL_SPDX_TYPES.contains(retval) ? Optional.of(retval) : Optional.empty();
    }

    public TypedValue deserializeElement(JsonNode elementNode) throws GenerationException, InvalidSPDXAnalysisException {
        String id;
        HashMap<String, TypedValue> mapIdToTypedValue = new HashMap<String, TypedValue>();
        HashMap<String, String> creationInfoIdToSpecVersion = new HashMap<String, String>();
        String string = id = elementNode.has(SPDX_ID_PROP) ? elementNode.get(SPDX_ID_PROP).asText() : elementNode.get("@id").asText();
        if (Objects.nonNull(id)) {
            if (id.startsWith("_:")) {
                throw new InvalidSPDXAnalysisException("Can not serialize an anonymous (blank) element");
            }
            Optional<String> type = this.typeNodeToType(elementNode.get("type"));
            if (type.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Missing type for element " + id);
            }
            String specVersion = this.getSpecVersionFromNode(elementNode, creationInfoIdToSpecVersion, SpdxModelFactory.getLatestSpecVersion());
            TypedValue tv = new TypedValue(id, type.get(), specVersion);
            this.modelStore.create(tv);
            mapIdToTypedValue.put(id, tv);
        }
        return this.deserializeCoreObject(elementNode, SpdxModelFactory.getLatestSpecVersion(), creationInfoIdToSpecVersion, mapIdToTypedValue);
    }

    static {
        HashSet allSpdxTypes = new HashSet();
        HashMap jsonPrefixToModelPrefix = new HashMap();
        Arrays.spliterator(SpdxConstantsV3.ALL_SPDX_CLASSES).forEachRemaining(c -> {
            allSpdxTypes.add(c);
            String nmSpace = c.split("\\.")[0];
            jsonPrefixToModelPrefix.put(nmSpace.toLowerCase(), nmSpace);
        });
        ALL_SPDX_TYPES = Collections.unmodifiableSet(allSpdxTypes);
        JSON_PREFIX_TO_MODEL_PREFIX = Collections.unmodifiableMap(jsonPrefixToModelPrefix);
        HashSet<String> nonPropertyFieldNames = new HashSet<String>();
        nonPropertyFieldNames.add("@id");
        nonPropertyFieldNames.add(SPDX_ID_PROP);
        nonPropertyFieldNames.add("type");
        NON_PROPERTY_FIELD_NAMES = Collections.unmodifiableSet(nonPropertyFieldNames);
    }
}

