/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.v3jsonldstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jimblackler.jsonschemafriend.GenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistry;
import org.spdx.core.TypedValue;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.v3jsonldstore.JsonLDSchema;

public class JsonLDSerializer {
    static final Logger logger = LoggerFactory.getLogger(JsonLDSerializer.class);
    static final Comparator<JsonNode> NODE_COMPARATOR = new Comparator<JsonNode>(){

        @Override
        public int compare(JsonNode arg0, JsonNode arg1) {
            if (Objects.isNull(arg0)) {
                return Objects.isNull(arg1) ? 0 : 1;
            }
            if (Objects.isNull(arg1)) {
                return -1;
            }
            if (arg0.isTextual()) {
                return arg1.isTextual() ? arg0.asText().compareTo(arg1.asText()) : 1;
            }
            if (arg0.isObject()) {
                return arg1.isObject() ? this.compareObject(arg0, arg1) : 1;
            }
            if (arg0.isArray()) {
                if (!arg1.isArray()) {
                    return 1;
                }
                if (arg0.size() > arg1.size()) {
                    return 1;
                }
                if (arg0.size() < arg1.size()) {
                    return -1;
                }
                ArrayList<JsonNode> list0 = new ArrayList<JsonNode>();
                arg0.spliterator().forEachRemaining(list0::add);
                list0.sort(NODE_COMPARATOR);
                ArrayList<JsonNode> list1 = new ArrayList<JsonNode>();
                arg1.spliterator().forEachRemaining(list1::add);
                list1.sort(NODE_COMPARATOR);
                for (int i = 0; i < list0.size(); ++i) {
                    int retval = this.compare((JsonNode)list0.get(i), (JsonNode)list1.get(i));
                    if (retval == 0) continue;
                    return retval;
                }
                return 0;
            }
            return Integer.compare(arg0.hashCode(), arg1.hashCode());
        }

        private int compareObject(JsonNode arg0, JsonNode arg1) {
            if (!arg1.isObject()) {
                return 1;
            }
            JsonNode spdxId0 = arg0.get("spdxId");
            if (Objects.nonNull(spdxId0)) {
                JsonNode spdxId1 = arg1.get("spdxId");
                if (Objects.isNull(spdxId1)) {
                    return 1;
                }
                return arg0.asText().compareTo(arg1.asText());
            }
            ArrayList fieldNames = new ArrayList();
            arg0.fieldNames().forEachRemaining(fieldNames::add);
            Collections.sort(fieldNames);
            int retval = 0;
            for (String fieldName : fieldNames) {
                JsonNode value1;
                JsonNode value0 = arg0.get(fieldName);
                retval = this.compare(value0, value1 = arg1.get(fieldName));
                if (retval == 0) continue;
                return retval;
            }
            return retval;
        }
    };
    private static final String GENERATED_SERIALIZED_ID_PREFIX = "https://generated-prefix/";
    private static final String CONTEXT_URI = "https://spdx.org/rdf/%s/spdx-context.jsonld";
    private static final String NON_URI_WARNING = "SPDX element has a non-URI ID: {}.  Converting to URI {}.";
    private static final String CONTEXT_PROP = "@context";
    private final IModelStore modelStore;
    private final ObjectMapper jsonMapper;
    private final boolean pretty;
    private final String specVersion;
    private final JsonLDSchema jsonLDSchema;
    private final boolean useExternalListedElements;

    public JsonLDSerializer(ObjectMapper jsonMapper, boolean pretty, boolean useExternalListedElements, String specVersion, IModelStore modelStore) throws GenerationException {
        Objects.requireNonNull(jsonMapper, "JSON Mapper is a required field");
        Objects.requireNonNull(modelStore, "Model store is a required field");
        Objects.requireNonNull(specVersion, "Spec version store is a required field");
        this.jsonMapper = jsonMapper;
        this.pretty = pretty;
        this.modelStore = modelStore;
        this.specVersion = specVersion;
        this.useExternalListedElements = useExternalListedElements;
        this.jsonLDSchema = new JsonLDSchema(String.format("schema-v%s.json", specVersion), String.format("spdx-context-v%s.jsonld", specVersion), String.format("spdx-model-v%s.jsonld", specVersion));
    }

    public JsonNode serialize(@Nullable CoreModelObject objectToSerialize) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(objectToSerialize)) {
            return this.serializeAllObjects();
        }
        if (objectToSerialize instanceof SpdxDocument) {
            return this.serializeSpdxDocument((SpdxDocument)objectToSerialize);
        }
        if (objectToSerialize instanceof Element) {
            return this.serializeElement((Element)objectToSerialize);
        }
        logger.error("Unsupported type to serialize: {}", objectToSerialize.getClass());
        throw new InvalidSPDXAnalysisException("Unsupported type to serialize: " + String.valueOf(objectToSerialize.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode serializeSpdxDocument(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        ObjectNode root = this.jsonMapper.createObjectNode();
        root.put(CONTEXT_PROP, String.format(CONTEXT_URI, this.specVersion));
        HashMap<String, String> idToSerializedId = new HashMap<String, String>();
        ArrayList<JsonNode> graph = new ArrayList<JsonNode>();
        IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(false);
        try {
            HashSet elementsToCopy = new HashSet(spdxDocument.getRootElements());
            elementsToCopy.addAll(spdxDocument.getElements());
            HashSet<CreationInfo> creationInfos = new HashSet<CreationInfo>();
            for (Object element : elementsToCopy) {
                creationInfos.add(element.getCreationInfo());
            }
            int creationIndex = 0;
            for (CreationInfo creationInfo : creationInfos) {
                String serializedId = "_:creationInfo_" + creationIndex++;
                idToSerializedId.put(creationInfo.getObjectUri(), serializedId);
                graph.add(this.modelObjectToJsonNode((CoreModelObject)creationInfo, serializedId, idToSerializedId));
            }
            Object documentSpdxId = spdxDocument.getObjectUri();
            if (this.modelStore.isAnon((String)documentSpdxId)) {
                Object anonId = documentSpdxId;
                documentSpdxId = GENERATED_SERIALIZED_ID_PREFIX + String.valueOf(UUID.randomUUID()) + "#" + this.modelStore.getNextId(IModelStore.IdType.SpdxId);
                idToSerializedId.put((String)anonId, (String)documentSpdxId);
                logger.warn(NON_URI_WARNING, (Object)spdxDocument.getObjectUri(), documentSpdxId);
            }
            graph.add(this.spdxDocumentToJsonNode(spdxDocument, (String)documentSpdxId, idToSerializedId));
            for (String type : this.jsonLDSchema.getElementTypes()) {
                for (Element element : elementsToCopy) {
                    if (!type.equals(element.getType())) continue;
                    Object serializedId = element.getObjectUri();
                    if (this.modelStore.isAnon((String)serializedId)) {
                        String anonId = serializedId;
                        serializedId = GENERATED_SERIALIZED_ID_PREFIX + String.valueOf(UUID.randomUUID()) + "#" + this.modelStore.getNextId(IModelStore.IdType.SpdxId);
                        idToSerializedId.put(anonId, (String)serializedId);
                        logger.warn(NON_URI_WARNING, (Object)element.getObjectUri(), serializedId);
                    }
                    if (this.useExternalListedElements && element.getObjectUri().startsWith("http://spdx.org/licenses/")) continue;
                    graph.add(this.modelObjectToJsonNode((CoreModelObject)element, (String)serializedId, idToSerializedId));
                }
            }
            graph.sort(NODE_COMPARATOR);
            ArrayNode graphNodes = this.jsonMapper.createArrayNode();
            graphNodes.addAll(graph);
            root.set("@graph", (JsonNode)graphNodes);
            ObjectNode objectNode = root;
            return objectNode;
        }
        finally {
            this.modelStore.leaveCriticalSection(lock);
        }
    }

    private JsonNode spdxDocumentToJsonNode(SpdxDocument spdxDocument, String serializedId, Map<String, String> idToSerializedId) throws InvalidSPDXAnalysisException {
        ObjectNode retval = this.jsonMapper.createObjectNode();
        retval.set("spdxId", (JsonNode)new TextNode(serializedId));
        retval.set("type", (JsonNode)new TextNode(this.typeToJsonType("Core.SpdxDocument")));
        for (PropertyDescriptor prop : spdxDocument.getPropertyValueDescriptors()) {
            if (SpdxConstantsV3.PROP_ELEMENT.equals((Object)prop) || SpdxConstantsV3.PROP_NAMESPACE_MAP.equals((Object)prop)) continue;
            if (spdxDocument.getModelStore().isCollectionProperty(spdxDocument.getObjectUri(), prop)) {
                ArrayNode an = this.jsonMapper.createArrayNode();
                Iterator iter = spdxDocument.getModelStore().listValues(spdxDocument.getObjectUri(), prop);
                while (iter.hasNext()) {
                    an.add(this.objectToJsonNode(iter.next(), spdxDocument.getModelStore(), idToSerializedId));
                }
                retval.set(this.propertyToJsonLdPropName(prop), (JsonNode)an);
                continue;
            }
            Optional val = spdxDocument.getModelStore().getValue(spdxDocument.getObjectUri(), prop);
            if (!val.isPresent()) continue;
            retval.set(this.propertyToJsonLdPropName(prop), this.objectToJsonNode(val.get(), spdxDocument.getModelStore(), idToSerializedId));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode serializeElement(Element objectToSerialize) throws InvalidSPDXAnalysisException {
        ObjectNode root = this.jsonMapper.createObjectNode();
        root.put(CONTEXT_PROP, String.format(CONTEXT_URI, this.specVersion));
        HashMap<String, String> idToSerializedId = new HashMap<String, String>();
        ArrayList<JsonNode> graph = new ArrayList<JsonNode>();
        IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(true);
        try {
            Object serializedId = objectToSerialize.getObjectUri();
            if (this.modelStore.isAnon((String)serializedId)) {
                String anonId = serializedId;
                serializedId = GENERATED_SERIALIZED_ID_PREFIX + String.valueOf(UUID.randomUUID()) + "#" + this.modelStore.getNextId(IModelStore.IdType.SpdxId);
                idToSerializedId.put(anonId, (String)serializedId);
                logger.warn(NON_URI_WARNING, (Object)objectToSerialize.getObjectUri(), serializedId);
            }
            if (!this.useExternalListedElements || !objectToSerialize.getObjectUri().startsWith("http://spdx.org/licenses/")) {
                graph.add(this.modelObjectToJsonNode((CoreModelObject)objectToSerialize, (String)serializedId, idToSerializedId));
            }
            graph.sort(NODE_COMPARATOR);
            ArrayNode graphNodes = this.jsonMapper.createArrayNode();
            graphNodes.addAll(graph);
            root.set("@graph", (JsonNode)graphNodes);
            ObjectNode objectNode = root;
            return objectNode;
        }
        finally {
            this.modelStore.leaveCriticalSection(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode serializeAllObjects() throws InvalidSPDXAnalysisException {
        ObjectNode root = this.jsonMapper.createObjectNode();
        root.put(CONTEXT_PROP, String.format(CONTEXT_URI, this.specVersion));
        HashMap<String, String> idToSerializedId = new HashMap<String, String>();
        ModelCopyManager copyManager = new ModelCopyManager();
        ArrayList<JsonNode> graph = new ArrayList<JsonNode>();
        IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(true);
        try {
            List allCreationInfos = SpdxModelFactory.getSpdxObjects((IModelStore)this.modelStore, (IModelCopyManager)copyManager, (String)"Core.CreationInfo", null, null).collect(Collectors.toList());
            for (int i = 0; i < allCreationInfos.size(); ++i) {
                CreationInfo creationInfo = (CreationInfo)allCreationInfos.get(i);
                String serializedId = "_:creationInfo_" + i;
                idToSerializedId.put(creationInfo.getObjectUri(), serializedId);
                graph.add(this.modelObjectToJsonNode((CoreModelObject)creationInfo, serializedId, idToSerializedId));
            }
            for (String type : this.jsonLDSchema.getElementTypes()) {
                List elements = SpdxModelFactory.getSpdxObjects((IModelStore)this.modelStore, (IModelCopyManager)copyManager, (String)type, null, null).collect(Collectors.toList());
                for (Element element : elements) {
                    Object serializedId = element.getObjectUri();
                    if (this.modelStore.isAnon((String)serializedId)) {
                        String anonId = serializedId;
                        serializedId = GENERATED_SERIALIZED_ID_PREFIX + String.valueOf(UUID.randomUUID()) + "#" + this.modelStore.getNextId(IModelStore.IdType.SpdxId);
                        idToSerializedId.put(anonId, (String)serializedId);
                        logger.warn(NON_URI_WARNING, (Object)element.getObjectUri(), serializedId);
                    }
                    if (this.useExternalListedElements && element.getObjectUri().startsWith("http://spdx.org/licenses/")) continue;
                    graph.add(this.modelObjectToJsonNode((CoreModelObject)element, (String)serializedId, idToSerializedId));
                }
            }
            graph.sort(NODE_COMPARATOR);
            ArrayNode graphNodes = this.jsonMapper.createArrayNode();
            graphNodes.addAll(graph);
            root.set("@graph", (JsonNode)graphNodes);
            ObjectNode objectNode = root;
            return objectNode;
        }
        finally {
            this.modelStore.leaveCriticalSection(lock);
        }
    }

    private JsonNode modelObjectToJsonNode(CoreModelObject modelObject, String serializedId, Map<String, String> idToSerializedId) throws InvalidSPDXAnalysisException {
        ObjectNode retval = this.jsonMapper.createObjectNode();
        retval.set(modelObject instanceof Element ? "spdxId" : "@id", (JsonNode)new TextNode(serializedId));
        retval.set("type", (JsonNode)new TextNode(this.typeToJsonType(modelObject.getType())));
        for (PropertyDescriptor prop : modelObject.getPropertyValueDescriptors()) {
            if (modelObject.getModelStore().isCollectionProperty(modelObject.getObjectUri(), prop)) {
                ArrayNode an = this.jsonMapper.createArrayNode();
                Iterator iter = modelObject.getModelStore().listValues(modelObject.getObjectUri(), prop);
                while (iter.hasNext()) {
                    an.add(this.objectToJsonNode(iter.next(), modelObject.getModelStore(), idToSerializedId));
                }
                retval.set(this.propertyToJsonLdPropName(prop), (JsonNode)an);
                continue;
            }
            Optional val = modelObject.getModelStore().getValue(modelObject.getObjectUri(), prop);
            if (!val.isPresent()) continue;
            retval.set(this.propertyToJsonLdPropName(prop), this.objectToJsonNode(val.get(), modelObject.getModelStore(), idToSerializedId));
        }
        return retval;
    }

    private String propertyToJsonLdPropName(PropertyDescriptor prop) {
        String profile = prop.getNameSpace().substring(0, prop.getNameSpace().length() - 1);
        if ("Core".equals(profile = profile.substring(profile.lastIndexOf(47) + 1))) {
            return prop.getName();
        }
        return profile.toLowerCase() + "_" + prop.getName();
    }

    private JsonNode objectToJsonNode(Object object, IModelStore fromModelStore, Map<String, String> idToSerializedId) throws InvalidSPDXAnalysisException {
        if (object instanceof TypedValue) {
            return this.typedValueToJsonNode((TypedValue)object, fromModelStore, idToSerializedId);
        }
        if (object instanceof String) {
            return new TextNode((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? BooleanNode.TRUE : BooleanNode.FALSE;
        }
        if (object instanceof Integer) {
            return new IntNode(((Integer)object).intValue());
        }
        if (object instanceof IndividualUriValue) {
            String individualUri = ((IndividualUriValue)object).getIndividualURI();
            Enum spdxEnum = SpdxModelFactory.uriToEnum((String)individualUri, (String)this.specVersion);
            if (Objects.nonNull(spdxEnum)) {
                String enumName = individualUri.substring(individualUri.lastIndexOf(47) + 1);
                return new TextNode(enumName);
            }
            return new TextNode(individualUri);
        }
        throw new InvalidSPDXAnalysisException("Unknown class for object to json node: " + String.valueOf(object.getClass()));
    }

    private JsonNode typedValueToJsonNode(TypedValue tv, IModelStore fromModelStore, Map<String, String> idToSerializedId) throws InvalidSPDXAnalysisException {
        if (this.jsonLDSchema.getElementTypes().contains(tv.getType())) {
            return new TextNode(idToSerializedId.getOrDefault(tv.getObjectUri(), tv.getObjectUri()));
        }
        if ("Core.CreationInfo".equals(tv.getType()) && idToSerializedId.containsKey(tv.getObjectUri())) {
            return new TextNode(idToSerializedId.getOrDefault(tv.getObjectUri(), tv.getObjectUri()));
        }
        if (this.pretty && this.jsonLDSchema.getAnyLicenseInfoTypes().contains(tv.getType())) {
            AnyLicenseInfo licenseInfo = (AnyLicenseInfo)ModelRegistry.getModelRegistry().inflateModelObject(fromModelStore, tv.getObjectUri(), tv.getType(), (IModelCopyManager)new ModelCopyManager(), tv.getSpecVersion(), false, "");
            return new TextNode(licenseInfo.toString());
        }
        return this.inlinedJsonNode(tv, fromModelStore, idToSerializedId);
    }

    private JsonNode inlinedJsonNode(TypedValue tv, IModelStore fromModelStore, Map<String, String> idToSerializedId) throws InvalidSPDXAnalysisException {
        ObjectNode retval = this.jsonMapper.createObjectNode();
        retval.set("type", (JsonNode)new TextNode(this.typeToJsonType(tv.getType())));
        for (PropertyDescriptor prop : fromModelStore.getPropertyValueDescriptors(tv.getObjectUri())) {
            if (fromModelStore.isCollectionProperty(tv.getObjectUri(), prop)) {
                ArrayNode an = this.jsonMapper.createArrayNode();
                Iterator iter = fromModelStore.listValues(tv.getObjectUri(), prop);
                while (iter.hasNext()) {
                    an.add(this.objectToJsonNode(iter.next(), fromModelStore, idToSerializedId));
                }
                retval.set(this.propertyToJsonLdPropName(prop), (JsonNode)an);
                continue;
            }
            Optional val = fromModelStore.getValue(tv.getObjectUri(), prop);
            if (!val.isPresent()) continue;
            retval.set(this.propertyToJsonLdPropName(prop), this.objectToJsonNode(val.get(), fromModelStore, idToSerializedId));
        }
        return retval;
    }

    private String typeToJsonType(String type) {
        String[] parts = type.split("\\.");
        if ("Core".equals(parts[0])) {
            return JsonLDSchema.REVERSE_JAVA_WORDS.getOrDefault(parts[1], parts[1]);
        }
        return parts[0].toLowerCase() + "_" + JsonLDSchema.REVERSE_JAVA_WORDS.getOrDefault(parts[1], parts[1]);
    }

    public JsonLDSchema getSchema() {
        return this.jsonLDSchema;
    }
}

