/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.v3jsonldstore;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.jimblackler.jsonschemafriend.GenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalElement;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.simple.ExtendedSpdxStore;
import org.spdx.v3jsonldstore.JsonLDDeserializer;
import org.spdx.v3jsonldstore.JsonLDSerializer;

public class JsonLDStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger(JsonLDStore.class);
    static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    boolean pretty = true;
    private boolean useExternalListedElements = false;

    public JsonLDStore(IModelStore baseStore, boolean pretty) {
        super(baseStore);
        this.pretty = pretty;
    }

    public JsonLDStore(IModelStore baseStore) {
        this(baseStore, true);
    }

    public boolean getPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    public void serialize(OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        this.serialize(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream stream, @Nullable CoreModelObject objectToSerialize) throws InvalidSPDXAnalysisException, IOException {
        JsonLDSerializer serializer;
        try {
            serializer = new JsonLDSerializer(JSON_MAPPER, this.pretty, this.useExternalListedElements, SpdxModelFactory.getLatestSpecVersion(), (IModelStore)this);
        }
        catch (GenerationException e) {
            throw new InvalidSPDXAnalysisException("Unable to create JSON LD serializer", (Throwable)e);
        }
        JsonNode output = serializer.serialize(objectToSerialize);
        JsonGenerator jgen = null;
        try {
            jgen = JSON_MAPPER.getFactory().createGenerator(stream);
            if (this.pretty) {
                jgen.useDefaultPrettyPrinter();
            }
            JSON_MAPPER.writeTree(jgen, output);
        }
        finally {
            if (Objects.nonNull(jgen)) {
                jgen.close();
            }
        }
    }

    public SpdxDocument deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        List<String> existingElementUris;
        Objects.requireNonNull(stream, "Input stream must not be null");
        JsonNode root = JSON_MAPPER.readTree(stream);
        if (!overwrite && !(existingElementUris = this.getExistingElementUris(root)).isEmpty()) {
            StringBuilder sb = new StringBuilder("The SPDX element IDs would be overwritten: ");
            sb.append(existingElementUris.get(0));
            int index = 1;
            while (index < 5 && index < existingElementUris.size()) {
                sb.append(", ");
                sb.append(existingElementUris.get(index++));
            }
            if (existingElementUris.size() >= 5) {
                sb.append(", [more]...");
            }
            throw new InvalidSPDXAnalysisException("The SPDX element IDs would be overwritten: " + String.valueOf(sb));
        }
        JsonLDDeserializer deserializer = new JsonLDDeserializer((IModelStore)this);
        if (!root.isObject()) {
            throw new InvalidSPDXAnalysisException("Root of the JSON LD file is not an SPDX object");
        }
        JsonNode graph = root.get("@graph");
        if (Objects.nonNull(graph)) {
            List<TypedValue> graphElements = deserializer.deserializeGraph(graph);
            return this.elementsToSpdxDocument(graphElements);
        }
        try {
            TypedValue element = deserializer.deserializeElement(root);
            return this.elementsToSpdxDocument(Collections.singletonList(element));
        }
        catch (GenerationException e) {
            throw new InvalidSPDXAnalysisException("Error opening or reading SPDX 3.X schema", (Throwable)e);
        }
    }

    private SpdxDocument elementsToSpdxDocument(List<TypedValue> graphElements) throws InvalidSPDXAnalysisException {
        SpdxDocument retval;
        ArrayList existingSpdxDocument = new ArrayList();
        graphElements.forEach(tv -> {
            if ("Core.SpdxDocument".equals(tv.getType())) {
                existingSpdxDocument.add(tv);
            }
        });
        if (existingSpdxDocument.size() == 1) {
            retval = (SpdxDocument)SpdxModelFactory.inflateModelObject((IModelStore)this, (String)((TypedValue)existingSpdxDocument.get(0)).getObjectUri(), (String)"Core.SpdxDocument", null, (String)((TypedValue)existingSpdxDocument.get(0)).getSpecVersion(), (boolean)false, null);
        } else {
            String documentObjectUri = "urn:spdx-document:" + String.valueOf(UUID.randomUUID());
            retval = (SpdxDocument)SpdxModelFactory.inflateModelObject((IModelStore)this, (String)documentObjectUri, (String)"Core.SpdxDocument", null, (String)SpdxModelFactory.getLatestSpecVersion(), (boolean)true, null);
        }
        Collection elements = retval.getElements();
        elements.clear();
        Collection roots = retval.getRootElements();
        boolean addAllToRoot = roots.isEmpty();
        HashSet<String> referencedExternalElementUris = new HashSet<String>();
        HashSet<String> alreadySearched = new HashSet<String>();
        for (TypedValue element : graphElements) {
            if (retval.getObjectUri().equals(element.getObjectUri())) continue;
            CoreModelObject mo = SpdxModelFactory.inflateModelObject((IModelStore)this, (String)element.getObjectUri(), (String)element.getType(), null, (String)element.getSpecVersion(), (boolean)false, null);
            if (mo instanceof Element) {
                elements.add((Element)mo);
                if (addAllToRoot) {
                    roots.add((Element)mo);
                }
                this.addExternalElements(mo, referencedExternalElementUris, alreadySearched);
                continue;
            }
            if (mo instanceof CreationInfo) continue;
            logger.warn("Non element in the serialized graph - {} will not be included in the SPDX document elements", (Object)element.getObjectUri());
        }
        Collection imports = retval.getSpdxImports();
        for (String externalUri : referencedExternalElementUris) {
            imports.add(retval.createExternalMap(this.getNextId(IModelStore.IdType.Anonymous)).setExternalSpdxId(externalUri).build());
        }
        return retval;
    }

    private void addExternalElements(CoreModelObject modelObject, Set<String> referencedExternalElementUris, Set<String> alreadySearched) throws InvalidSPDXAnalysisException {
        if (alreadySearched.contains(modelObject.getObjectUri())) {
            return;
        }
        alreadySearched.add(modelObject.getObjectUri());
        for (PropertyDescriptor pd : modelObject.getPropertyValueDescriptors()) {
            Optional value = modelObject.getObjectPropertyValue(pd);
            if (!value.isPresent()) continue;
            if (value.get() instanceof ExternalElement) {
                referencedExternalElementUris.add(((ExternalElement)value.get()).getIndividualURI());
                continue;
            }
            if (!(value.get() instanceof CoreModelObject)) continue;
            this.addExternalElements((CoreModelObject)value.get(), referencedExternalElementUris, alreadySearched);
        }
    }

    private List<String> getExistingElementUris(JsonNode root) {
        ArrayList<String> retval = new ArrayList<String>();
        JsonNode graph = root.get("@graph");
        if (Objects.nonNull(graph)) {
            if (graph.isArray()) {
                for (JsonNode spdxObject : graph) {
                    JsonNode spdxId = spdxObject.get("spdxId");
                    if (!Objects.nonNull(spdxId) || this.isAnon(spdxId.asText()) || !this.exists(spdxId.asText())) continue;
                    retval.add(spdxId.asText());
                }
            }
        } else {
            JsonNode spdxId = root.get("spdxId");
            if (Objects.nonNull(spdxId) && !this.isAnon(spdxId.asText()) && this.exists(spdxId.asText())) {
                retval.add(spdxId.asText());
            }
        }
        return retval;
    }

    public void setUseExternalListedElements(boolean useExternalListedElements) {
        this.useExternalListedElements = useExternalListedElements;
    }
}

