/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.awtui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AwtAuthenticator
extends Authenticator {
    private static final AwtAuthenticator me = new AwtAuthenticator();
    private final Collection<CachedAuthentication> cached = new ArrayList<CachedAuthentication>();

    public static void install() {
        AwtAuthenticator.setDefault(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(CachedAuthentication ca) {
        AwtAuthenticator awtAuthenticator = me;
        synchronized (awtAuthenticator) {
            AwtAuthenticator.me.cached.add(ca);
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        for (CachedAuthentication ca : this.cached) {
            if (!ca.host.equals(this.getRequestingHost()) || ca.port != this.getRequestingPort()) continue;
            return ca.toPasswordAuthentication();
        }
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        StringBuilder instruction = new StringBuilder();
        instruction.append("Enter username and password for ");
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            instruction.append((Object)this.getRequestorType());
            instruction.append(" ");
            instruction.append(this.getRequestingHost());
            if (this.getRequestingPort() > 0) {
                instruction.append(":");
                instruction.append(this.getRequestingPort());
            }
        } else {
            instruction.append(this.getRequestingURL());
        }
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridx = 0;
        panel.add((Component)new JLabel(instruction.toString()), gbc);
        ++gbc.gridy;
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("Username:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weighty = 1.0;
        JTextField username = new JTextField(20);
        panel.add((Component)username, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("Password:"), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weighty = 1.0;
        JPasswordField password = new JPasswordField(20);
        panel.add((Component)password, gbc);
        ++gbc.gridy;
        if (JOptionPane.showConfirmDialog(null, panel, "Authentication Required", 2, 3) == 0) {
            CachedAuthentication ca = new CachedAuthentication(this.getRequestingHost(), this.getRequestingPort(), username.getText(), new String(password.getPassword()));
            this.cached.add(ca);
            return ca.toPasswordAuthentication();
        }
        return null;
    }

    public static class CachedAuthentication {
        final String host;
        final int port;
        final String user;
        final String pass;

        public CachedAuthentication(String aHost, int aPort, String aUser, String aPass) {
            this.host = aHost;
            this.port = aPort;
            this.user = aUser;
            this.pass = aPass;
        }

        PasswordAuthentication toPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass.toCharArray());
        }
    }
}

