/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.dircache;

import java.io.IOException;
import org.spearce.jgit.dircache.DirCacheBuilder;
import org.spearce.jgit.dircache.DirCacheIterator;
import org.spearce.jgit.dircache.DirCacheTree;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.treewalk.AbstractTreeIterator;

public class DirCacheBuildIterator
extends DirCacheIterator {
    private final DirCacheBuilder builder;

    public DirCacheBuildIterator(DirCacheBuilder dcb) {
        super(dcb.getDirCache());
        this.builder = dcb;
    }

    protected DirCacheBuildIterator(DirCacheBuildIterator p, DirCacheTree dct) {
        super(p, dct);
        this.builder = p.builder;
    }

    public AbstractTreeIterator createSubtreeIterator(Repository repo) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheBuildIterator(this, this.currentSubtree);
    }

    public void skip() throws CorruptObjectException {
        if (this.currentSubtree != null) {
            this.builder.keep(this.ptr, this.currentSubtree.getEntrySpan());
        } else {
            this.builder.add(this.currentEntry);
        }
        this.next(1);
    }

    public void stopWalk() {
        int cur = this.ptr;
        int cnt = this.cache.getEntryCount();
        if (cur < cnt) {
            this.builder.keep(cur, cnt - cur);
        }
    }
}

