/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.dircache;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.util.NB;

public class DirCacheEntry {
    private static final byte[] nullpad = new byte[8];
    public static final int STAGE_0 = 0;
    public static final int STAGE_1 = 1;
    public static final int STAGE_2 = 2;
    public static final int STAGE_3 = 3;
    private static final int P_MTIME = 8;
    private static final int P_MODE = 24;
    private static final int P_SIZE = 36;
    private static final int P_OBJECTID = 40;
    private static final int P_FLAGS = 60;
    private static final int NAME_MASK = 4095;
    static final int INFO_LEN = 62;
    private static final int ASSUME_VALID = 128;
    private final byte[] info;
    private final int infoOffset;
    final byte[] path;

    DirCacheEntry(byte[] sharedInfo, int infoAt, InputStream in) throws IOException {
        this.info = sharedInfo;
        this.infoOffset = infoAt;
        NB.readFully(in, this.info, this.infoOffset, 62);
        int pathLen = NB.decodeUInt16(this.info, this.infoOffset + 60) & 0xFFF;
        int skipped = 0;
        if (pathLen < 4095) {
            this.path = new byte[pathLen];
            NB.readFully(in, this.path, 0, pathLen);
        } else {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] buf = new byte[4095];
            NB.readFully(in, buf, 0, 4095);
            tmp.write(buf);
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    throw new EOFException("Short read of block.");
                }
                if (c == 0) break;
                tmp.write(c);
            }
            this.path = tmp.toByteArray();
            pathLen = this.path.length;
            skipped = 1;
        }
        int actLen = 62 + pathLen;
        int expLen = actLen + 8 & 0xFFFFFFF8;
        NB.skipFully(in, expLen - actLen - skipped);
    }

    public DirCacheEntry(String newPath) {
        this(Constants.encode(newPath));
    }

    public DirCacheEntry(String newPath, int stage) {
        this(Constants.encode(newPath), stage);
    }

    public DirCacheEntry(byte[] newPath) {
        this(newPath, 0);
    }

    public DirCacheEntry(byte[] newPath, int stage) {
        this.info = new byte[62];
        this.infoOffset = 0;
        this.path = newPath;
        int flags = (stage & 3) << 12;
        flags = this.path.length < 4095 ? (flags |= this.path.length) : (flags |= 0xFFF);
        NB.encodeInt16(this.info, this.infoOffset + 60, flags);
    }

    void write(OutputStream os) throws IOException {
        int pathLen = this.path.length;
        os.write(this.info, this.infoOffset, 62);
        os.write(this.path, 0, pathLen);
        int actLen = 62 + pathLen;
        int expLen = actLen + 8 & 0xFFFFFFF8;
        if (actLen != expLen) {
            os.write(nullpad, 0, expLen - actLen);
        }
    }

    final boolean mightBeRacilyClean(int smudge_s, int smudge_ns) {
        int base = this.infoOffset + 8;
        int mtime = NB.decodeInt32(this.info, base);
        if (smudge_s < mtime) {
            return true;
        }
        if (smudge_s == mtime) {
            return smudge_ns <= NB.decodeInt32(this.info, base + 4) / 1000000;
        }
        return false;
    }

    final void smudgeRacilyClean() {
        int base = this.infoOffset + 8;
        Arrays.fill(this.info, base, base + 8, (byte)127);
    }

    final byte[] idBuffer() {
        return this.info;
    }

    final int idOffset() {
        return this.infoOffset + 40;
    }

    public boolean isAssumeValid() {
        return (this.info[this.infoOffset + 60] & 0x80) != 0;
    }

    public void setAssumeValid(boolean assume) {
        if (assume) {
            int n = this.infoOffset + 60;
            this.info[n] = (byte)(this.info[n] | 0x80);
        } else {
            int n = this.infoOffset + 60;
            this.info[n] = (byte)(this.info[n] & 0xFFFFFF7F);
        }
    }

    public int getStage() {
        return this.info[this.infoOffset + 60] >>> 4 & 3;
    }

    public int getRawMode() {
        return NB.decodeInt32(this.info, this.infoOffset + 24);
    }

    public FileMode getFileMode() {
        return FileMode.fromBits(this.getRawMode());
    }

    public void setFileMode(FileMode mode) {
        NB.encodeInt32(this.info, this.infoOffset + 24, mode.getBits());
    }

    public long getLastModified() {
        return this.decodeTS(8);
    }

    public void setLastModified(long when) {
        this.encodeTS(8, when);
    }

    public int getLength() {
        return NB.decodeInt32(this.info, this.infoOffset + 36);
    }

    public void setLength(int sz) {
        NB.encodeInt32(this.info, this.infoOffset + 36, sz);
    }

    public ObjectId getObjectId() {
        return ObjectId.fromRaw(this.idBuffer(), this.idOffset());
    }

    public void setObjectId(AnyObjectId id) {
        id.copyRawTo(this.idBuffer(), this.idOffset());
    }

    public void setObjectIdFromRaw(byte[] bs, int p) {
        int n = 20;
        System.arraycopy(bs, p, this.idBuffer(), this.idOffset(), 20);
    }

    public String getPathString() {
        return Constants.CHARSET.decode(ByteBuffer.wrap(this.path)).toString();
    }

    public void copyMetaData(DirCacheEntry src) {
        int pLen = NB.decodeUInt16(this.info, this.infoOffset + 60) & 0xFFF;
        System.arraycopy(src.info, src.infoOffset, this.info, this.infoOffset, 62);
        NB.encodeInt16(this.info, this.infoOffset + 60, pLen | NB.decodeUInt16(this.info, this.infoOffset + 60) & 0xFFFFF000);
    }

    private long decodeTS(int pIdx) {
        int base = this.infoOffset + pIdx;
        int sec = NB.decodeInt32(this.info, base);
        int ms = NB.decodeInt32(this.info, base + 4) / 1000000;
        return 1000L * (long)sec + (long)ms;
    }

    private void encodeTS(int pIdx, long when) {
        int base = this.infoOffset + pIdx;
        NB.encodeInt32(this.info, base, (int)(when / 1000L));
        NB.encodeInt32(this.info, base + 4, (int)(when % 1000L) * 1000000);
    }
}

