/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.dircache;

import java.io.IOException;
import java.util.Arrays;
import org.spearce.jgit.dircache.DirCache;
import org.spearce.jgit.dircache.DirCacheEntry;
import org.spearce.jgit.dircache.DirCacheTree;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.treewalk.AbstractTreeIterator;

public class DirCacheIterator
extends AbstractTreeIterator {
    protected final DirCache cache;
    private final DirCacheTree tree;
    private final int treeStart;
    private final int treeEnd;
    private final byte[] subtreeId;
    protected int ptr;
    private int nextSubtreePos;
    protected DirCacheEntry currentEntry;
    protected DirCacheTree currentSubtree;

    public DirCacheIterator(DirCache dc) {
        this.cache = dc;
        this.tree = dc.getCacheTree(true);
        this.treeStart = 0;
        this.treeEnd = this.tree.getEntrySpan();
        this.subtreeId = new byte[20];
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    protected DirCacheIterator(DirCacheIterator p, DirCacheTree dct) {
        super(p, p.path, p.pathLen + 1);
        this.cache = p.cache;
        this.tree = dct;
        this.treeStart = p.ptr;
        this.treeEnd = this.treeStart + this.tree.getEntrySpan();
        this.subtreeId = p.subtreeId;
        this.ptr = p.ptr;
        this.parseEntry();
    }

    public AbstractTreeIterator createSubtreeIterator(Repository repo) throws IncorrectObjectTypeException, IOException {
        if (this.currentSubtree == null) {
            throw new IncorrectObjectTypeException(this.getEntryObjectId(), "tree");
        }
        return new DirCacheIterator(this, this.currentSubtree);
    }

    public byte[] idBuffer() {
        if (this.currentSubtree != null) {
            return this.subtreeId;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idBuffer();
        }
        return zeroid;
    }

    public int idOffset() {
        if (this.currentSubtree != null) {
            return 0;
        }
        if (this.currentEntry != null) {
            return this.currentEntry.idOffset();
        }
        return 0;
    }

    public boolean first() {
        return this.ptr == this.treeStart;
    }

    public boolean eof() {
        return this.ptr == this.treeEnd;
    }

    public void next(int delta) {
        while (--delta >= 0) {
            this.ptr = this.currentSubtree != null ? (this.ptr += this.currentSubtree.getEntrySpan()) : ++this.ptr;
            if (this.eof()) break;
            this.parseEntry();
        }
    }

    public void back(int delta) {
        while (--delta >= 0) {
            if (this.currentSubtree != null) {
                --this.nextSubtreePos;
            }
            --this.ptr;
            this.parseEntry();
            if (this.currentSubtree == null) continue;
            this.ptr -= this.currentSubtree.getEntrySpan() - 1;
        }
    }

    private void parseEntry() {
        DirCacheTree s;
        this.currentEntry = this.cache.getEntry(this.ptr);
        byte[] cep = this.currentEntry.path;
        if (this.nextSubtreePos != this.tree.getChildCount() && (s = this.tree.getChild(this.nextSubtreePos)).contains(cep, this.pathOffset, cep.length)) {
            this.currentSubtree = s;
            ++this.nextSubtreePos;
            if (s.isValid()) {
                s.getObjectId().copyRawTo(this.subtreeId, 0);
            } else {
                Arrays.fill(this.subtreeId, (byte)0);
            }
            this.mode = FileMode.TREE.getBits();
            this.path = cep;
            this.pathLen = this.pathOffset + s.nameLength();
            return;
        }
        this.mode = this.currentEntry.getRawMode();
        this.path = cep;
        this.pathLen = cep.length;
        this.currentSubtree = null;
    }

    public DirCacheEntry getDirCacheEntry() {
        return this.currentSubtree == null ? this.currentEntry : null;
    }
}

