/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

public class BinaryDelta {
    public static final byte[] apply(byte[] base, byte[] delta) {
        int c;
        int deltaPtr = 0;
        int baseLen = 0;
        int shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            baseLen |= (c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        if (base.length != baseLen) {
            throw new IllegalArgumentException("base length incorrect");
        }
        int resLen = 0;
        shift = 0;
        do {
            c = delta[deltaPtr++] & 0xFF;
            resLen |= (c & 0x7F) << shift;
            shift += 7;
        } while ((c & 0x80) != 0);
        byte[] result = new byte[resLen];
        int resultPtr = 0;
        while (deltaPtr < delta.length) {
            int cmd;
            if (((cmd = delta[deltaPtr++] & 0xFF) & 0x80) != 0) {
                int copyOffset = 0;
                if ((cmd & 1) != 0) {
                    copyOffset = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 2) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 4) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if ((cmd & 8) != 0) {
                    copyOffset |= (delta[deltaPtr++] & 0xFF) << 24;
                }
                int copySize = 0;
                if ((cmd & 0x10) != 0) {
                    copySize = delta[deltaPtr++] & 0xFF;
                }
                if ((cmd & 0x20) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 8;
                }
                if ((cmd & 0x40) != 0) {
                    copySize |= (delta[deltaPtr++] & 0xFF) << 16;
                }
                if (copySize == 0) {
                    copySize = 65536;
                }
                System.arraycopy(base, copyOffset, result, resultPtr, copySize);
                resultPtr += copySize;
                continue;
            }
            if (cmd != 0) {
                System.arraycopy(delta, deltaPtr, result, resultPtr, cmd);
                deltaPtr += cmd;
                resultPtr += cmd;
                continue;
            }
            throw new IllegalArgumentException("unsupported command 0");
        }
        return result;
    }
}

