/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.spearce.jgit.lib.ByteWindow;
import org.spearce.jgit.lib.WindowedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteArrayWindow
extends ByteWindow<byte[]> {
    boolean loaded;

    ByteArrayWindow(WindowedFile o, long p, int d, byte[] b) {
        super(o, p, d, b, b.length);
    }

    @Override
    int copy(byte[] array, int p, byte[] b, int o, int n) {
        this.ensureLoaded(array);
        n = Math.min(array.length - p, n);
        System.arraycopy(array, p, b, o, n);
        return n;
    }

    @Override
    int inflate(byte[] array, int pos, byte[] b, int o, Inflater inf) throws DataFormatException {
        this.ensureLoaded(array);
        while (!inf.finished()) {
            if (inf.needsInput()) {
                inf.setInput(array, pos, array.length - pos);
                break;
            }
            o += inf.inflate(b, o, b.length - o);
        }
        while (!inf.finished() && !inf.needsInput()) {
            o += inf.inflate(b, o, b.length - o);
        }
        return o;
    }

    @Override
    void inflateVerify(byte[] array, int pos, Inflater inf) throws DataFormatException {
        this.ensureLoaded(array);
        while (!inf.finished()) {
            if (inf.needsInput()) {
                inf.setInput(array, pos, array.length - pos);
                break;
            }
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
        while (!inf.finished() && !inf.needsInput()) {
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
    }

    private synchronized void ensureLoaded(byte[] array) {
        if (!this.loaded) {
            try {
                this.provider.fd.getChannel().read(ByteBuffer.wrap(array), this.start);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot fault in window", e);
            }
            this.loaded = true;
        }
    }
}

