/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.spearce.jgit.lib.ByteWindow;
import org.spearce.jgit.lib.WindowedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteBufferWindow
extends ByteWindow<ByteBuffer> {
    ByteBufferWindow(WindowedFile o, long p, int d, ByteBuffer b) {
        super(o, p, d, b, b.capacity());
    }

    @Override
    final int copy(ByteBuffer buffer, int p, byte[] b, int o, int n) {
        ByteBuffer s = buffer.slice();
        s.position(p);
        n = Math.min(s.remaining(), n);
        s.get(b, o, n);
        return n;
    }

    @Override
    int inflate(ByteBuffer buffer, int pos, byte[] b, int o, Inflater inf) throws DataFormatException {
        byte[] tmp = new byte[512];
        ByteBuffer s = buffer.slice();
        s.position(pos);
        while (s.remaining() > 0 && !inf.finished()) {
            if (inf.needsInput()) {
                int n = Math.min(s.remaining(), tmp.length);
                s.get(tmp, 0, n);
                inf.setInput(tmp, 0, n);
            }
            o += inf.inflate(b, o, b.length - o);
        }
        while (!inf.finished() && !inf.needsInput()) {
            o += inf.inflate(b, o, b.length - o);
        }
        return o;
    }

    @Override
    void inflateVerify(ByteBuffer buffer, int pos, Inflater inf) throws DataFormatException {
        byte[] tmp = new byte[512];
        ByteBuffer s = buffer.slice();
        s.position(pos);
        while (s.remaining() > 0 && !inf.finished()) {
            if (inf.needsInput()) {
                int n = Math.min(s.remaining(), tmp.length);
                s.get(tmp, 0, n);
                inf.setInput(tmp, 0, n);
            }
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
        while (!inf.finished() && !inf.needsInput()) {
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
    }
}

