/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.lang.ref.SoftReference;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.spearce.jgit.lib.WindowCache;
import org.spearce.jgit.lib.WindowedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ByteWindow<T>
extends SoftReference<T> {
    boolean sizeActive = true;
    ByteWindow<?> chainNext;
    ByteWindow<?> lruPrev;
    ByteWindow<?> lruNext;
    final WindowedFile provider;
    final int id;
    final int size;
    final long start;
    final long end;
    protected static final byte[] verifyGarbageBuffer = new byte[2048];

    ByteWindow(WindowedFile o, long pos, int d, T ref, int sz) {
        super(ref, WindowCache.clearedWindowQueue);
        this.provider = o;
        this.size = sz;
        this.id = d;
        this.start = pos;
        this.end = this.start + (long)this.size;
    }

    final boolean contains(WindowedFile neededFile, long neededPos) {
        return this.provider == neededFile && this.start <= neededPos && neededPos < this.end;
    }

    final int copy(T ref, long pos, byte[] dstbuf, int dstoff, int cnt) {
        return this.copy(ref, (int)(pos - this.start), dstbuf, dstoff, cnt);
    }

    abstract int copy(T var1, int var2, byte[] var3, int var4, int var5);

    final int inflate(T ref, long pos, byte[] dstbuf, int dstoff, Inflater inf) throws DataFormatException {
        return this.inflate(ref, (int)(pos - this.start), dstbuf, dstoff, inf);
    }

    abstract int inflate(T var1, int var2, byte[] var3, int var4, Inflater var5) throws DataFormatException;

    final void inflateVerify(T ref, long pos, Inflater inf) throws DataFormatException {
        this.inflateVerify(ref, (int)(pos - this.start), inf);
    }

    abstract void inflateVerify(T var1, int var2, Inflater var3) throws DataFormatException;
}

