/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectWriter;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tree;
import org.spearce.jgit.lib.Treeish;

public class Commit
implements Treeish {
    private static final ObjectId[] EMPTY_OBJECTID_LIST = new ObjectId[0];
    private final Repository objdb;
    private ObjectId commitId;
    private ObjectId treeId;
    private ObjectId[] parentIds;
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private Tree treeObj;
    private byte[] raw;
    private Charset encoding;

    public Commit(Repository db) {
        this.objdb = db;
        this.parentIds = EMPTY_OBJECTID_LIST;
    }

    public Commit(Repository db, ObjectId[] parentIds) {
        this.objdb = db;
        this.parentIds = parentIds;
    }

    public Commit(Repository db, ObjectId id, byte[] raw) {
        int i;
        ObjectId[] old;
        this.objdb = db;
        this.commitId = id;
        this.treeId = ObjectId.fromString(raw, 5);
        this.parentIds = new ObjectId[1];
        int np = 0;
        int rawPtr = 46;
        while (raw[rawPtr] == 112) {
            if (np == 0) {
                this.parentIds[np++] = ObjectId.fromString(raw, rawPtr + 7);
            } else if (np == 1) {
                this.parentIds = new ObjectId[]{this.parentIds[0], ObjectId.fromString(raw, rawPtr + 7)};
                ++np;
            } else {
                if (this.parentIds.length <= np) {
                    old = this.parentIds;
                    this.parentIds = new ObjectId[this.parentIds.length + 32];
                    for (i = 0; i < np; ++i) {
                        this.parentIds[i] = old[i];
                    }
                }
                this.parentIds[np++] = ObjectId.fromString(raw, rawPtr + 7);
            }
            rawPtr += 48;
        }
        if (np != this.parentIds.length) {
            old = this.parentIds;
            this.parentIds = new ObjectId[np];
            for (i = 0; i < np; ++i) {
                this.parentIds[i] = old[i];
            }
        } else if (np == 0) {
            this.parentIds = EMPTY_OBJECTID_LIST;
        }
        this.raw = raw;
    }

    public ObjectId getCommitId() {
        return this.commitId;
    }

    public void setCommitId(ObjectId id) {
        this.commitId = id;
    }

    public ObjectId getTreeId() {
        return this.treeId;
    }

    public void setTreeId(ObjectId id) {
        if (this.treeId == null || !this.treeId.equals(id)) {
            this.treeObj = null;
        }
        this.treeId = id;
    }

    public Tree getTree() throws IOException {
        if (this.treeObj == null) {
            this.treeObj = this.objdb.mapTree(this.getTreeId());
            if (this.treeObj == null) {
                throw new MissingObjectException(this.getTreeId(), "tree");
            }
        }
        return this.treeObj;
    }

    public void setTree(Tree t) {
        this.treeId = t.getTreeId();
        this.treeObj = t;
    }

    public PersonIdent getAuthor() {
        this.decode();
        return this.author;
    }

    public void setAuthor(PersonIdent a) {
        this.author = a;
    }

    public PersonIdent getCommitter() {
        this.decode();
        return this.committer;
    }

    public void setCommitter(PersonIdent c) {
        this.committer = c;
    }

    public ObjectId[] getParentIds() {
        return this.parentIds;
    }

    public String getMessage() {
        this.decode();
        return this.message;
    }

    public void setParentIds(ObjectId[] parentIds) {
        this.parentIds = new ObjectId[parentIds.length];
        for (int i = 0; i < parentIds.length; ++i) {
            this.parentIds[i] = parentIds[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() {
        if (this.raw != null) {
            try {
                int msgstart;
                DataInputStream br = new DataInputStream(new ByteArrayInputStream(this.raw));
                String n = br.readLine();
                if (n == null || !n.startsWith("tree ")) {
                    throw new CorruptObjectException(this.commitId, "no tree");
                }
                while ((n = br.readLine()) != null && n.startsWith("parent ")) {
                }
                if (n == null || !n.startsWith("author ")) {
                    throw new CorruptObjectException(this.commitId, "no author");
                }
                String rawAuthor = n.substring("author ".length());
                n = br.readLine();
                if (n == null || !n.startsWith("committer ")) {
                    throw new CorruptObjectException(this.commitId, "no committer");
                }
                String rawCommitter = n.substring("committer ".length());
                n = br.readLine();
                if (n != null && n.startsWith("encoding")) {
                    this.encoding = Charset.forName(n.substring("encoding ".length()));
                } else if (n == null || !n.equals("")) {
                    throw new CorruptObjectException(this.commitId, "malformed header:" + n);
                }
                byte[] readBuf = new byte[br.available()];
                br.read(readBuf);
                int n2 = readBuf.length != 0 ? (readBuf[0] == 10 ? 1 : 0) : (msgstart = 0);
                if (this.encoding != null) {
                    this.author = new PersonIdent(new String(rawAuthor.getBytes(), this.encoding.name()));
                    this.committer = new PersonIdent(new String(rawCommitter.getBytes(), this.encoding.name()));
                    this.message = new String(readBuf, msgstart, readBuf.length - msgstart, this.encoding.name());
                } else {
                    this.author = new PersonIdent(new String(rawAuthor.getBytes()));
                    this.committer = new PersonIdent(new String(rawCommitter.getBytes()));
                    this.message = new String(readBuf, msgstart, readBuf.length - msgstart);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.raw = null;
            }
        }
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public void commit() throws IOException {
        if (this.getCommitId() != null) {
            throw new IllegalStateException("exists " + this.getCommitId());
        }
        this.setCommitId(new ObjectWriter(this.objdb).writeCommit(this));
    }

    public String toString() {
        return "Commit[" + ObjectId.toString(this.getCommitId()) + " " + this.getAuthor() + "]";
    }

    public void setEncoding(String e) {
        this.encoding = Charset.forName(e);
    }

    public void setEncoding(Charset e) {
        this.encoding = e;
    }

    public String getEncoding() {
        if (this.encoding != null) {
            return this.encoding.name();
        }
        return null;
    }
}

