/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.lib.DeltaPackedObjectLoader;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackFile;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.WindowCursor;

class DeltaOfsPackedObjectLoader
extends DeltaPackedObjectLoader {
    private final long deltaBase;

    DeltaOfsPackedObjectLoader(WindowCursor curs, PackFile pr, long dataOffset, long objectOffset, int deltaSz, long base) {
        super(curs, pr, dataOffset, objectOffset, deltaSz);
        this.deltaBase = base;
    }

    protected PackedObjectLoader getBaseLoader() throws IOException {
        return this.pack.resolveBase(this.curs, this.deltaBase);
    }

    public int getRawType() {
        return 6;
    }

    public ObjectId getDeltaBase() throws IOException {
        ObjectId id = this.pack.findObjectForOffset(this.deltaBase);
        if (id == null) {
            throw new CorruptObjectException("Offset-written delta base for object not found in a pack");
        }
        return id;
    }
}

