/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.lib.BinaryDelta;
import org.spearce.jgit.lib.PackFile;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.UnpackedObjectCache;
import org.spearce.jgit.lib.WindowCursor;

abstract class DeltaPackedObjectLoader
extends PackedObjectLoader {
    private static final int OBJ_COMMIT = 1;
    private final int deltaSize;

    DeltaPackedObjectLoader(WindowCursor curs, PackFile pr, long dataOffset, long objectOffset, int deltaSz) {
        super(curs, pr, dataOffset, objectOffset);
        this.objectType = -1;
        this.deltaSize = deltaSz;
    }

    public int getType() throws IOException {
        if (this.objectType < 0) {
            this.getCachedBytes();
        }
        return this.objectType;
    }

    public long getSize() throws IOException {
        if (this.objectType < 0) {
            this.getCachedBytes();
        }
        return this.objectSize;
    }

    public byte[] getCachedBytes() throws IOException {
        UnpackedObjectCache.Entry cache;
        if (this.objectType != 1 && (cache = this.pack.readCache(this.dataOffset)) != null) {
            this.curs.release();
            this.objectType = cache.type;
            this.objectSize = cache.data.length;
            return cache.data;
        }
        try {
            PackedObjectLoader baseLoader = this.getBaseLoader();
            byte[] data = BinaryDelta.apply(baseLoader.getCachedBytes(), this.pack.decompress(this.dataOffset, this.deltaSize, this.curs));
            this.curs.release();
            this.objectType = baseLoader.getType();
            this.objectSize = data.length;
            if (this.objectType != 1) {
                this.pack.saveCache(this.dataOffset, data, this.objectType);
            }
            return data;
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException("Object at " + this.dataOffset + " in " + this.pack.getPackFile() + " has bad zlib stream");
            coe.initCause(dfe);
            throw coe;
        }
    }

    public long getRawSize() {
        return this.deltaSize;
    }

    protected abstract PackedObjectLoader getBaseLoader() throws IOException;
}

