/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.errors.NotSupportedException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.FileMode;
import org.spearce.jgit.lib.FileTreeEntry;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.ObjectWriter;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.lib.Tree;
import org.spearce.jgit.lib.TreeEntry;
import org.spearce.jgit.util.FS;
import org.spearce.jgit.util.RawParseUtils;

public class GitIndex {
    public static final int STAGE_0 = 0;
    private RandomAccessFile cache;
    private File cacheFile;
    private boolean changed;
    private boolean statDirty;
    private Header header;
    private long lastCacheTime;
    private final Repository db;
    private Map<byte[], Entry> entries = new TreeMap<byte[], Entry>(new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            for (int i = 0; i < o1.length && i < o2.length; ++i) {
                int c = o1[i] - o2[i];
                if (c == 0) continue;
                return c;
            }
            if (o1.length < o2.length) {
                return -1;
            }
            if (o1.length > o2.length) {
                return 1;
            }
            return 0;
        }
    });
    Boolean filemode;

    public GitIndex(Repository db) {
        this.db = db;
        this.cacheFile = new File(db.getDirectory(), "index");
    }

    public boolean isChanged() {
        return this.changed || this.statDirty;
    }

    public void rereadIfNecessary() throws IOException {
        if (this.cacheFile.exists() && this.cacheFile.lastModified() != this.lastCacheTime) {
            this.read();
            this.db.fireIndexChanged();
        }
    }

    public Entry add(File wd, File f) throws IOException {
        byte[] key = GitIndex.makeKey(wd, f);
        Entry e = this.entries.get(key);
        if (e == null) {
            e = new Entry(key, f, 0);
            this.entries.put(key, e);
        } else {
            e.update(f);
        }
        return e;
    }

    public boolean remove(File wd, File f) throws IOException {
        byte[] key = GitIndex.makeKey(wd, f);
        return this.entries.remove(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        this.changed = false;
        this.statDirty = false;
        if (!this.cacheFile.exists()) {
            this.header = null;
            this.entries.clear();
            this.lastCacheTime = 0L;
            return;
        }
        this.cache = new RandomAccessFile(this.cacheFile, "r");
        try {
            FileChannel channel = this.cache.getChannel();
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.cacheFile.length());
            buffer.order(ByteOrder.BIG_ENDIAN);
            int j = channel.read(buffer);
            if (j != buffer.capacity()) {
                throw new IOException("Could not read index in one go, only " + j + " out of " + buffer.capacity() + " read");
            }
            buffer.flip();
            this.header = new Header(buffer);
            this.entries.clear();
            for (int i = 0; i < this.header.entries; ++i) {
                Entry entry = new Entry(buffer);
                this.entries.put(entry.name, entry);
            }
            this.lastCacheTime = this.cacheFile.lastModified();
        }
        finally {
            this.cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        this.checkWriteOk();
        File tmpIndex = new File(this.cacheFile.getAbsoluteFile() + ".tmp");
        File lock = new File(this.cacheFile.getAbsoluteFile() + ".lock");
        if (!lock.createNewFile()) {
            throw new IOException("Index file is in use");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tmpIndex);
            FileChannel fc = fileOutputStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(4096);
            MessageDigest newMessageDigest = Constants.newMessageDigest();
            this.header = new Header(this.entries);
            this.header.write(buf);
            buf.flip();
            newMessageDigest.update(buf.array(), buf.arrayOffset(), buf.limit());
            fc.write(buf);
            buf.flip();
            buf.clear();
            for (Entry e : this.entries.values()) {
                e.write(buf);
                buf.flip();
                newMessageDigest.update(buf.array(), buf.arrayOffset(), buf.limit());
                fc.write(buf);
                buf.flip();
                buf.clear();
            }
            buf.put(newMessageDigest.digest());
            buf.flip();
            fc.write(buf);
            fc.close();
            fileOutputStream.close();
            if (this.cacheFile.exists() && !this.cacheFile.delete()) {
                throw new IOException("Could not rename delete old index");
            }
            if (!tmpIndex.renameTo(this.cacheFile)) {
                throw new IOException("Could not rename temporary index file to index");
            }
            this.changed = false;
            this.statDirty = false;
            this.lastCacheTime = this.cacheFile.lastModified();
            this.db.fireIndexChanged();
        }
        finally {
            if (!lock.delete()) {
                throw new IOException("Could not delete lock file. Should not happen");
            }
            if (tmpIndex.exists() && !tmpIndex.delete()) {
                throw new IOException("Could not delete temporary index file. Should not happen");
            }
        }
    }

    private void checkWriteOk() throws IOException {
        for (Entry e : this.entries.values()) {
            if (e.getStage() == 0) continue;
            throw new NotSupportedException("Cannot work with other stages than zero right now. Won't write corrupt index.");
        }
    }

    static boolean File_canExecute(File f) {
        return FS.INSTANCE.canExecute(f);
    }

    static boolean File_setExecute(File f, boolean value) {
        return FS.INSTANCE.setExecute(f, value);
    }

    static boolean File_hasExecute() {
        return FS.INSTANCE.supportsExecute();
    }

    static byte[] makeKey(File wd, File f) {
        if (!f.getPath().startsWith(wd.getPath())) {
            throw new Error("Path is not in working dir");
        }
        String relName = Repository.stripWorkDir(wd, f);
        return Constants.encode(relName);
    }

    private boolean config_filemode() {
        if (this.filemode != null) {
            return this.filemode;
        }
        RepositoryConfig config = this.db.getConfig();
        return config.getBoolean("core", null, "filemode", true);
    }

    public void readTree(Tree t) throws IOException {
        this.entries.clear();
        this.readTree("", t);
    }

    void readTree(String prefix, Tree t) throws IOException {
        TreeEntry[] members = t.members();
        for (int i = 0; i < members.length; ++i) {
            TreeEntry te = members[i];
            String name = prefix.length() > 0 ? prefix + "/" + te.getName() : te.getName();
            if (te instanceof Tree) {
                this.readTree(name, (Tree)te);
                continue;
            }
            Entry e = new Entry(te, 0);
            this.entries.put(Constants.encode(name), e);
        }
    }

    public Entry addEntry(TreeEntry te) throws IOException {
        byte[] key = Constants.encode(te.getFullName());
        Entry e = new Entry(te, 0);
        this.entries.put(key, e);
        return e;
    }

    public void checkout(File wd) throws IOException {
        for (Entry e : this.entries.values()) {
            if (e.getStage() != 0) continue;
            this.checkoutEntry(wd, e);
        }
    }

    public void checkoutEntry(File wd, Entry e) throws IOException {
        ObjectLoader ol = this.db.openBlob(e.sha1);
        byte[] bytes = ol.getBytes();
        File file = new File(wd, e.getName());
        file.delete();
        file.getParentFile().mkdirs();
        FileChannel channel = new FileOutputStream(file).getChannel();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int j = channel.write(buffer);
        if (j != bytes.length) {
            throw new IOException("Could not write file " + file);
        }
        channel.close();
        if (this.config_filemode() && GitIndex.File_hasExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(e.mode)) {
                if (!GitIndex.File_canExecute(file)) {
                    GitIndex.File_setExecute(file, true);
                }
            } else if (GitIndex.File_canExecute(file)) {
                GitIndex.File_setExecute(file, false);
            }
        }
        e.mtime = file.lastModified() * 1000000L;
        e.ctime = e.mtime;
    }

    public ObjectId writeTree() throws IOException {
        this.checkWriteOk();
        ObjectWriter writer = new ObjectWriter(this.db);
        Tree current = new Tree(this.db);
        Stack<Tree> trees = new Stack<Tree>();
        trees.push(current);
        String[] prevName = new String[]{};
        for (Entry e : this.entries.values()) {
            if (e.getStage() != 0) continue;
            String[] newName = this.splitDirPath(e.getName());
            int c = this.longestCommonPath(prevName, newName);
            while (c < trees.size() - 1) {
                current.setId(writer.writeTree(current));
                trees.pop();
                current = trees.isEmpty() ? null : (Tree)trees.peek();
            }
            while (trees.size() < newName.length) {
                if (!current.existsTree(newName[trees.size() - 1])) {
                    current = new Tree(current, Constants.encode(newName[trees.size() - 1]));
                    current.getParent().addEntry(current);
                    trees.push(current);
                    continue;
                }
                current = (Tree)current.findTreeMember(newName[trees.size() - 1]);
                trees.push(current);
            }
            FileTreeEntry ne = new FileTreeEntry(current, e.sha1, Constants.encode(newName[newName.length - 1]), (e.mode & FileMode.EXECUTABLE_FILE.getBits()) == FileMode.EXECUTABLE_FILE.getBits());
            current.addEntry(ne);
        }
        while (!trees.isEmpty()) {
            current.setId(writer.writeTree(current));
            trees.pop();
            if (trees.isEmpty()) continue;
            current = (Tree)trees.peek();
        }
        return current.getTreeId();
    }

    String[] splitDirPath(String name) {
        int p1;
        String[] tmp = new String[name.length() / 2 + 1];
        int p0 = -1;
        int c = 0;
        while ((p1 = name.indexOf(47, p0 + 1)) != -1) {
            tmp[c++] = name.substring(p0 + 1, p1);
            p0 = p1;
        }
        tmp[c++] = name.substring(p0 + 1);
        String[] ret = new String[c];
        for (int i = 0; i < c; ++i) {
            ret[i] = tmp[i];
        }
        return ret;
    }

    int longestCommonPath(String[] a, String[] b) {
        int i;
        for (i = 0; i < a.length && i < b.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return i;
        }
        return i;
    }

    public Entry[] getMembers() {
        return this.entries.values().toArray(new Entry[this.entries.size()]);
    }

    public Entry getEntry(String path) throws UnsupportedEncodingException {
        return this.entries.get(Repository.gitInternalSlash(Constants.encode(path)));
    }

    public Repository getRepository() {
        return this.db;
    }

    static class Header {
        private int signature;
        private int version;
        int entries;

        Header(ByteBuffer map) throws CorruptObjectException {
            this.read(map);
        }

        private void read(ByteBuffer buf) throws CorruptObjectException {
            this.signature = buf.getInt();
            this.version = buf.getInt();
            this.entries = buf.getInt();
            if (this.signature != 1145655875) {
                throw new CorruptObjectException("Index signature is invalid: " + this.signature);
            }
            if (this.version != 2) {
                throw new CorruptObjectException("Unknown index version (or corrupt index):" + this.version);
            }
        }

        void write(ByteBuffer buf) {
            buf.order(ByteOrder.BIG_ENDIAN);
            buf.putInt(this.signature);
            buf.putInt(this.version);
            buf.putInt(this.entries);
        }

        Header(Map entryset) {
            this.signature = 1145655875;
            this.version = 2;
            this.entries = entryset.size();
        }
    }

    public class Entry {
        private long ctime;
        private long mtime;
        private int dev;
        private int ino;
        private int mode;
        private int uid;
        private int gid;
        private int size;
        private ObjectId sha1;
        private short flags;
        private byte[] name;

        Entry(byte[] key, File f, int stage) throws IOException {
            this.mtime = this.ctime = f.lastModified() * 1000000L;
            this.dev = -1;
            this.ino = -1;
            this.mode = GitIndex.this.config_filemode() && GitIndex.File_canExecute(f) ? FileMode.EXECUTABLE_FILE.getBits() : FileMode.REGULAR_FILE.getBits();
            this.uid = -1;
            this.gid = -1;
            this.size = (int)f.length();
            ObjectWriter writer = new ObjectWriter(GitIndex.this.db);
            this.sha1 = writer.writeBlob(f);
            this.name = key;
            this.flags = (short)(stage << 12 | this.name.length);
        }

        Entry(TreeEntry f, int stage) {
            this.ctime = -1L;
            this.mtime = -1L;
            this.dev = -1;
            this.ino = -1;
            this.mode = f.getMode().getBits();
            this.uid = -1;
            this.gid = -1;
            try {
                this.size = (int)GitIndex.this.db.openBlob(f.getId()).getSize();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.size = -1;
            }
            this.sha1 = f.getId();
            this.name = Constants.encode(f.getFullName());
            this.flags = (short)(stage << 12 | this.name.length);
        }

        Entry(ByteBuffer b) {
            int startposition = b.position();
            this.ctime = (long)b.getInt() * 1000000000L + (long)b.getInt() % 1000000000L;
            this.mtime = (long)b.getInt() * 1000000000L + (long)b.getInt() % 1000000000L;
            this.dev = b.getInt();
            this.ino = b.getInt();
            this.mode = b.getInt();
            this.uid = b.getInt();
            this.gid = b.getInt();
            this.size = b.getInt();
            byte[] sha1bytes = new byte[20];
            b.get(sha1bytes);
            this.sha1 = ObjectId.fromRaw(sha1bytes);
            this.flags = b.getShort();
            this.name = new byte[this.flags & 0xFFF];
            b.get(this.name);
            b.position(startposition + (62 + this.name.length + 8 & 0xFFFFFFF8));
        }

        public boolean update(File f) throws IOException {
            long lm = f.lastModified() * 1000000L;
            boolean modified = this.mtime != lm;
            this.mtime = lm;
            if ((long)this.size != f.length()) {
                modified = true;
            }
            if (GitIndex.this.config_filemode() && GitIndex.File_canExecute(f) != FileMode.EXECUTABLE_FILE.equals(this.mode)) {
                this.mode = FileMode.EXECUTABLE_FILE.getBits();
                modified = true;
            }
            if (modified) {
                this.size = (int)f.length();
                ObjectWriter writer = new ObjectWriter(GitIndex.this.db);
                this.sha1 = writer.writeBlob(f);
                ObjectId newsha1 = this.sha1;
                if (!newsha1.equals(this.sha1)) {
                    modified = true;
                }
                this.sha1 = newsha1;
            }
            return modified;
        }

        void write(ByteBuffer buf) {
            int startposition = buf.position();
            buf.putInt((int)(this.ctime / 1000000000L));
            buf.putInt((int)(this.ctime % 1000000000L));
            buf.putInt((int)(this.mtime / 1000000000L));
            buf.putInt((int)(this.mtime % 1000000000L));
            buf.putInt(this.dev);
            buf.putInt(this.ino);
            buf.putInt(this.mode);
            buf.putInt(this.uid);
            buf.putInt(this.gid);
            buf.putInt(this.size);
            this.sha1.copyRawTo(buf);
            buf.putShort(this.flags);
            buf.put(this.name);
            int end = startposition + (62 + this.name.length + 8 & 0xFFFFFFF8);
            int remain = end - buf.position();
            while (remain-- > 0) {
                buf.put((byte)0);
            }
        }

        public boolean isModified(File wd) {
            return this.isModified(wd, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isModified(File wd, boolean forceContentCheck) {
            if (this.isAssumedValid()) {
                return false;
            }
            if (this.isUpdateNeeded()) {
                return true;
            }
            File file = this.getFile(wd);
            if (!file.exists()) {
                return true;
            }
            int exebits = FileMode.EXECUTABLE_FILE.getBits() ^ FileMode.REGULAR_FILE.getBits();
            if (GitIndex.this.config_filemode() && FileMode.EXECUTABLE_FILE.equals(this.mode)) {
                if (!GitIndex.File_canExecute(file) && GitIndex.File_hasExecute()) {
                    return true;
                }
            } else if (FileMode.REGULAR_FILE.equals(this.mode & ~exebits)) {
                if (!file.isFile()) {
                    return true;
                }
                if (GitIndex.this.config_filemode() && GitIndex.File_canExecute(file) && GitIndex.File_hasExecute()) {
                    return true;
                }
            } else {
                if (FileMode.SYMLINK.equals(this.mode)) {
                    return true;
                }
                if (!FileMode.TREE.equals(this.mode)) {
                    System.out.println("Does not handle mode " + this.mode + " (" + file + ")");
                    return true;
                }
                if (!file.isDirectory()) {
                    return true;
                }
            }
            if (file.length() != (long)this.size) {
                return true;
            }
            long javamtime = this.mtime / 1000000L;
            long lastm = file.lastModified();
            if (javamtime % 1000L == 0L) {
                lastm -= lastm % 1000L;
            }
            if (lastm == javamtime) return false;
            if (!forceContentCheck) {
                return true;
            }
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    boolean ret;
                    ObjectWriter objectWriter = new ObjectWriter(GitIndex.this.db);
                    ObjectId newId = objectWriter.computeBlobSha1(file.length(), is);
                    boolean bl = ret = !newId.equals(this.sha1);
                    return bl;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new Error(e);
            }
        }

        void forceRecheck() {
            this.mtime = -1L;
        }

        private File getFile(File wd) {
            return new File(wd, this.getName());
        }

        public String toString() {
            return this.getName() + "/SHA-1(" + this.sha1.name() + ")/M:" + new Date(this.ctime / 1000000L) + "/C:" + new Date(this.mtime / 1000000L) + "/d" + this.dev + "/i" + this.ino + "/m" + Integer.toString(this.mode, 8) + "/u" + this.uid + "/g" + this.gid + "/s" + this.size + "/f" + this.flags + "/@" + this.getStage();
        }

        public String getName() {
            return RawParseUtils.decode(this.name);
        }

        public byte[] getNameUTF8() {
            return this.name;
        }

        public ObjectId getObjectId() {
            return this.sha1;
        }

        public int getStage() {
            return (this.flags & 0x3000) >> 12;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isAssumedValid() {
            return (this.flags & 0x8000) != 0;
        }

        public boolean isUpdateNeeded() {
            return (this.flags & 0x4000) != 0;
        }

        public void setAssumeValid(boolean assumeValid) {
            this.flags = assumeValid ? (short)(this.flags | 0x8000) : (short)(this.flags & 0xFFFF7FFF);
        }

        public void setUpdateNeeded(boolean updateNeeded) {
            this.flags = updateNeeded ? (short)(this.flags | 0x4000) : (short)(this.flags & 0xFFFFBFFF);
        }

        public int getModeBits() {
            return this.mode;
        }
    }
}

