/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.util.NB;

public class ObjectId
extends AnyObjectId
implements Externalizable {
    private static final ObjectId ZEROID = new ObjectId(0, 0, 0, 0, 0);
    private static final String ZEROID_STR = ZEROID.name();

    public ObjectId() {
    }

    public static final ObjectId zeroId() {
        return ZEROID;
    }

    public static final boolean isId(String id) {
        if (id.length() != 40) {
            return false;
        }
        try {
            for (int k = id.length() - 1; k >= 0; --k) {
                if (fromhex[id.charAt(k)] >= 0) continue;
                return false;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static final String toString(ObjectId i) {
        return i != null ? i.name() : ZEROID_STR;
    }

    public static boolean equals(byte[] firstBuffer, int fi, byte[] secondBuffer, int si) {
        return firstBuffer[fi] == secondBuffer[si] && firstBuffer[fi + 1] == secondBuffer[si + 1] && firstBuffer[fi + 2] == secondBuffer[si + 2] && firstBuffer[fi + 3] == secondBuffer[si + 3] && firstBuffer[fi + 4] == secondBuffer[si + 4] && firstBuffer[fi + 5] == secondBuffer[si + 5] && firstBuffer[fi + 6] == secondBuffer[si + 6] && firstBuffer[fi + 7] == secondBuffer[si + 7] && firstBuffer[fi + 8] == secondBuffer[si + 8] && firstBuffer[fi + 9] == secondBuffer[si + 9] && firstBuffer[fi + 10] == secondBuffer[si + 10] && firstBuffer[fi + 11] == secondBuffer[si + 11] && firstBuffer[fi + 12] == secondBuffer[si + 12] && firstBuffer[fi + 13] == secondBuffer[si + 13] && firstBuffer[fi + 14] == secondBuffer[si + 14] && firstBuffer[fi + 15] == secondBuffer[si + 15] && firstBuffer[fi + 16] == secondBuffer[si + 16] && firstBuffer[fi + 17] == secondBuffer[si + 17] && firstBuffer[fi + 18] == secondBuffer[si + 18] && firstBuffer[fi + 19] == secondBuffer[si + 19];
    }

    public static final ObjectId fromRaw(byte[] bs) {
        return ObjectId.fromRaw(bs, 0);
    }

    public static final ObjectId fromRaw(byte[] bs, int p) {
        int a = NB.decodeInt32(bs, p);
        int b = NB.decodeInt32(bs, p + 4);
        int c = NB.decodeInt32(bs, p + 8);
        int d = NB.decodeInt32(bs, p + 12);
        int e = NB.decodeInt32(bs, p + 16);
        return new ObjectId(a, b, c, d, e);
    }

    public static final ObjectId fromRaw(int[] is) {
        return ObjectId.fromRaw(is, 0);
    }

    public static final ObjectId fromRaw(int[] is, int p) {
        return new ObjectId(is[p], is[p + 1], is[p + 2], is[p + 3], is[p + 4]);
    }

    public static final ObjectId fromString(byte[] buf, int offset) {
        return ObjectId.fromHexString(buf, offset);
    }

    public static final ObjectId fromString(String str) {
        if (str.length() != 40) {
            throw new IllegalArgumentException("Invalid id: " + str);
        }
        return ObjectId.fromHexString(Constants.encodeASCII(str), 0);
    }

    private static final ObjectId fromHexString(byte[] bs, int p) {
        try {
            int a = ObjectId.hexUInt32(bs, p);
            int b = ObjectId.hexUInt32(bs, p + 8);
            int c = ObjectId.hexUInt32(bs, p + 16);
            int d = ObjectId.hexUInt32(bs, p + 24);
            int e = ObjectId.hexUInt32(bs, p + 32);
            return new ObjectId(a, b, c, d, e);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            try {
                String str = new String(bs, p, 40, "US-ASCII");
                throw new IllegalArgumentException("Invalid id: " + str);
            }
            catch (UnsupportedEncodingException e2) {
                throw new IllegalArgumentException("Invalid id");
            }
        }
    }

    protected ObjectId(int new_1, int new_2, int new_3, int new_4, int new_5) {
        this.w1 = new_1;
        this.w2 = new_2;
        this.w3 = new_3;
        this.w4 = new_4;
        this.w5 = new_5;
    }

    protected ObjectId(AnyObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
        this.w5 = src.w5;
    }

    public ObjectId toObjectId() {
        return this;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] sha1 = new byte[20];
        in.read(sha1);
        this.w1 = NB.decodeInt32(sha1, 0);
        this.w2 = NB.decodeInt32(sha1, 4);
        this.w3 = NB.decodeInt32(sha1, 8);
        this.w4 = NB.decodeInt32(sha1, 12);
        this.w5 = NB.decodeInt32(sha1, 16);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] sha1 = new byte[20];
        this.copyRawTo(sha1, 0);
        out.write(sha1);
    }
}

