/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdMap<V>
extends AbstractMap<ObjectId, V> {
    final Map<ObjectId, V>[] level0 = new Map[256];
    private Set<Map.Entry<ObjectId, V>> entrySet = new AbstractSet<Map.Entry<ObjectId, V>>(){

        @Override
        public final Iterator<Map.Entry<ObjectId, V>> iterator() {
            return new Iterator<Map.Entry<ObjectId, V>>(){
                private int levelIndex;
                private boolean hasNext;
                private Iterator<Map.Entry<ObjectId, V>> levelIterator;
                private Iterator<Map.Entry<ObjectId, V>> lastIterator;
                {
                    this.step();
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public Map.Entry<ObjectId, V> next() {
                    Map.Entry ret = this.levelIterator.next();
                    this.step();
                    return ret;
                }

                @Override
                public void remove() {
                    this.lastIterator.remove();
                }

                private void step() {
                    this.hasNext = false;
                    this.lastIterator = this.levelIterator;
                    while (!(this.levelIterator != null && (this.hasNext = this.levelIterator.hasNext()) || this.levelIndex >= ObjectIdMap.this.level0.length)) {
                        this.levelIterator = ObjectIdMap.this.level0[this.levelIndex++].entrySet().iterator();
                    }
                }
            };
        }

        @Override
        public int size() {
            int ret = 0;
            for (int i = 0; i < 256; ++i) {
                ret += ObjectIdMap.this.level0[i].size();
            }
            return ret;
        }
    };

    public ObjectIdMap() {
        this(new TreeMap());
    }

    public ObjectIdMap(Map sample) {
        try {
            Method m = sample.getClass().getMethod("clone", null);
            for (int i = 0; i < 256; ++i) {
                this.level0[i] = (Map)m.invoke((Object)sample, (Object[])null);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < 256; ++i) {
            this.level0[i].clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.submap((ObjectId)key).containsKey(key);
    }

    private final Map<ObjectId, V> submap(ObjectId key) {
        return this.level0[key.getFirstByte()];
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < 256; ++i) {
            if (!this.level0[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<ObjectId, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        return this.submap((ObjectId)key).get(key);
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < 256; ++i) {
            if (this.level0[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public V put(ObjectId key, V value) {
        return this.submap(key).put(key, value);
    }

    @Override
    public void putAll(Map<? extends ObjectId, ? extends V> arg0) {
        for (ObjectId objectId : arg0.keySet()) {
            V v = arg0.get(objectId);
            this.put(objectId, v);
        }
    }

    @Override
    public V remove(Object key) {
        return this.submap((ObjectId)key).remove(key);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }
}

