/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdSubclassMap<V extends ObjectId> {
    private int size;
    private V[] obj_hash = this.createArray(32);

    public void clear() {
        this.size = 0;
        this.obj_hash = this.createArray(32);
    }

    public V get(AnyObjectId toFind) {
        V obj;
        int i = this.index(toFind);
        while ((obj = this.obj_hash[i]) != null) {
            if (AnyObjectId.equals(obj, toFind)) {
                return obj;
            }
            if (++i != this.obj_hash.length) continue;
            i = 0;
        }
        return null;
    }

    public <Q extends V> void add(Q newValue) {
        if (this.obj_hash.length - 1 <= this.size * 2) {
            this.grow();
        }
        this.insert(newValue);
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    private final int index(AnyObjectId id) {
        return (id.w1 >>> 1) % this.obj_hash.length;
    }

    private void insert(V newValue) {
        int j = this.index((AnyObjectId)newValue);
        while (this.obj_hash[j] != null) {
            if (++j < this.obj_hash.length) continue;
            j = 0;
        }
        this.obj_hash[j] = newValue;
    }

    private void grow() {
        V[] old_hash = this.obj_hash;
        int old_hash_size = this.obj_hash.length;
        this.obj_hash = this.createArray(2 * old_hash_size);
        for (int i = 0; i < old_hash_size; ++i) {
            V obj = old_hash[i];
            if (obj == null) continue;
            this.insert(obj);
        }
    }

    private final V[] createArray(int sz) {
        return new ObjectId[sz];
    }
}

