/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.DeltaOfsPackedObjectLoader;
import org.spearce.jgit.lib.DeltaRefPackedObjectLoader;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackIndex;
import org.spearce.jgit.lib.PackReverseIndex;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.UnpackedObjectCache;
import org.spearce.jgit.lib.WholePackedObjectLoader;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.lib.WindowedFile;
import org.spearce.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackFile
implements Iterable<PackIndex.MutableEntry> {
    private final WindowedFile pack;
    private final PackIndex idx;
    private PackReverseIndex reverseIdx;

    public PackFile(Repository parentRepo, File idxFile, File packFile) throws IOException {
        this.pack = new WindowedFile(packFile){

            protected void onOpen() throws IOException {
                PackFile.this.readPackHeader();
            }
        };
        this.idx = PackIndex.open(idxFile);
    }

    final PackedObjectLoader resolveBase(WindowCursor curs, long ofs) throws IOException {
        return this.reader(curs, ofs);
    }

    public File getPackFile() {
        return this.pack.getFile();
    }

    public boolean hasObject(AnyObjectId id) {
        return this.idx.hasObject(id);
    }

    public PackedObjectLoader get(WindowCursor curs, AnyObjectId id) throws IOException {
        long offset = this.idx.findOffset(id);
        return 0L < offset ? this.reader(curs, offset) : null;
    }

    public void close() {
        UnpackedObjectCache.purge(this.pack);
        this.pack.close();
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        return this.idx.iterator();
    }

    long getObjectCount() {
        return this.idx.getObjectCount();
    }

    ObjectId findObjectForOffset(long offset) {
        return this.getReverseIdx().findObject(offset);
    }

    final UnpackedObjectCache.Entry readCache(long position) {
        return UnpackedObjectCache.get(this.pack, position);
    }

    final void saveCache(long position, byte[] data, int type) {
        UnpackedObjectCache.store(this.pack, position, data, type);
    }

    final byte[] decompress(long position, int totalSize, WindowCursor curs) throws DataFormatException, IOException {
        byte[] dstbuf = new byte[totalSize];
        this.pack.readCompressed(position, dstbuf, curs);
        return dstbuf;
    }

    final void copyRawData(PackedObjectLoader loader, OutputStream out, byte[] buf) throws IOException {
        long objectOffset = loader.objectOffset;
        long dataOffset = loader.dataOffset;
        int cnt = (int)(this.findEndOffset(objectOffset) - dataOffset);
        WindowCursor curs = loader.curs;
        if (this.idx.hasCRC32Support()) {
            int toRead;
            CRC32 crc = new CRC32();
            for (int headerCnt = (int)(dataOffset - objectOffset); headerCnt > 0; headerCnt -= toRead) {
                toRead = Math.min(headerCnt, buf.length);
                int read = this.pack.read(objectOffset, buf, 0, toRead, curs);
                if (read != toRead) {
                    throw new EOFException();
                }
                crc.update(buf, 0, read);
            }
            CheckedOutputStream crcOut = new CheckedOutputStream(out, crc);
            this.pack.copyToStream(dataOffset, buf, cnt, crcOut, curs);
            long computed = crc.getValue();
            ObjectId id = this.findObjectForOffset(objectOffset);
            long expected = this.idx.findCRC32(id);
            if (computed != expected) {
                throw new CorruptObjectException("Object at " + dataOffset + " in " + this.getPackFile() + " has bad zlib stream");
            }
        } else {
            try {
                this.pack.verifyCompressed(dataOffset, curs);
            }
            catch (DataFormatException dfe) {
                CorruptObjectException coe = new CorruptObjectException("Object at " + dataOffset + " in " + this.getPackFile() + " has bad zlib stream");
                coe.initCause(dfe);
                throw coe;
            }
            this.pack.copyToStream(dataOffset, buf, cnt, out, curs);
        }
    }

    boolean supportsFastCopyRawData() {
        return this.idx.hasCRC32Support();
    }

    private void readPackHeader() throws IOException {
        WindowCursor curs = new WindowCursor();
        long position = 0L;
        byte[] sig = new byte[Constants.PACK_SIGNATURE.length];
        byte[] intbuf = new byte[4];
        if (this.pack.read(position, sig, curs) != Constants.PACK_SIGNATURE.length) {
            throw new IOException("Not a PACK file.");
        }
        for (int k = 0; k < Constants.PACK_SIGNATURE.length; ++k) {
            if (sig[k] == Constants.PACK_SIGNATURE[k]) continue;
            throw new IOException("Not a PACK file.");
        }
        this.pack.readFully(position += (long)Constants.PACK_SIGNATURE.length, intbuf, curs);
        long vers = NB.decodeUInt32(intbuf, 0);
        if (vers != 2L && vers != 3L) {
            throw new IOException("Unsupported pack version " + vers + ".");
        }
        this.pack.readFully(position += 4L, intbuf, curs);
        long objectCnt = NB.decodeUInt32(intbuf, 0);
        if (this.idx.getObjectCount() != objectCnt) {
            throw new IOException("Pack index object count mismatch; expected " + objectCnt + " found " + this.idx.getObjectCount() + ": " + this.pack.getName());
        }
    }

    private PackedObjectLoader reader(WindowCursor curs, long objOffset) throws IOException {
        long pos = objOffset;
        int p = 0;
        byte[] ib = curs.tempId;
        this.pack.readFully(pos, ib, curs);
        int c = ib[p++] & 0xFF;
        int typeCode = c >> 4 & 7;
        long dataSize = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            dataSize += (long)((c & 0x7F) << shift);
            shift += 7;
        }
        pos += (long)p;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new WholePackedObjectLoader(curs, this, pos, objOffset, typeCode, (int)dataSize);
            }
            case 6: {
                this.pack.readFully(pos, ib, curs);
                p = 0;
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                return new DeltaOfsPackedObjectLoader(curs, this, pos + (long)p, objOffset, (int)dataSize, objOffset - ofs);
            }
            case 7: {
                this.pack.readFully(pos, ib, curs);
                return new DeltaRefPackedObjectLoader(curs, this, pos + (long)ib.length, objOffset, (int)dataSize, ObjectId.fromRaw(ib));
            }
        }
        throw new IOException("Unknown object type " + typeCode + ".");
    }

    private long findEndOffset(long startOffset) throws CorruptObjectException {
        long maxOffset = this.pack.length() - 20L;
        return this.getReverseIdx().findNextOffset(startOffset, maxOffset);
    }

    private synchronized PackReverseIndex getReverseIdx() {
        if (this.reverseIdx == null) {
            this.reverseIdx = new PackReverseIndex(this.idx);
        }
        return this.reverseIdx;
    }
}

