/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.util.Arrays;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackIndex;

class PackReverseIndex {
    private final PackIndex index;
    private final int[] offsets32;
    private final long[] offsets64;
    private final int[] nth32;
    private final int[] nth64;

    PackReverseIndex(PackIndex packIndex) {
        this.index = packIndex;
        long cnt = this.index.getObjectCount();
        long n64 = this.index.getOffset64Count();
        long n32 = cnt - n64;
        if (n32 > Integer.MAX_VALUE || n64 > Integer.MAX_VALUE || cnt > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Huge indexes are not supported by jgit, yet");
        }
        this.offsets32 = new int[(int)n32];
        this.offsets64 = new long[(int)n64];
        this.nth32 = new int[this.offsets32.length];
        this.nth64 = new int[this.offsets64.length];
        int i32 = 0;
        int i64 = 0;
        for (PackIndex.MutableEntry me : this.index) {
            long o = me.getOffset();
            if (o < Integer.MAX_VALUE) {
                this.offsets32[i32++] = (int)o;
                continue;
            }
            this.offsets64[i64++] = o;
        }
        Arrays.sort(this.offsets32);
        Arrays.sort(this.offsets64);
        int nth = 0;
        for (PackIndex.MutableEntry me : this.index) {
            long o = me.getOffset();
            if (o < Integer.MAX_VALUE) {
                this.nth32[Arrays.binarySearch((int[])this.offsets32, (int)((int)o))] = nth++;
                continue;
            }
            this.nth64[Arrays.binarySearch((long[])this.offsets64, (long)o)] = nth++;
        }
    }

    ObjectId findObject(long offset) {
        if (offset <= Integer.MAX_VALUE) {
            int i32 = Arrays.binarySearch(this.offsets32, (int)offset);
            if (i32 < 0) {
                return null;
            }
            return this.index.getObjectId(this.nth32[i32]);
        }
        int i64 = Arrays.binarySearch(this.offsets64, offset);
        if (i64 < 0) {
            return null;
        }
        return this.index.getObjectId(this.nth64[i64]);
    }

    long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
        if (offset <= Integer.MAX_VALUE) {
            int i32 = Arrays.binarySearch(this.offsets32, (int)offset);
            if (i32 < 0) {
                throw new CorruptObjectException("Can't find object in (reverse) pack index for the specified offset " + offset);
            }
            if (i32 + 1 == this.offsets32.length) {
                if (this.offsets64.length > 0) {
                    return this.offsets64[0];
                }
                return maxOffset;
            }
            return this.offsets32[i32 + 1];
        }
        int i64 = Arrays.binarySearch(this.offsets64, offset);
        if (i64 < 0) {
            throw new CorruptObjectException("Can't find object in (reverse) pack index for the specified offset " + offset);
        }
        if (i64 + 1 == this.offsets64.length) {
            return maxOffset;
        }
        return this.offsets64[i64 + 1];
    }
}

