/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectIdSubclassMap;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PackIndexWriter;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.ProgressMonitor;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.WholePackedObjectLoader;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.revwalk.ObjectWalk;
import org.spearce.jgit.revwalk.RevFlag;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevSort;
import org.spearce.jgit.transport.PackedObjectInfo;
import org.spearce.jgit.util.CountingOutputStream;
import org.spearce.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackWriter {
    public static final String COUNTING_OBJECTS_PROGRESS = "Counting objects";
    public static final String SEARCHING_REUSE_PROGRESS = "Compressing objects";
    public static final String WRITING_OBJECTS_PROGRESS = "Writing objects";
    public static final boolean DEFAULT_REUSE_DELTAS = true;
    public static final boolean DEFAULT_REUSE_OBJECTS = true;
    public static final boolean DEFAULT_DELTA_BASE_AS_OFFSET = false;
    public static final int DEFAULT_MAX_DELTA_DEPTH = 50;
    private static final int PACK_VERSION_GENERATED = 2;
    private final List<ObjectToPack>[] objectsLists = new List[5];
    private final ObjectIdSubclassMap<ObjectToPack> objectsMap;
    private final ObjectIdSubclassMap<ObjectId> edgeObjects;
    private final Repository db;
    private DigestOutputStream out;
    private CountingOutputStream countingOut;
    private final Deflater deflater;
    private ProgressMonitor initMonitor;
    private ProgressMonitor writeMonitor;
    private final byte[] buf;
    private final WindowCursor windowCursor;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean reuseDeltas;
    private boolean reuseObjects;
    private boolean deltaBaseAsOffset;
    private int maxDeltaDepth;
    private int outputVersion;
    private boolean thin;

    public PackWriter(Repository repo, ProgressMonitor monitor) {
        this(repo, monitor, monitor);
    }

    public PackWriter(Repository repo, ProgressMonitor imonitor, ProgressMonitor wmonitor) {
        this.objectsLists[0] = Collections.emptyList();
        this.objectsLists[1] = new ArrayList<ObjectToPack>();
        this.objectsLists[2] = new ArrayList<ObjectToPack>();
        this.objectsLists[3] = new ArrayList<ObjectToPack>();
        this.objectsLists[4] = new ArrayList<ObjectToPack>();
        this.objectsMap = new ObjectIdSubclassMap();
        this.edgeObjects = new ObjectIdSubclassMap();
        this.buf = new byte[16384];
        this.windowCursor = new WindowCursor();
        this.reuseDeltas = true;
        this.reuseObjects = true;
        this.deltaBaseAsOffset = false;
        this.maxDeltaDepth = 50;
        this.db = repo;
        this.initMonitor = imonitor;
        this.writeMonitor = wmonitor;
        this.deflater = new Deflater(this.db.getConfig().getCore().getCompression());
    }

    public boolean isReuseDeltas() {
        return this.reuseDeltas;
    }

    public void setReuseDeltas(boolean reuseDeltas) {
        this.reuseDeltas = reuseDeltas;
    }

    public boolean isReuseObjects() {
        return this.reuseObjects;
    }

    public void setReuseObjects(boolean reuseObjects) {
        this.reuseObjects = reuseObjects;
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public int getMaxDeltaDepth() {
        return this.maxDeltaDepth;
    }

    public void setMaxDeltaDepth(int maxDeltaDepth) {
        this.maxDeltaDepth = maxDeltaDepth;
    }

    public void setIndexVersion(int version) {
        this.outputVersion = version;
    }

    public int getObjectsNumber() {
        return this.objectsMap.size();
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects, boolean thin, boolean ignoreMissingUninteresting) throws IOException {
        this.thin = thin;
        ObjectWalk walker = this.setUpWalker(interestingObjects, uninterestingObjects, ignoreMissingUninteresting);
        this.findObjectsToPack(walker);
    }

    public boolean willInclude(AnyObjectId id) {
        return this.objectsMap.get(id) != null;
    }

    public ObjectId computeName() {
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(this.buf, 0);
            md.update(this.buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        List<ObjectToPack> list = this.sortByName();
        PackIndexWriter iw = this.outputVersion <= 0 ? PackIndexWriter.createOldestPossible(indexStream, list) : PackIndexWriter.createVersion(indexStream, this.outputVersion);
        iw.write(list, this.packcsum);
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            this.sortedByName = new ArrayList<ObjectToPack>(this.objectsMap.size());
            for (List<ObjectToPack> list : this.objectsLists) {
                for (ObjectToPack otp : list) {
                    this.sortedByName.add(otp);
                }
            }
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    public void writePack(OutputStream packStream) throws IOException {
        if (this.reuseDeltas || this.reuseObjects) {
            this.searchForReuse();
        }
        if (!(packStream instanceof BufferedOutputStream)) {
            packStream = new BufferedOutputStream(packStream);
        }
        this.countingOut = new CountingOutputStream(packStream);
        this.out = new DigestOutputStream(this.countingOut, Constants.newMessageDigest());
        this.writeMonitor.beginTask(WRITING_OBJECTS_PROGRESS, this.getObjectsNumber());
        this.writeHeader();
        this.writeObjects();
        this.writeChecksum();
        this.out.flush();
        this.windowCursor.release();
        this.writeMonitor.endTask();
    }

    private void searchForReuse() throws IOException {
        this.initMonitor.beginTask(SEARCHING_REUSE_PROGRESS, this.getObjectsNumber());
        ArrayList<PackedObjectLoader> reuseLoaders = new ArrayList<PackedObjectLoader>();
        for (List<ObjectToPack> list : this.objectsLists) {
            for (ObjectToPack otp : list) {
                if (this.initMonitor.isCancelled()) {
                    throw new IOException("Packing cancelled during objects writing");
                }
                reuseLoaders.clear();
                this.db.openObjectInAllPacks(otp, reuseLoaders, this.windowCursor);
                if (this.reuseDeltas) {
                    this.selectDeltaReuseForObject(otp, reuseLoaders);
                }
                if (this.reuseObjects && !otp.hasReuseLoader()) {
                    this.selectObjectReuseForObject(otp, reuseLoaders);
                }
                this.initMonitor.update(1);
            }
        }
        this.initMonitor.endTask();
    }

    private void selectDeltaReuseForObject(ObjectToPack otp, Collection<PackedObjectLoader> loaders) throws IOException {
        PackedObjectLoader bestLoader = null;
        ObjectId bestBase = null;
        for (PackedObjectLoader loader : loaders) {
            ObjectToPack otpBase;
            ObjectId idBase = loader.getDeltaBase();
            if (idBase == null || (otpBase = this.objectsMap.get(idBase)) == null && (!this.thin || this.edgeObjects.get(idBase) == null) || !PackWriter.isBetterDeltaReuseLoader(bestLoader, loader)) continue;
            bestLoader = loader;
            bestBase = otpBase != null ? otpBase : idBase;
        }
        if (bestLoader != null) {
            otp.setReuseLoader(bestLoader);
            otp.setDeltaBase(bestBase);
        }
    }

    private static boolean isBetterDeltaReuseLoader(PackedObjectLoader currentLoader, PackedObjectLoader loader) throws IOException {
        if (currentLoader == null) {
            return true;
        }
        if (loader.getRawSize() < currentLoader.getRawSize()) {
            return true;
        }
        return loader.getRawSize() == currentLoader.getRawSize() && loader.supportsFastCopyRawData() && !currentLoader.supportsFastCopyRawData();
    }

    private void selectObjectReuseForObject(ObjectToPack otp, Collection<PackedObjectLoader> loaders) {
        for (PackedObjectLoader loader : loaders) {
            if (!(loader instanceof WholePackedObjectLoader)) continue;
            otp.setReuseLoader(loader);
            return;
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(Constants.PACK_SIGNATURE);
        NB.encodeInt32(this.buf, 0, 2);
        this.out.write(this.buf, 0, 4);
        NB.encodeInt32(this.buf, 0, this.getObjectsNumber());
        this.out.write(this.buf, 0, 4);
    }

    private void writeObjects() throws IOException {
        for (List<ObjectToPack> list : this.objectsLists) {
            for (ObjectToPack otp : list) {
                if (this.writeMonitor.isCancelled()) {
                    throw new IOException("Packing cancelled during objects writing");
                }
                if (otp.isWritten()) continue;
                this.writeObject(otp);
            }
        }
    }

    private void writeObject(ObjectToPack otp) throws IOException {
        otp.markWantWrite();
        if (otp.isDeltaRepresentation()) {
            ObjectToPack deltaBase = otp.getDeltaBase();
            assert (deltaBase != null || this.thin);
            if (deltaBase != null && !deltaBase.isWritten()) {
                if (deltaBase.wantWrite()) {
                    otp.clearDeltaBase();
                    otp.disposeLoader();
                } else {
                    this.writeObject(deltaBase);
                }
            }
        }
        assert (!otp.isWritten());
        otp.setOffset(this.countingOut.getCount());
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObject(otp);
        } else {
            this.writeWholeObject(otp);
        }
        this.writeMonitor.update(1);
    }

    private void writeWholeObject(ObjectToPack otp) throws IOException {
        if (otp.hasReuseLoader()) {
            PackedObjectLoader loader = otp.getReuseLoader();
            this.writeObjectHeader(otp.getType(), loader.getSize());
            loader.copyRawData(this.out, this.buf);
            otp.disposeLoader();
        } else {
            ObjectLoader loader = this.db.openObject(this.windowCursor, otp);
            byte[] data = loader.getCachedBytes();
            DeflaterOutputStream deflaterOut = new DeflaterOutputStream((OutputStream)this.out, this.deflater);
            this.writeObjectHeader(otp.getType(), data.length);
            deflaterOut.write(data);
            deflaterOut.finish();
            this.deflater.reset();
        }
    }

    private void writeDeltaObject(ObjectToPack otp) throws IOException {
        PackedObjectLoader loader = otp.getReuseLoader();
        if (this.deltaBaseAsOffset && otp.getDeltaBase() != null) {
            this.writeObjectHeader(6, loader.getRawSize());
            ObjectToPack deltaBase = otp.getDeltaBase();
            long offsetDiff = otp.getOffset() - deltaBase.getOffset();
            int pos = this.buf.length - 1;
            this.buf[pos] = (byte)(offsetDiff & 0x7FL);
            while ((offsetDiff >>= 7) > 0L) {
                this.buf[--pos] = (byte)(0x80L | --offsetDiff & 0x7FL);
            }
            this.out.write(this.buf, pos, this.buf.length - pos);
        } else {
            this.writeObjectHeader(7, loader.getRawSize());
            otp.getDeltaBaseId().copyRawTo(this.buf, 0);
            this.out.write(this.buf, 0, 20);
        }
        loader.copyRawData(this.out, this.buf);
        otp.disposeLoader();
    }

    private void writeObjectHeader(int objectType, long dataLength) throws IOException {
        long nextLength = dataLength >>> 4;
        int size = 0;
        this.buf[size++] = (byte)((long)((nextLength > 0L ? 128 : 0) | objectType << 4) | dataLength & 0xFL);
        dataLength = nextLength;
        while (dataLength > 0L) {
            this.buf[size++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | dataLength & 0x7FL);
            dataLength = nextLength;
        }
        this.out.write(this.buf, 0, size);
    }

    private void writeChecksum() throws IOException {
        this.out.on(false);
        this.packcsum = this.out.getMessageDigest().digest();
        this.out.write(this.packcsum);
    }

    private ObjectWalk setUpWalker(Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects, boolean ignoreMissingUninteresting) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        RevObject o;
        ObjectWalk walker = new ObjectWalk(this.db);
        walker.sort(RevSort.TOPO, true);
        walker.sort(RevSort.COMMIT_TIME_DESC, true);
        if (this.thin) {
            walker.sort(RevSort.BOUNDARY);
        }
        for (ObjectId objectId : interestingObjects) {
            o = walker.parseAny(objectId);
            walker.markStart(o);
        }
        for (ObjectId objectId : uninterestingObjects) {
            try {
                o = walker.parseAny(objectId);
            }
            catch (MissingObjectException x) {
                if (ignoreMissingUninteresting) continue;
                throw x;
            }
            walker.markUninteresting(o);
        }
        return walker;
    }

    private void findObjectsToPack(ObjectWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        this.initMonitor.beginTask(COUNTING_OBJECTS_PROGRESS, 0);
        while ((o = walker.next()) != null) {
            this.addObject(o);
            o.dispose();
            this.initMonitor.update(1);
        }
        while ((o = walker.nextObject()) != null) {
            this.addObject(o);
            o.dispose();
            this.initMonitor.update(1);
        }
        this.initMonitor.endTask();
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        if (object.has(RevFlag.UNINTERESTING)) {
            this.edgeObjects.add(object);
            this.thin = true;
            return;
        }
        ObjectToPack otp = new ObjectToPack(object, object.getType());
        try {
            this.objectsLists[object.getType()].add(otp);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new IncorrectObjectTypeException(object, "COMMIT nor TREE nor BLOB nor TAG");
        }
        catch (UnsupportedOperationException x) {
            throw new IncorrectObjectTypeException(object, "COMMIT nor TREE nor BLOB nor TAG");
        }
        this.objectsMap.add(otp);
    }

    static class ObjectToPack
    extends PackedObjectInfo {
        private ObjectId deltaBase;
        private PackedObjectLoader reuseLoader;
        private int flags;

        ObjectToPack(AnyObjectId src, int type) {
            super(src);
            this.flags |= type << 1;
        }

        ObjectId getDeltaBaseId() {
            return this.deltaBase;
        }

        ObjectToPack getDeltaBase() {
            if (this.deltaBase instanceof ObjectToPack) {
                return (ObjectToPack)this.deltaBase;
            }
            return null;
        }

        void setDeltaBase(ObjectId deltaBase) {
            this.deltaBase = deltaBase;
        }

        void clearDeltaBase() {
            this.deltaBase = null;
        }

        boolean isDeltaRepresentation() {
            return this.deltaBase != null;
        }

        boolean isWritten() {
            return this.offset != 0L;
        }

        PackedObjectLoader getReuseLoader() {
            return this.reuseLoader;
        }

        boolean hasReuseLoader() {
            return this.reuseLoader != null;
        }

        void setReuseLoader(PackedObjectLoader reuseLoader) {
            this.reuseLoader = reuseLoader;
        }

        void disposeLoader() {
            this.reuseLoader = null;
        }

        int getType() {
            return this.flags >> 1 & 7;
        }

        int getDeltaDepth() {
            return this.flags >>> 4;
        }

        void updateDeltaDepth() {
            int d = this.deltaBase instanceof ObjectToPack ? ((ObjectToPack)this.deltaBase).getDeltaDepth() + 1 : (this.deltaBase != null ? 1 : 0);
            this.flags = d << 4 | this.flags & 0x15;
        }

        boolean wantWrite() {
            return (this.flags & 1) == 1;
        }

        void markWantWrite() {
            this.flags |= 1;
        }
    }
}

