/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PackFile;
import org.spearce.jgit.lib.WindowCursor;

abstract class PackedObjectLoader
extends ObjectLoader {
    protected final PackFile pack;
    protected final WindowCursor curs;
    protected final long dataOffset;
    protected final long objectOffset;
    protected int objectType;
    protected int objectSize;

    PackedObjectLoader(WindowCursor c, PackFile pr, long dataOffset, long objectOffset) {
        this.curs = c;
        this.pack = pr;
        this.dataOffset = dataOffset;
        this.objectOffset = objectOffset;
    }

    public int getType() throws IOException {
        return this.objectType;
    }

    public long getSize() throws IOException {
        return this.objectSize;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public void copyRawData(OutputStream out, byte[] buf) throws IOException {
        this.pack.copyRawData(this, out, buf);
    }

    public boolean supportsFastCopyRawData() {
        return this.pack.supportsFastCopyRawData();
    }

    public abstract ObjectId getDeltaBase() throws IOException;
}

