/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import org.spearce.jgit.lib.ObjectId;

public class Ref {
    private final Storage storage;
    private final String name;
    private ObjectId objectId;
    private ObjectId peeledObjectId;
    private final String origName;
    private final boolean peeled;

    public Ref(Storage st, String origName, String refName, ObjectId id) {
        this(st, origName, refName, id, null, false);
    }

    public Ref(Storage st, String refName, ObjectId id) {
        this(st, refName, refName, id, null, false);
    }

    public Ref(Storage st, String origName, String refName, ObjectId id, ObjectId peel, boolean peeled) {
        this.storage = st;
        this.origName = origName;
        this.name = refName;
        this.objectId = id;
        this.peeledObjectId = peel;
        this.peeled = peeled;
    }

    public Ref(Storage st, String refName, ObjectId id, ObjectId peel, boolean peeled) {
        this(st, refName, refName, id, peel, peeled);
    }

    public String getName() {
        return this.name;
    }

    public String getOrigName() {
        return this.origName;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public ObjectId getPeeledObjectId() {
        if (!this.peeled) {
            return null;
        }
        return this.peeledObjectId;
    }

    public boolean isPeeled() {
        return this.peeled;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public String toString() {
        String o = "";
        if (!this.origName.equals(this.name)) {
            o = "(" + this.origName + ")";
        }
        return "Ref[" + o + this.name + "=" + ObjectId.toString(this.getObjectId()) + "]";
    }

    void setPeeledObjectId(ObjectId id) {
        this.peeledObjectId = id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Storage {
        NEW(true, false),
        LOOSE(true, false),
        PACKED(false, true),
        LOOSE_PACKED(true, true),
        NETWORK(false, false);

        private final boolean loose;
        private final boolean packed;

        private Storage(boolean l, boolean p) {
            this.loose = l;
            this.packed = p;
        }

        public boolean isLoose() {
            return this.loose;
        }

        public boolean isPacked() {
            return this.packed;
        }
    }
}

