/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.spearce.jgit.errors.ObjectWritingException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.LockFile;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefUpdate;
import org.spearce.jgit.lib.RefWriter;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.util.FS;
import org.spearce.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefDatabase {
    private static final String REFS_SLASH = "refs/";
    private static final String[] refSearchPaths = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    private final Repository db;
    private final File gitDir;
    private final File refsDir;
    private Map<String, Ref> looseRefs;
    private Map<String, Long> looseRefsMTime;
    private Map<String, String> looseSymRefs;
    private final File packedRefsFile;
    private Map<String, Ref> packedRefs;
    private long packedRefsLastModified;
    private long packedRefsLength;
    int lastRefModification;
    int lastNotifiedRefModification;
    private int refModificationCounter;

    RefDatabase(Repository r) {
        this.db = r;
        this.gitDir = this.db.getDirectory();
        this.refsDir = FS.resolve(this.gitDir, "refs");
        this.packedRefsFile = FS.resolve(this.gitDir, "packed-refs");
        this.clearCache();
    }

    synchronized void clearCache() {
        this.looseRefs = new HashMap<String, Ref>();
        this.looseRefsMTime = new HashMap<String, Long>();
        this.packedRefs = new HashMap<String, Ref>();
        this.looseSymRefs = new HashMap<String, String>();
        this.packedRefsLastModified = 0L;
        this.packedRefsLength = 0L;
    }

    Repository getRepository() {
        return this.db;
    }

    void create() {
        this.refsDir.mkdir();
        new File(this.refsDir, "heads").mkdir();
        new File(this.refsDir, "tags").mkdir();
    }

    ObjectId idOf(String name) throws IOException {
        this.refreshPackedRefs();
        Ref r = this.readRefBasic(name, 0);
        return r != null ? r.getObjectId() : null;
    }

    RefUpdate newUpdate(String name) throws IOException {
        this.refreshPackedRefs();
        Ref r = this.readRefBasic(name, 0);
        if (r == null) {
            r = new Ref(Ref.Storage.NEW, name, null);
        }
        return new RefUpdate(this, r, this.fileForRef(r.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stored(String origName, String name, ObjectId id, long time) {
        RefDatabase refDatabase = this;
        synchronized (refDatabase) {
            this.looseRefs.put(name, new Ref(Ref.Storage.LOOSE, origName, name, id));
            this.looseRefsMTime.put(name, time);
            this.setModified();
        }
        this.db.fireRefsMaybeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void link(String name, String target) throws IOException {
        byte[] content = Constants.encode("ref: " + target + "\n");
        this.lockAndWriteFile(this.fileForRef(name), content);
        RefDatabase refDatabase = this;
        synchronized (refDatabase) {
            this.setModified();
        }
        this.db.fireRefsMaybeChanged();
    }

    private void setModified() {
        this.lastRefModification = this.refModificationCounter++;
    }

    Ref readRef(String partialName) throws IOException {
        this.refreshPackedRefs();
        for (int k = 0; k < refSearchPaths.length; ++k) {
            Ref r = this.readRefBasic(refSearchPaths[k] + partialName, 0);
            if (r == null || r.getObjectId() == null) continue;
            return r;
        }
        return null;
    }

    Map<String, Ref> getAllRefs() {
        return this.readRefs();
    }

    Map<String, Ref> getTags() {
        HashMap<String, Ref> tags = new HashMap<String, Ref>();
        for (Ref r : this.readRefs().values()) {
            if (!r.getName().startsWith("refs/tags/")) continue;
            tags.put(r.getName().substring("refs/tags/".length()), r);
        }
        return tags;
    }

    private Map<String, Ref> readRefs() {
        HashMap<String, Ref> avail = new HashMap<String, Ref>();
        this.readPackedRefs(avail);
        this.readLooseRefs(avail, REFS_SLASH, this.refsDir);
        try {
            Ref r = this.readRefBasic("HEAD", 0);
            if (r != null && r.getObjectId() != null) {
                avail.put("HEAD", r);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.db.fireRefsMaybeChanged();
        return avail;
    }

    private synchronized void readPackedRefs(Map<String, Ref> avail) {
        this.refreshPackedRefs();
        avail.putAll(this.packedRefs);
    }

    private void readLooseRefs(Map<String, Ref> avail, String prefix, File dir) {
        File[] entries = dir.listFiles();
        if (entries == null) {
            return;
        }
        for (File ent : entries) {
            String entName = ent.getName();
            if (".".equals(entName) || "..".equals(entName)) continue;
            this.readOneLooseRef(avail, prefix + entName, prefix + entName, ent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readOneLooseRef(Map<String, Ref> avail, String origName, String refName, File ent) {
        Ref ref = this.looseRefs.get(refName);
        if (ref != null) {
            Long cachedlastModified = this.looseRefsMTime.get(refName);
            if (cachedlastModified != null && cachedlastModified.longValue() == ent.lastModified()) {
                avail.put(ref.getName(), ref);
                return;
            }
            this.looseRefs.remove(refName);
            this.looseRefsMTime.remove(refName);
        }
        if (ent.isDirectory()) {
            this.readLooseRefs(avail, refName + "/", ent);
            return;
        }
        try {
            FileInputStream in = new FileInputStream(ent);
            try {
                ObjectId id;
                try {
                    byte[] str = new byte[40];
                    NB.readFully(in, str, 0, str.length);
                    id = ObjectId.fromString(str, 0);
                }
                catch (EOFException tooShortToBeRef) {
                    in.close();
                    return;
                }
                catch (IllegalArgumentException notRef) {
                    in.close();
                    return;
                }
                ref = new Ref(Ref.Storage.LOOSE, origName, refName, id, null, false);
                this.looseRefs.put(ref.getName(), ref);
                this.looseRefsMTime.put(ref.getName(), ent.lastModified());
                avail.put(ref.getName(), ref);
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException noFile) {
        }
        catch (IOException err) {
            throw new RuntimeException("Cannot read ref " + ent, err);
        }
    }

    Ref peel(Ref ref) {
        if (ref.isPeeled()) {
            return ref;
        }
        ObjectId peeled = null;
        try {
            Object target = this.db.mapObject(ref.getObjectId(), ref.getName());
            while (target instanceof Tag) {
                Tag tag = (Tag)target;
                peeled = tag.getObjId();
                if ("tag".equals(tag.getType())) {
                    target = this.db.mapObject(tag.getObjId(), ref.getName());
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Ref(ref.getStorage(), ref.getName(), ref.getObjectId(), peeled, true);
    }

    private File fileForRef(String name) {
        if (name.startsWith(REFS_SLASH)) {
            return new File(this.refsDir, name.substring(REFS_SLASH.length()));
        }
        return new File(this.gitDir, name);
    }

    private Ref readRefBasic(String name, int depth) throws IOException {
        return this.readRefBasic(name, name, depth);
    }

    private synchronized Ref readRefBasic(String origName, String name, int depth) throws IOException {
        ObjectId id;
        Ref ref = this.looseRefs.get(origName);
        File loose = this.fileForRef(name);
        long mtime = loose.lastModified();
        if (ref != null) {
            Long cachedlastModified = this.looseRefsMTime.get(name);
            if (cachedlastModified != null && cachedlastModified == mtime) {
                return ref;
            }
            this.looseRefs.remove(origName);
            this.looseRefsMTime.remove(origName);
        }
        if (mtime == 0L) {
            ref = this.packedRefs.get(name);
            if (ref != null && !ref.getOrigName().equals(origName)) {
                ref = new Ref(Ref.Storage.LOOSE_PACKED, origName, name, ref.getObjectId());
            }
            return ref;
        }
        String line = null;
        try {
            Long cachedlastModified = this.looseRefsMTime.get(name);
            if (cachedlastModified != null && cachedlastModified == mtime) {
                line = this.looseSymRefs.get(name);
            }
            if (line == null) {
                line = RefDatabase.readLine(loose);
                this.looseRefsMTime.put(name, mtime);
                this.looseSymRefs.put(name, line);
            }
        }
        catch (FileNotFoundException notLoose) {
            return this.packedRefs.get(name);
        }
        if (line == null || line.length() == 0) {
            this.looseRefs.remove(origName);
            this.looseRefsMTime.remove(origName);
            return new Ref(Ref.Storage.LOOSE, origName, name, null);
        }
        if (line.startsWith("ref: ")) {
            if (depth >= 5) {
                throw new IOException("Exceeded maximum ref depth of " + depth + " at " + name + ".  Circular reference?");
            }
            String target = line.substring("ref: ".length());
            Ref r = this.readRefBasic(target, target, depth + 1);
            Long cachedMtime = this.looseRefsMTime.get(name);
            if (cachedMtime != null && cachedMtime != mtime) {
                this.setModified();
            }
            this.looseRefsMTime.put(name, mtime);
            if (r == null) {
                return new Ref(Ref.Storage.LOOSE, origName, target, null);
            }
            if (!origName.equals(r.getName())) {
                r = new Ref(Ref.Storage.LOOSE_PACKED, origName, r.getName(), r.getObjectId(), r.getPeeledObjectId(), true);
            }
            return r;
        }
        this.setModified();
        try {
            id = ObjectId.fromString(line);
        }
        catch (IllegalArgumentException notRef) {
            throw new IOException("Not a ref: " + name + ": " + line);
        }
        ref = new Ref(Ref.Storage.LOOSE, origName, name, id);
        this.looseRefs.put(origName, ref);
        ref = new Ref(Ref.Storage.LOOSE, origName, id);
        this.looseRefs.put(name, ref);
        this.looseRefsMTime.put(name, mtime);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshPackedRefs() {
        long currLen;
        long currTime = this.packedRefsFile.lastModified();
        long l = currLen = currTime == 0L ? 0L : this.packedRefsFile.length();
        if (currTime == this.packedRefsLastModified && currLen == this.packedRefsLength) {
            return;
        }
        if (currTime == 0L) {
            this.packedRefsLastModified = 0L;
            this.packedRefsLength = 0L;
            this.packedRefs = new HashMap<String, Ref>();
            return;
        }
        HashMap<String, Ref> newPackedRefs = new HashMap<String, Ref>();
        try {
            BufferedReader b = RefDatabase.openReader(this.packedRefsFile);
            try {
                String p;
                Ref last = null;
                while ((p = b.readLine()) != null) {
                    if (p.charAt(0) == '#') continue;
                    if (p.charAt(0) == '^') {
                        if (last == null) {
                            throw new IOException("Peeled line before ref.");
                        }
                        ObjectId id = ObjectId.fromString(p.substring(1));
                        last = new Ref(Ref.Storage.PACKED, last.getName(), last.getName(), last.getObjectId(), id, true);
                        newPackedRefs.put(last.getName(), last);
                        continue;
                    }
                    int sp = p.indexOf(32);
                    ObjectId id = ObjectId.fromString(p.substring(0, sp));
                    String name = new String(p.substring(sp + 1));
                    last = new Ref(Ref.Storage.PACKED, name, name, id);
                    newPackedRefs.put(last.getName(), last);
                }
            }
            finally {
                b.close();
            }
            this.packedRefsLastModified = currTime;
            this.packedRefsLength = currLen;
            this.packedRefs = newPackedRefs;
            this.setModified();
        }
        catch (FileNotFoundException noPackedRefs) {
            this.packedRefsLastModified = 0L;
            this.packedRefsLength = 0L;
            this.packedRefs = newPackedRefs;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read packed refs", e);
        }
    }

    private void lockAndWriteFile(File file, byte[] content) throws IOException {
        String name = file.getName();
        LockFile lck = new LockFile(file);
        if (!lck.lock()) {
            throw new ObjectWritingException("Unable to lock " + name);
        }
        try {
            lck.write(content);
        }
        catch (IOException ioe) {
            throw new ObjectWritingException("Unable to write " + name, ioe);
        }
        if (!lck.commit()) {
            throw new ObjectWritingException("Unable to write " + name);
        }
    }

    synchronized void removePackedRef(String name) throws IOException {
        this.packedRefs.remove(name);
        this.writePackedRefs();
    }

    private void writePackedRefs() throws IOException {
        new RefWriter(this.packedRefs.values()){

            protected void writeFile(String name, byte[] content) throws IOException {
                RefDatabase.this.lockAndWriteFile(new File(RefDatabase.this.db.getDirectory(), name), content);
            }
        }.writePackedRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLine(File file) throws FileNotFoundException, IOException {
        BufferedReader br = RefDatabase.openReader(file);
        try {
            String string = br.readLine();
            return string;
        }
        finally {
            br.close();
        }
    }

    private static BufferedReader openReader(File fileLocation) throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileLocation), Constants.CHARSET));
    }
}

