/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.RefUpdate;
import org.spearce.jgit.lib.Repository;

public class RefLogWriter {
    static void append(RefUpdate u, String msg) throws IOException {
        ObjectId oldId = u.getOldObjectId();
        ObjectId newId = u.getNewObjectId();
        Repository db = u.getRepository();
        PersonIdent ident = u.getRefLogIdent();
        RefLogWriter.appendOneRecord(oldId, newId, ident, msg, db, u.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendOneRecord(ObjectId oldId, ObjectId newId, PersonIdent ident, String msg, Repository db, String refName) throws IOException {
        ident = ident == null ? new PersonIdent(db) : new PersonIdent(ident);
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(oldId));
        r.append(' ');
        r.append(ObjectId.toString(newId));
        r.append(' ');
        r.append(ident.toExternalString());
        r.append('\t');
        r.append(msg);
        r.append('\n');
        byte[] rec = Constants.encode(r.toString());
        File logdir = new File(db.getDirectory(), "logs");
        File reflog = new File(logdir, refName);
        File refdir = reflog.getParentFile();
        if (!refdir.exists() && !refdir.mkdirs()) {
            throw new IOException("Cannot create directory " + refdir);
        }
        FileOutputStream out = new FileOutputStream(reflog, true);
        try {
            out.write(rec);
        }
        finally {
            out.close();
        }
    }

    public static void writeReflog(Repository repo, ObjectId oldCommit, ObjectId commit, String message, String refName) throws IOException {
        RefLogWriter.appendOneRecord(oldCommit, commit, null, message, repo, refName);
    }
}

