/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.File;
import java.io.IOException;
import org.spearce.jgit.errors.MissingObjectException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.LockFile;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefDatabase;
import org.spearce.jgit.lib.RefLogWriter;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.revwalk.RevCommit;
import org.spearce.jgit.revwalk.RevObject;
import org.spearce.jgit.revwalk.RevWalk;

public class RefUpdate {
    private final RefDatabase db;
    private final File looseFile;
    private ObjectId newValue;
    private boolean force;
    private PersonIdent refLogIdent;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private ObjectId oldValue;
    private ObjectId expValue;
    private Result result = Result.NOT_ATTEMPTED;
    private final Ref ref;

    RefUpdate(RefDatabase r, Ref ref, File f) {
        this.db = r;
        this.ref = ref;
        this.oldValue = ref.getObjectId();
        this.looseFile = f;
    }

    public Repository getRepository() {
        return this.db.getRepository();
    }

    public String getName() {
        return this.ref.getName();
    }

    public ObjectId getNewObjectId() {
        return this.newValue;
    }

    public void setNewObjectId(AnyObjectId id) {
        this.newValue = id.toObjectId();
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expValue;
    }

    public void setExpectedOldObjectId(AnyObjectId id) {
        this.expValue = id != null ? id.toObjectId() : null;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public void setForceUpdate(boolean b) {
        this.force = b;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public void setRefLogMessage(String msg, boolean appendStatus) {
        this.refLogMessage = msg;
        this.refLogIncludeResult = appendStatus;
    }

    public ObjectId getOldObjectId() {
        return this.oldValue;
    }

    public Result getResult() {
        return this.result;
    }

    private void requireCanDoUpdate() {
        if (this.newValue == null) {
            throw new IllegalStateException("A NewObjectId is required.");
        }
    }

    public Result forceUpdate() throws IOException {
        this.force = true;
        return this.update();
    }

    public Result update() throws IOException {
        return this.update(new RevWalk(this.db.getRepository()));
    }

    public Result update(RevWalk walk) throws IOException {
        this.requireCanDoUpdate();
        try {
            this.result = this.updateImpl(walk, new UpdateStore());
            return this.result;
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    public Result delete() throws IOException {
        return this.delete(new RevWalk(this.db.getRepository()));
    }

    public Result delete(RevWalk walk) throws IOException {
        Ref head;
        if (this.getName().startsWith("refs/heads/") && (head = this.db.readRef("HEAD")) != null && this.getName().equals(head.getName())) {
            return Result.REJECTED_CURRENT_BRANCH;
        }
        try {
            return this.updateImpl(walk, new DeleteStore());
        }
        catch (IOException x) {
            this.result = Result.IO_FAILURE;
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result updateImpl(RevWalk walk, Store store) throws IOException {
        LockFile lock = new LockFile(this.looseFile);
        if (!lock.lock()) {
            return Result.LOCK_FAILURE;
        }
        try {
            RevObject oldObj;
            Result result;
            this.oldValue = this.db.idOf(this.getName());
            if (this.expValue != null) {
                ObjectId o;
                ObjectId objectId = o = this.oldValue != null ? this.oldValue : ObjectId.zeroId();
                if (!this.expValue.equals(o)) {
                    Result result2 = Result.LOCK_FAILURE;
                    return result2;
                }
            }
            if (this.oldValue == null) {
                result = store.store(lock, Result.NEW);
                return result;
            }
            RevObject newObj = RefUpdate.safeParse(walk, this.newValue);
            if (newObj == (oldObj = RefUpdate.safeParse(walk, this.oldValue))) {
                result = store.store(lock, Result.NO_CHANGE);
                return result;
            }
            if (newObj instanceof RevCommit && oldObj instanceof RevCommit && walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) {
                result = store.store(lock, Result.FAST_FORWARD);
                return result;
            }
            if (this.isForceUpdate()) {
                result = store.store(lock, Result.FORCED);
                return result;
            }
            result = Result.REJECTED;
            return result;
        }
        finally {
            lock.unlock();
        }
    }

    private static RevObject safeParse(RevWalk rw, AnyObjectId id) throws IOException {
        try {
            return id != null ? rw.parseAny(id) : null;
        }
        catch (MissingObjectException e) {
            return null;
        }
    }

    private Result updateStore(LockFile lock, Result status) throws IOException {
        if (status == Result.NO_CHANGE) {
            return status;
        }
        lock.setNeedStatInformation(true);
        lock.write(this.newValue);
        String msg = this.getRefLogMessage();
        if (msg != null && this.refLogIncludeResult) {
            if (status == Result.FORCED) {
                msg = msg + ": forced-update";
            } else if (status == Result.FAST_FORWARD) {
                msg = msg + ": fast forward";
            } else if (status == Result.NEW) {
                msg = msg + ": created";
            }
        }
        RefLogWriter.append(this, msg);
        if (!lock.commit()) {
            return Result.LOCK_FAILURE;
        }
        this.db.stored(this.ref.getOrigName(), this.ref.getName(), this.newValue, lock.getCommitLastModified());
        return status;
    }

    private static int count(String s, char c) {
        int count = 0;
        int p = s.indexOf(c);
        while (p >= 0) {
            ++count;
            p = s.indexOf(c, p + 1);
        }
        return count;
    }

    private class DeleteStore
    extends Store {
        private DeleteStore() {
        }

        Result store(LockFile lock, Result status) throws IOException {
            Ref.Storage storage = RefUpdate.this.ref.getStorage();
            if (storage == Ref.Storage.NEW) {
                return status;
            }
            if (storage.isPacked()) {
                RefUpdate.this.db.removePackedRef(RefUpdate.this.ref.getName());
            }
            int levels = RefUpdate.count(RefUpdate.this.ref.getName(), '/') - 2;
            File gitDir = RefUpdate.this.db.getRepository().getDirectory();
            File logDir = new File(gitDir, "logs");
            this.deleteFileAndEmptyDir(new File(logDir, RefUpdate.this.ref.getName()), levels);
            lock.unlock();
            if (storage.isLoose()) {
                this.deleteFileAndEmptyDir(RefUpdate.this.looseFile, levels);
            }
            return status;
        }

        private void deleteFileAndEmptyDir(File file, int depth) throws IOException {
            if (file.exists()) {
                if (!file.delete()) {
                    throw new IOException("File cannot be deleted: " + file);
                }
                this.deleteEmptyDir(file.getParentFile(), depth);
            }
        }

        private void deleteEmptyDir(File dir, int depth) {
            while (depth > 0 && dir != null && dir.delete()) {
                dir = dir.getParentFile();
                --depth;
            }
        }
    }

    private class UpdateStore
    extends Store {
        private UpdateStore() {
        }

        Result store(LockFile lock, Result status) throws IOException {
            return RefUpdate.this.updateStore(lock, status);
        }
    }

    private abstract class Store {
        private Store() {
        }

        abstract Result store(LockFile var1, Result var2) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        NOT_ATTEMPTED,
        LOCK_FAILURE,
        NO_CHANGE,
        NEW,
        FORCED,
        FAST_FORWARD,
        REJECTED,
        REJECTED_CURRENT_BRANCH,
        IO_FAILURE;

    }
}

