/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefWriter {
    private final Collection<Ref> refs;

    public RefWriter(Collection<Ref> refs) {
        this.refs = RefComparator.sort(refs);
    }

    public void writeInfoRefs() throws IOException {
        StringWriter w = new StringWriter();
        char[] tmp = new char[40];
        for (Ref r : this.refs) {
            if ("HEAD".equals(r.getName())) continue;
            r.getObjectId().copyTo(tmp, w);
            w.write(9);
            w.write(r.getName());
            w.write(10);
            if (r.getPeeledObjectId() == null) continue;
            r.getPeeledObjectId().copyTo(tmp, w);
            w.write(9);
            w.write(r.getName());
            w.write("^{}\n");
        }
        this.writeFile("info/refs", Constants.encodeASCII(w.toString()));
    }

    public void writePackedRefs() throws IOException {
        boolean peeled = false;
        for (Ref r : this.refs) {
            if (r.getStorage() != Ref.Storage.PACKED || r.getPeeledObjectId() == null) continue;
            peeled = true;
        }
        StringWriter w = new StringWriter();
        if (peeled) {
            w.write("# pack-refs with:");
            if (peeled) {
                w.write(" peeled");
            }
            w.write(10);
        }
        char[] tmp = new char[40];
        for (Ref r : this.refs) {
            if (r.getStorage() != Ref.Storage.PACKED) continue;
            r.getObjectId().copyTo(tmp, w);
            w.write(32);
            w.write(r.getName());
            w.write(10);
            if (r.getPeeledObjectId() == null) continue;
            w.write(94);
            r.getPeeledObjectId().copyTo(tmp, w);
            w.write(10);
        }
        this.writeFile("packed-refs", Constants.encodeASCII(w.toString()));
    }

    protected abstract void writeFile(String var1, byte[] var2) throws IOException;
}

