/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.spearce.jgit.errors.IncorrectObjectTypeException;
import org.spearce.jgit.errors.RevisionSyntaxException;
import org.spearce.jgit.lib.AnyObjectId;
import org.spearce.jgit.lib.Commit;
import org.spearce.jgit.lib.GitIndex;
import org.spearce.jgit.lib.IndexChangedEvent;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.ObjectLoader;
import org.spearce.jgit.lib.PackFile;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.Ref;
import org.spearce.jgit.lib.RefDatabase;
import org.spearce.jgit.lib.RefUpdate;
import org.spearce.jgit.lib.RefsChangedEvent;
import org.spearce.jgit.lib.RepositoryConfig;
import org.spearce.jgit.lib.RepositoryListener;
import org.spearce.jgit.lib.RepositoryState;
import org.spearce.jgit.lib.Tag;
import org.spearce.jgit.lib.Tree;
import org.spearce.jgit.lib.Treeish;
import org.spearce.jgit.lib.UnpackedObjectLoader;
import org.spearce.jgit.lib.WindowCursor;
import org.spearce.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    private final File gitDir;
    private final RepositoryConfig config;
    private final RefDatabase refs;
    private File[] objectDirectoryList;
    private PackFile[] packFileList;
    private GitIndex index;
    private List<RepositoryListener> listeners = new Vector<RepositoryListener>();
    private static List<RepositoryListener> allListeners = new Vector<RepositoryListener>();

    public Repository(File d) throws IOException {
        this.gitDir = d.getAbsoluteFile();
        try {
            this.objectDirectoryList = Repository.readObjectsDirs(FS.resolve(this.gitDir, "objects"), new ArrayList<File>()).toArray(new File[0]);
        }
        catch (IOException e) {
            IOException ex = new IOException("Cannot find all object dirs for " + this.gitDir);
            ex.initCause(e);
            throw ex;
        }
        this.refs = new RefDatabase(this);
        this.packFileList = new PackFile[0];
        this.config = new RepositoryConfig(this);
        boolean isExisting = this.objectDirectoryList[0].exists();
        if (isExisting) {
            this.getConfig().load();
            String repositoryFormatVersion = this.getConfig().getString("core", null, "repositoryFormatVersion");
            if (!"0".equals(repositoryFormatVersion)) {
                throw new IOException("Unknown repository format \"" + repositoryFormatVersion + "\"; expected \"0\".");
            }
        } else {
            this.getConfig().create();
        }
        if (isExisting) {
            this.scanForPacks();
        }
    }

    private static Collection<File> readObjectsDirs(File objectsDir, Collection<File> ret) throws IOException {
        ret.add(objectsDir);
        File altFile = FS.resolve(objectsDir, "info/alternates");
        if (altFile.exists()) {
            BufferedReader ar = new BufferedReader(new FileReader(altFile));
            try {
                String alt = ar.readLine();
                while (alt != null) {
                    Repository.readObjectsDirs(FS.resolve(objectsDir, alt), ret);
                    alt = ar.readLine();
                }
            }
            catch (Exception e) {
                ar.close();
            }
        }
        return ret;
    }

    public synchronized void create() throws IOException {
        if (this.gitDir.exists()) {
            throw new IllegalStateException("Repository already exists: " + this.gitDir);
        }
        this.gitDir.mkdirs();
        this.refs.create();
        this.objectDirectoryList[0].mkdirs();
        new File(this.objectDirectoryList[0], "pack").mkdir();
        new File(this.objectDirectoryList[0], "info").mkdir();
        new File(this.gitDir, "branches").mkdir();
        new File(this.gitDir, "remotes").mkdir();
        String master = "refs/heads/master";
        this.refs.link("HEAD", "refs/heads/master");
        this.getConfig().create();
        this.getConfig().save();
    }

    private synchronized File[] objectsDirs() {
        return this.objectDirectoryList;
    }

    private synchronized PackFile[] packs() {
        return this.packFileList;
    }

    public File getDirectory() {
        return this.gitDir;
    }

    public File getObjectsDirectory() {
        return this.objectsDirs()[0];
    }

    public RepositoryConfig getConfig() {
        return this.config;
    }

    public File toFile(AnyObjectId objectId) {
        File[] objectsDirs;
        String n = objectId.name();
        String d = n.substring(0, 2);
        String f = n.substring(2);
        for (File objectsDir : objectsDirs = this.objectsDirs()) {
            File ret = new File(new File(objectsDir, d), f);
            if (!ret.exists()) continue;
            return ret;
        }
        return new File(new File(objectsDirs[0], d), f);
    }

    public boolean hasObject(AnyObjectId objectId) {
        PackFile[] packs = this.packs();
        int k = packs.length;
        while (k > 0) {
            if (!packs[--k].hasObject(objectId)) continue;
            return true;
        }
        return this.toFile(objectId).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLoader openObject(AnyObjectId id) throws IOException {
        WindowCursor wc = new WindowCursor();
        try {
            ObjectLoader objectLoader = this.openObject(wc, id);
            return objectLoader;
        }
        finally {
            wc.release();
        }
    }

    public ObjectLoader openObject(WindowCursor curs, AnyObjectId id) throws IOException {
        PackFile[] packs = this.packs();
        int k = packs.length;
        while (k > 0) {
            PackedObjectLoader ol;
            if ((ol = packs[--k].get(curs, id)) == null) continue;
            return ol;
        }
        try {
            return new UnpackedObjectLoader(this, id);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public Collection<PackedObjectLoader> openObjectInAllPacks(AnyObjectId objectId, WindowCursor curs) throws IOException {
        LinkedList<PackedObjectLoader> result = new LinkedList<PackedObjectLoader>();
        this.openObjectInAllPacks(objectId, result, curs);
        return result;
    }

    void openObjectInAllPacks(AnyObjectId objectId, Collection<PackedObjectLoader> resultLoaders, WindowCursor curs) throws IOException {
        for (PackFile pack : this.packs()) {
            PackedObjectLoader loader = pack.get(curs, objectId);
            if (loader == null) continue;
            resultLoaders.add(loader);
        }
    }

    public ObjectLoader openBlob(ObjectId id) throws IOException {
        return this.openObject(id);
    }

    public ObjectLoader openTree(ObjectId id) throws IOException {
        return this.openObject(id);
    }

    public Commit mapCommit(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapCommit(id) : null;
    }

    public Object mapObject(ObjectId id, String refName) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        switch (or.getType()) {
            case 2: {
                return this.makeTree(id, raw);
            }
            case 1: {
                return this.makeCommit(id, raw);
            }
            case 4: {
                return this.makeTag(id, refName, raw);
            }
            case 3: {
                return raw;
            }
        }
        throw new IncorrectObjectTypeException(id, "COMMIT nor TREE nor BLOB nor TAG");
    }

    public Commit mapCommit(ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        if (1 == or.getType()) {
            return new Commit(this, id, raw);
        }
        throw new IncorrectObjectTypeException(id, "commit");
    }

    private Commit makeCommit(ObjectId id, byte[] raw) {
        Commit ret = new Commit(this, id, raw);
        return ret;
    }

    public Tree mapTree(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTree(id) : null;
    }

    public Tree mapTree(ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        switch (or.getType()) {
            case 2: {
                return new Tree(this, id, raw);
            }
            case 1: {
                return this.mapTree(ObjectId.fromString(raw, 5));
            }
        }
        throw new IncorrectObjectTypeException(id, "tree");
    }

    private Tree makeTree(ObjectId id, byte[] raw) throws IOException {
        Tree ret = new Tree(this, id, raw);
        return ret;
    }

    private Tag makeTag(ObjectId id, String refName, byte[] raw) {
        Tag ret = new Tag(this, id, refName, raw);
        return ret;
    }

    public Tag mapTag(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTag(revstr, id) : null;
    }

    public Tag mapTag(String refName, ObjectId id) throws IOException {
        ObjectLoader or = this.openObject(id);
        if (or == null) {
            return null;
        }
        byte[] raw = or.getBytes();
        if (4 == or.getType()) {
            return new Tag(this, id, refName, raw);
        }
        return new Tag(this, id, refName, null);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.refs.newUpdate(ref);
    }

    public ObjectId resolve(String revstr) throws IOException {
        char[] rev = revstr.toCharArray();
        Object ref = null;
        ObjectId refId = null;
        block13: for (int i = 0; i < rev.length; ++i) {
            switch (rev[i]) {
                case '^': {
                    Tag tag;
                    String refstr;
                    if (refId == null && (refId = this.resolveSimple(refstr = new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (i + 1 < rev.length) {
                        switch (rev[i + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int pnum;
                                int j;
                                ref = this.mapObject(refId, null);
                                while (ref instanceof Tag) {
                                    Tag tag2 = (Tag)ref;
                                    refId = tag2.getObjId();
                                    ref = this.mapObject(refId, null);
                                }
                                if (!(ref instanceof Commit)) {
                                    throw new IncorrectObjectTypeException(refId, "commit");
                                }
                                for (j = i + 1; j < rev.length && Character.isDigit(rev[j]); ++j) {
                                }
                                String parentnum = new String(rev, i + 1, j - i - 1);
                                try {
                                    pnum = Integer.parseInt(parentnum);
                                }
                                catch (NumberFormatException e) {
                                    throw new RevisionSyntaxException("Invalid commit parent number", revstr);
                                }
                                if (pnum != 0) {
                                    ObjectId[] parents = ((Commit)ref).getParentIds();
                                    refId = pnum > parents.length ? null : parents[pnum - 1];
                                }
                                i = j - 1;
                                continue block13;
                            }
                            case '{': {
                                int k;
                                String item = null;
                                for (k = i + 2; k < rev.length; ++k) {
                                    if (rev[k] != '}') continue;
                                    item = new String(rev, i + 2, k - i - 2);
                                    break;
                                }
                                i = k;
                                if (item != null) {
                                    Tag t;
                                    if (item.equals("tree")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof Treeish) {
                                            refId = ((Treeish)ref).getTreeId();
                                            continue block13;
                                        }
                                        throw new IncorrectObjectTypeException(refId, "tree");
                                    }
                                    if (item.equals("commit")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof Commit) continue block13;
                                        throw new IncorrectObjectTypeException(refId, "commit");
                                    }
                                    if (item.equals("blob")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        if (ref instanceof byte[]) continue block13;
                                        throw new IncorrectObjectTypeException(refId, "blob");
                                    }
                                    if (item.equals("")) {
                                        ref = this.mapObject(refId, null);
                                        while (ref instanceof Tag) {
                                            t = (Tag)ref;
                                            refId = t.getObjId();
                                            ref = this.mapObject(refId, null);
                                        }
                                        continue block13;
                                    }
                                    throw new RevisionSyntaxException(revstr);
                                }
                                throw new RevisionSyntaxException(revstr);
                            }
                            default: {
                                ref = this.mapObject(refId, null);
                                if (ref instanceof Commit) {
                                    ObjectId[] parents = ((Commit)ref).getParentIds();
                                    if (parents.length == 0) {
                                        refId = null;
                                        continue block13;
                                    }
                                    refId = parents[0];
                                    continue block13;
                                }
                                throw new IncorrectObjectTypeException(refId, "commit");
                            }
                        }
                    }
                    ref = this.mapObject(refId, null);
                    while (ref instanceof Tag) {
                        tag = (Tag)ref;
                        refId = tag.getObjId();
                        ref = this.mapObject(refId, null);
                    }
                    if (ref instanceof Commit) {
                        ObjectId[] parents = ((Commit)ref).getParentIds();
                        if (parents.length == 0) {
                            refId = null;
                            continue block13;
                        }
                        refId = parents[0];
                        continue block13;
                    }
                    throw new IncorrectObjectTypeException(refId, "commit");
                }
                case '~': {
                    int l;
                    Tag tag;
                    String refstr;
                    if (ref == null) {
                        refstr = new String(rev, 0, i);
                        refId = this.resolveSimple(refstr);
                        if (refId == null) {
                            return null;
                        }
                        ref = this.mapObject(refId, null);
                    }
                    while (ref instanceof Tag) {
                        tag = (Tag)ref;
                        refId = tag.getObjId();
                        ref = this.mapObject(refId, null);
                    }
                    if (!(ref instanceof Commit)) {
                        throw new IncorrectObjectTypeException(refId, "commit");
                    }
                    for (l = i + 1; l < rev.length && Character.isDigit(rev[l]); ++l) {
                    }
                    String distnum = new String(rev, i + 1, l - i - 1);
                    try {
                    }
                    catch (NumberFormatException e) {
                        throw new RevisionSyntaxException("Invalid ancestry length", revstr);
                    }
                    for (int dist = Integer.parseInt(distnum); dist > 0; --dist) {
                        ObjectId[] parents = ((Commit)ref).getParentIds();
                        if (parents.length == 0) {
                            refId = null;
                            break;
                        }
                        refId = parents[0];
                        ref = this.mapCommit(refId);
                    }
                    i = l - 1;
                    continue block13;
                }
                case '@': {
                    int m;
                    String time = null;
                    for (m = i + 2; m < rev.length; ++m) {
                        if (rev[m] != '}') continue;
                        time = new String(rev, i + 2, m - i - 2);
                        break;
                    }
                    if (time != null) {
                        throw new RevisionSyntaxException("reflogs not yet supported by revision parser yet", revstr);
                    }
                    i = m - 1;
                    continue block13;
                }
                default: {
                    if (refId == null) continue block13;
                    throw new RevisionSyntaxException(revstr);
                }
            }
        }
        if (refId == null) {
            refId = this.resolveSimple(revstr);
        }
        return refId;
    }

    private ObjectId resolveSimple(String revstr) throws IOException {
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        Ref r = this.refs.readRef(revstr);
        return r != null ? r.getObjectId() : null;
    }

    public void close() {
        this.closePacks();
    }

    synchronized void closePacks() {
        for (int k = this.packFileList.length - 1; k >= 0; --k) {
            this.packFileList[k].close();
        }
        this.packFileList = new PackFile[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openPack(File pack, File idx) throws IOException {
        String p = pack.getName();
        String i = idx.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !p.endsWith(".pack")) {
            throw new IllegalArgumentException("Not a valid pack " + pack);
        }
        if (i.length() != 49 || !i.startsWith("pack-") || !i.endsWith(".idx")) {
            throw new IllegalArgumentException("Not a valid pack " + idx);
        }
        if (!p.substring(0, 45).equals(i.substring(0, 45))) {
            throw new IllegalArgumentException("Pack " + pack + "does not match index " + idx);
        }
        Repository repository = this;
        synchronized (repository) {
            PackFile[] cur = this.packFileList;
            PackFile[] arr = new PackFile[cur.length + 1];
            System.arraycopy(cur, 0, arr, 1, cur.length);
            arr[0] = new PackFile(this, idx, pack);
            this.packFileList = arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForPacks() {
        ArrayList<PackFile> p = new ArrayList<PackFile>();
        p.addAll(Arrays.asList(this.packs()));
        for (File d : this.objectsDirs()) {
            this.scanForPacks(new File(d, "pack"), p);
        }
        PackFile[] arr = new PackFile[p.size()];
        p.toArray(arr);
        Repository repository = this;
        synchronized (repository) {
            this.packFileList = arr;
        }
    }

    private void scanForPacks(File packDir, Collection<PackFile> packList) {
        String[] idxList = packDir.list(new FilenameFilter(){

            public boolean accept(File baseDir, String n) {
                return n.length() == 49 && n.endsWith(".idx") && n.startsWith("pack-");
            }
        });
        if (idxList != null) {
            block2: for (String indexName : idxList) {
                String n = indexName.substring(0, indexName.length() - 4);
                File idxFile = new File(packDir, n + ".idx");
                File packFile = new File(packDir, n + ".pack");
                if (!packFile.isFile()) continue;
                for (PackFile p : packList) {
                    if (!packFile.equals(p.getPackFile())) continue;
                    continue block2;
                }
                try {
                    packList.add(new PackFile(this, idxFile, packFile));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public void writeSymref(String name, String target) throws IOException {
        this.refs.link(name, target);
    }

    public String toString() {
        return "Repository[" + this.getDirectory() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPatch() throws IOException {
        File ptr = new File(this.getDirectory(), "patches/" + this.getBranch() + "/applied");
        BufferedReader br = new BufferedReader(new FileReader(ptr));
        String last = null;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                last = line;
            }
        }
        finally {
            br.close();
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullBranch() throws IOException {
        String ref;
        File ptr = new File(this.getDirectory(), "HEAD");
        BufferedReader br = new BufferedReader(new FileReader(ptr));
        try {
            ref = br.readLine();
        }
        finally {
            br.close();
        }
        if (ref.startsWith("ref: ")) {
            ref = ref.substring(5);
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBranch() throws IOException {
        try {
            String ref;
            File ptr = new File(this.getDirectory(), "HEAD");
            BufferedReader br = new BufferedReader(new FileReader(ptr));
            try {
                ref = br.readLine();
            }
            finally {
                br.close();
            }
            if (ref.startsWith("ref: ")) {
                ref = ref.substring(5);
            }
            if (ref.startsWith("refs/heads/")) {
                ref = ref.substring(11);
            }
            return ref;
        }
        catch (FileNotFoundException e) {
            String ref;
            File ptr = new File(this.getDirectory(), "head-name");
            BufferedReader br = new BufferedReader(new FileReader(ptr));
            try {
                ref = br.readLine();
            }
            finally {
                br.close();
            }
            return ref;
        }
    }

    public Map<String, Ref> getAllRefs() {
        return this.refs.getAllRefs();
    }

    public Map<String, Ref> getTags() {
        return this.refs.getTags();
    }

    public Ref peel(Ref ref) {
        return this.refs.peel(ref);
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target;
            if (!ref.isPeeled()) {
                ref = this.peel(ref);
            }
            if ((target = ref.getPeeledObjectId()) == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    public void refreshFromDisk() {
        this.refs.clearCache();
    }

    public GitIndex getIndex() throws IOException {
        if (this.index == null) {
            this.index = new GitIndex(this);
            this.index.read();
        } else {
            this.index.rereadIfNecessary();
        }
        return this.index;
    }

    static byte[] gitInternalSlash(byte[] bytes) {
        if (File.separatorChar == '/') {
            return bytes;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != File.separatorChar) continue;
            bytes[i] = 47;
        }
        return bytes;
    }

    public RepositoryState getRepositoryState() {
        if (new File(this.getWorkDir(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.gitDir, ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.gitDir, "MERGE_HEAD").exists()) {
            return RepositoryState.MERGING;
        }
        if (new File(this.gitDir, "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        char p = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    if (i == 0) {
                        return false;
                    }
                    if (p == '/') {
                        return false;
                    }
                    if (p != '.') break;
                    return false;
                }
                case '/': {
                    if (i == 0) {
                        return false;
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case ':': 
                case '?': 
                case '[': 
                case '^': 
                case '~': {
                    return false;
                }
                case '*': {
                    return false;
                }
            }
            p = c;
        }
        return true;
    }

    public static String stripWorkDir(File wd, File f) {
        String relName = f.getPath().substring(wd.getPath().length() + 1);
        relName = relName.replace(File.separatorChar, '/');
        return relName;
    }

    public File getWorkDir() {
        return this.getDirectory().getParentFile();
    }

    public void addRepositoryChangedListener(RepositoryListener l) {
        this.listeners.add(l);
    }

    public void removeRepositoryChangedListener(RepositoryListener l) {
        this.listeners.remove(l);
    }

    public static void addAnyRepositoryChangedListener(RepositoryListener l) {
        allListeners.add(l);
    }

    public static void removeAnyRepositoryChangedListener(RepositoryListener l) {
        allListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRefsMaybeChanged() {
        if (this.refs.lastRefModification != this.refs.lastNotifiedRefModification) {
            ArrayList<RepositoryListener> all;
            this.refs.lastNotifiedRefModification = this.refs.lastRefModification;
            RefsChangedEvent event = new RefsChangedEvent(this);
            List<RepositoryListener> list = this.listeners;
            synchronized (list) {
                all = new ArrayList<RepositoryListener>(this.listeners);
            }
            list = allListeners;
            synchronized (list) {
                all.addAll(allListeners);
            }
            for (RepositoryListener l : all) {
                l.refsChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireIndexChanged() {
        ArrayList<RepositoryListener> all;
        IndexChangedEvent event = new IndexChangedEvent(this);
        List<RepositoryListener> list = this.listeners;
        synchronized (list) {
            all = new ArrayList<RepositoryListener>(this.listeners);
        }
        list = allListeners;
        synchronized (list) {
            all.addAll(allListeners);
        }
        for (RepositoryListener l : all) {
            l.indexChanged(event);
        }
    }

    public void scanForRepoChanges() throws IOException {
        this.getAllRefs();
        this.getIndex();
    }
}

