/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.CoreConfig;
import org.spearce.jgit.lib.Repository;
import org.spearce.jgit.lib.TransferConfig;
import org.spearce.jgit.util.FS;
import org.spearce.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfig {
    private final RepositoryConfig baseConfig;
    public static final String REMOTE_SECTION = "remote";
    public static final String BRANCH_SECTION = "branch";
    private final File configFile;
    private boolean readFile;
    private CoreConfig core;
    private TransferConfig transfer;
    private List<Entry> entries;
    private Map<String, Object> byName;
    private static String hostname;
    private static final String MAGIC_EMPTY_VALUE = "%%magic%%empty%%";
    private static SystemReader systemReader;

    public static RepositoryConfig openUserConfig() {
        return new RepositoryConfig(null, new File(FS.userHome(), ".gitconfig"));
    }

    RepositoryConfig(Repository repo) {
        this(RepositoryConfig.openUserConfig(), FS.resolve(repo.getDirectory(), "config"));
    }

    public RepositoryConfig(RepositoryConfig base, File cfgLocation) {
        this.baseConfig = base;
        this.configFile = cfgLocation;
        this.clear();
    }

    public CoreConfig getCore() {
        return this.core;
    }

    public TransferConfig getTransfer() {
        return this.transfer;
    }

    public int getInt(String section, String name, int defaultValue) {
        return this.getInt(section, null, name, defaultValue);
    }

    public int getInt(String section, String subsection, String name, int defaultValue) {
        String str = this.getString(section, subsection, name);
        if (str == null) {
            return defaultValue;
        }
        String n = str.trim();
        if (n.length() == 0) {
            return defaultValue;
        }
        int mul = 1;
        switch (Character.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000;
                break;
            }
            case 'm': {
                mul = 0x100000;
                break;
            }
            case 'k': {
                mul = 1024;
            }
        }
        if (mul > 1) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue;
        }
        try {
            return mul * Integer.parseInt(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid integer value: " + section + "." + name + "=" + str);
        }
    }

    public boolean getBoolean(String section, String name, boolean defaultValue) {
        return this.getBoolean(section, null, name, defaultValue);
    }

    public boolean getBoolean(String section, String subsection, String name, boolean defaultValue) {
        String n = this.getRawString(section, subsection, name);
        if (n == null) {
            return defaultValue;
        }
        if (MAGIC_EMPTY_VALUE.equals(n = n.toLowerCase()) || "yes".equalsIgnoreCase(n) || "true".equalsIgnoreCase(n) || "1".equals(n)) {
            return true;
        }
        if ("no".equalsIgnoreCase(n) || "false".equalsIgnoreCase(n) || "0".equalsIgnoreCase(n)) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean value: " + section + "." + name + "=" + n);
    }

    public String getString(String section, String subsection, String name) {
        String val = this.getRawString(section, subsection, name);
        if (MAGIC_EMPTY_VALUE.equals(val)) {
            return "";
        }
        return val;
    }

    public String[] getStringList(String section, String subsection, String name) {
        Object o = this.getRawEntry(section, subsection, name);
        if (o instanceof List) {
            List lst = (List)o;
            String[] r = new String[lst.size()];
            for (int i = 0; i < r.length; ++i) {
                String val = ((Entry)lst.get((int)i)).value;
                r[i] = MAGIC_EMPTY_VALUE.equals(val) ? "" : val;
            }
            return r;
        }
        if (o instanceof Entry) {
            String val = ((Entry)o).value;
            return new String[]{MAGIC_EMPTY_VALUE.equals(val) ? "" : val};
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getStringList(section, subsection, name);
        }
        return new String[0];
    }

    public Set<String> getSubsections(String section) {
        HashSet<String> result = new HashSet<String>();
        for (Entry e : this.entries) {
            if (!section.equalsIgnoreCase(e.base) || e.extendedBase == null) continue;
            result.add(e.extendedBase);
        }
        if (this.baseConfig != null) {
            result.addAll(this.baseConfig.getSubsections(section));
        }
        return result;
    }

    public String getAuthorName() {
        return this.getUsernameInternal("GIT_AUTHOR_NAME");
    }

    public String getCommitterName() {
        return this.getUsernameInternal("GIT_COMMITTER_NAME");
    }

    private String getUsernameInternal(String gitVariableKey) {
        String username = this.getString("user", null, "name");
        if (username == null) {
            username = systemReader.getenv(gitVariableKey);
        }
        if (username == null) {
            username = systemReader.getProperty("user.name");
        }
        if (username == null) {
            username = "unknown-user";
        }
        return username;
    }

    public String getAuthorEmail() {
        return this.getUserEmailInternal("GIT_AUTHOR_EMAIL");
    }

    public String getCommitterEmail() {
        return this.getUserEmailInternal("GIT_COMMITTER_EMAIL");
    }

    private String getUserEmailInternal(String gitVariableKey) {
        String email = this.getString("user", null, "email");
        if (email == null) {
            email = systemReader.getenv(gitVariableKey);
        }
        if (email == null) {
            String username = systemReader.getProperty("user.name");
            if (username == null) {
                username = "unknown-user";
            }
            email = username + "@" + RepositoryConfig.getHostname();
        }
        return email;
    }

    private String getRawString(String section, String subsection, String name) {
        Object o = this.getRawEntry(section, subsection, name);
        if (o instanceof List) {
            return ((Entry)((List)o).get((int)0)).value;
        }
        if (o instanceof Entry) {
            return ((Entry)o).value;
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name);
        }
        return null;
    }

    private Object getRawEntry(String section, String subsection, String name) {
        if (!this.readFile) {
            try {
                this.load();
            }
            catch (FileNotFoundException err) {
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        }
        String ss = subsection != null ? "." + subsection.toLowerCase() : "";
        Object o = this.byName.get(section.toLowerCase() + ss + "." + name.toLowerCase());
        return o;
    }

    public void setString(String section, String subsection, String name, String value) {
        this.setStringList(section, subsection, name, Collections.singletonList(value));
    }

    public void unsetString(String section, String subsection, String name) {
        this.setStringList(section, subsection, name, Collections.<String>emptyList());
    }

    public void setStringList(String section, String subsection, String name, List<String> values) {
        Entry e;
        String key = section.toLowerCase();
        if (subsection != null) {
            key = key + "." + subsection.toLowerCase();
        }
        key = key + "." + name.toLowerCase();
        if (values.size() == 0) {
            this.byName.remove(key);
        } else if (values.size() == 1) {
            Entry e2 = new Entry();
            e2.base = section;
            e2.extendedBase = subsection;
            e2.name = name;
            e2.value = values.get(0);
            this.byName.put(key, e2);
        } else {
            ArrayList<Entry> eList = new ArrayList<Entry>(values.size());
            for (String v : values) {
                e = new Entry();
                e.base = section;
                e.extendedBase = subsection;
                e.name = name;
                e.value = v;
                eList.add(e);
            }
            this.byName.put(key, eList);
        }
        int entryIndex = 0;
        int valueIndex = 0;
        int insertPosition = -1;
        while (entryIndex < this.entries.size() && valueIndex < values.size()) {
            if (!(e = this.entries.get(entryIndex++)).match(section, subsection, name)) continue;
            e.value = values.get(valueIndex++);
            insertPosition = entryIndex;
        }
        if (valueIndex == values.size() && entryIndex < this.entries.size()) {
            while (entryIndex < this.entries.size()) {
                if (!(e = this.entries.get(entryIndex++)).match(section, subsection, name)) continue;
                this.entries.remove(--entryIndex);
            }
        }
        if (valueIndex < values.size() && entryIndex == this.entries.size()) {
            if (insertPosition < 0) {
                insertPosition = this.findSectionEnd(section, subsection);
            }
            if (insertPosition < 0) {
                e = new Entry();
                e.prefix = null;
                e.suffix = null;
                e.base = section;
                e.extendedBase = subsection;
                this.entries.add(e);
                insertPosition = this.entries.size();
            }
            while (valueIndex < values.size()) {
                e = new Entry();
                e.prefix = null;
                e.suffix = null;
                e.base = section;
                e.extendedBase = subsection;
                e.name = name;
                e.value = values.get(valueIndex++);
                this.entries.add(insertPosition++, e);
            }
        }
    }

    private int findSectionEnd(String section, String subsection) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.get(i);
            if (!e.match(section, subsection, null)) continue;
            ++i;
            while (i < this.entries.size() && (e = this.entries.get(i)).match(section, subsection, e.name)) {
                ++i;
            }
            return i;
        }
        return -1;
    }

    public void create() {
        this.clear();
        this.readFile = true;
        Entry e = new Entry();
        e.base = "core";
        this.add(e);
        e = new Entry();
        e.base = "core";
        e.name = "repositoryformatversion";
        e.value = "0";
        this.add(e);
        e = new Entry();
        e.base = "core";
        e.name = "filemode";
        e.value = "true";
        this.add(e);
        this.core = new CoreConfig(this);
        this.transfer = new TransferConfig(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        File tmp = new File(this.configFile.getParentFile(), this.configFile.getName() + ".lock");
        PrintWriter r = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), Constants.CHARSET))){

            public void println() {
                this.print('\n');
            }
        };
        boolean ok = false;
        try {
            for (Entry e : this.entries) {
                if (e.prefix != null) {
                    r.print(e.prefix);
                }
                if (e.base != null && e.name == null) {
                    r.print('[');
                    r.print(e.base);
                    if (e.extendedBase != null) {
                        r.print(' ');
                        r.print('\"');
                        r.print(RepositoryConfig.escapeValue(e.extendedBase));
                        r.print('\"');
                    }
                    r.print(']');
                } else if (e.base != null && e.name != null) {
                    if (e.prefix == null || "".equals(e.prefix)) {
                        r.print('\t');
                    }
                    r.print(e.name);
                    if (e.value != null && !MAGIC_EMPTY_VALUE.equals(e.value)) {
                        r.print(" = ");
                        r.print(RepositoryConfig.escapeValue(e.value));
                    }
                    if (e.suffix != null) {
                        r.print(' ');
                    }
                }
                if (e.suffix != null) {
                    r.print(e.suffix);
                }
                r.println();
            }
            ok = true;
            r.close();
            if (!tmp.renameTo(this.configFile)) {
                this.configFile.delete();
                if (!tmp.renameTo(this.configFile)) {
                    throw new IOException("Cannot save config file " + this.configFile + ", rename failed");
                }
            }
        }
        finally {
            r.close();
            if (tmp.exists() && !tmp.delete()) {
                System.err.println("(warning) failed to delete tmp config file: " + tmp);
            }
        }
        this.readFile = ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        block15: {
            this.clear();
            this.readFile = true;
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configFile), Constants.CHARSET));
            try {
                Entry last = null;
                Entry e = new Entry();
                while (true) {
                    r.mark(1);
                    int input = r.read();
                    char in = (char)input;
                    if (-1 == input) {
                        break block15;
                    }
                    if ('\n' == in) {
                        this.add(e);
                        if (e.base != null) {
                            last = e;
                        }
                        e = new Entry();
                        continue;
                    }
                    if (e.suffix != null) {
                        e.suffix = e.suffix + in;
                        continue;
                    }
                    if (';' == in || '#' == in) {
                        e.suffix = String.valueOf(in);
                        continue;
                    }
                    if (e.base == null && Character.isWhitespace(in)) {
                        if (e.prefix == null) {
                            e.prefix = "";
                        }
                        e.prefix = e.prefix + in;
                        continue;
                    }
                    if ('[' == in) {
                        e.base = RepositoryConfig.readBase(r);
                        input = r.read();
                        if (34 == input) {
                            e.extendedBase = RepositoryConfig.readValue(r, true, 34);
                            input = r.read();
                        }
                        if (93 != input) {
                            throw new IOException("Bad group header.");
                        }
                        e.suffix = "";
                        continue;
                    }
                    if (last == null) break;
                    e.base = last.base;
                    e.extendedBase = last.extendedBase;
                    r.reset();
                    e.name = RepositoryConfig.readName(r);
                    if (e.name.endsWith("\n")) {
                        e.name = e.name.substring(0, e.name.length() - 1);
                        e.value = MAGIC_EMPTY_VALUE;
                        continue;
                    }
                    e.value = RepositoryConfig.readValue(r, false, -1);
                }
                throw new IOException("Invalid line in config file.");
            }
            finally {
                r.close();
            }
        }
        this.core = new CoreConfig(this);
        this.transfer = new TransferConfig(this);
    }

    private void clear() {
        this.entries = new ArrayList<Entry>();
        this.byName = new HashMap<String, Object>();
    }

    private void add(Entry e) {
        this.entries.add(e);
        if (e.base != null) {
            String b = e.base.toLowerCase();
            String group = e.extendedBase != null ? b + "." + e.extendedBase : b;
            if (e.name != null) {
                String n = e.name.toLowerCase();
                String key = group + "." + n;
                Object o = this.byName.get(key);
                if (o == null) {
                    this.byName.put(key, e);
                } else if (o instanceof Entry) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(o);
                    l.add(e);
                    this.byName.put(key, l);
                } else if (o instanceof List) {
                    ((List)o).add(e);
                }
            }
        }
    }

    private static String escapeValue(String x) {
        boolean inquote = false;
        int lineStart = 0;
        StringBuffer r = new StringBuffer(x.length());
        block9: for (int k = 0; k < x.length(); ++k) {
            char c = x.charAt(k);
            switch (c) {
                case '\n': {
                    if (inquote) {
                        r.append('\"');
                        inquote = false;
                    }
                    r.append("\\n\\\n");
                    lineStart = r.length();
                    continue block9;
                }
                case '\t': {
                    r.append("\\t");
                    continue block9;
                }
                case '\b': {
                    r.append("\\b");
                    continue block9;
                }
                case '\\': {
                    r.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    r.append("\\\"");
                    continue block9;
                }
                case '#': 
                case ';': {
                    if (!inquote) {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(c);
                    continue block9;
                }
                case ' ': {
                    if (!inquote && r.length() > 0 && r.charAt(r.length() - 1) == ' ') {
                        r.insert(lineStart, '\"');
                        inquote = true;
                    }
                    r.append(' ');
                    continue block9;
                }
                default: {
                    r.append(c);
                }
            }
        }
        if (inquote) {
            r.append('\"');
        }
        return r.toString();
    }

    private static String readBase(BufferedReader r) throws IOException {
        StringBuffer base;
        block6: {
            int c;
            base = new StringBuffer();
            while (true) {
                r.mark(1);
                c = r.read();
                if (c < 0) {
                    throw new IOException("Unexpected end of config file.");
                }
                if (93 == c) {
                    r.reset();
                    break block6;
                }
                if (32 == c || 9 == c) {
                    do {
                        r.mark(1);
                        c = r.read();
                        if (c < 0) {
                            throw new IOException("Unexpected end of config file.");
                        }
                        if (34 != c) continue;
                        r.reset();
                        break block6;
                    } while (32 == c || 9 == c);
                    throw new IOException("Bad base entry. : " + base + "," + c);
                }
                if (!Character.isLetterOrDigit((char)c) && 46 != c && 45 != c) break;
                base.append((char)c);
            }
            throw new IOException("Bad base entry. : " + base + ", " + c);
        }
        return base.toString();
    }

    private static String readName(BufferedReader r) throws IOException {
        StringBuffer name;
        block7: {
            int c;
            name = new StringBuffer();
            while (true) {
                r.mark(1);
                c = r.read();
                if (c < 0) {
                    throw new IOException("Unexpected end of config file.");
                }
                if (61 == c) break block7;
                if (32 == c || 9 == c) {
                    do {
                        r.mark(1);
                        c = r.read();
                        if (c < 0) {
                            throw new IOException("Unexpected end of config file.");
                        }
                        if (61 == c) break block7;
                        if (59 != c && 35 != c && 10 != c) continue;
                        r.reset();
                        break block7;
                    } while (32 == c || 9 == c);
                    throw new IOException("Bad entry delimiter.");
                }
                if (!Character.isLetterOrDigit((char)c) && c != 45) break;
                name.append((char)c);
            }
            if (10 == c) {
                r.reset();
                name.append((char)c);
            } else {
                throw new IOException("Bad config entry name: " + name + (char)c);
            }
        }
        return name.toString();
    }

    private static String readValue(BufferedReader r, boolean quote, int eol) throws IOException {
        StringBuffer value = new StringBuffer();
        boolean space = false;
        block9: while (true) {
            r.mark(1);
            int c = r.read();
            if (c < 0) {
                if (value.length() != 0) break;
                throw new IOException("Unexpected end of config file.");
            }
            if (10 == c) {
                if (quote) {
                    throw new IOException("Newline in quotes not allowed.");
                }
                r.reset();
                break;
            }
            if (eol == c) break;
            if (!quote) {
                if (Character.isWhitespace((char)c)) {
                    space = true;
                    continue;
                }
                if (59 == c || 35 == c) {
                    r.reset();
                    break;
                }
            }
            if (space) {
                if (value.length() > 0) {
                    value.append(' ');
                }
                space = false;
            }
            if (92 == c) {
                c = r.read();
                switch (c) {
                    case -1: {
                        throw new IOException("End of file in escape.");
                    }
                    case 10: {
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 92: {
                        value.append('\\');
                        continue block9;
                    }
                    case 34: {
                        value.append('\"');
                        continue block9;
                    }
                }
                throw new IOException("Bad escape: " + (char)c);
            }
            if (34 == c) {
                quote = !quote;
                continue;
            }
            value.append((char)c);
        }
        return value.length() > 0 ? value.toString() : null;
    }

    public String toString() {
        return "RepositoryConfig[" + this.configFile.getPath() + "]";
    }

    private static String getHostname() {
        if (hostname == null) {
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
                hostname = localMachine.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
            assert (hostname != null);
        }
        return hostname;
    }

    public static void setSystemReader(SystemReader newSystemReader) {
        systemReader = newSystemReader;
    }

    static {
        systemReader = new SystemReader(){

            public String getenv(String variable) {
                return System.getenv(variable);
            }

            public String getProperty(String key) {
                return System.getProperty(key);
            }
        };
    }

    static class Entry {
        String prefix;
        String base;
        String extendedBase;
        String name;
        String value;
        String suffix;

        Entry() {
        }

        boolean match(String aBase, String aExtendedBase, String aName) {
            return Entry.eq(this.base, aBase) && Entry.eq(this.extendedBase, aExtendedBase) && Entry.eq(this.name, aName);
        }

        private static boolean eq(String a, String b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.equalsIgnoreCase(b);
        }
    }
}

