/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import org.spearce.jgit.lib.ProgressMonitor;

public class TextProgressMonitor
implements ProgressMonitor {
    private boolean output;
    private long taskBeganAt = System.currentTimeMillis();
    private String msg;
    private int lastWorked;
    private int totalWork;

    public void start(int totalTasks) {
        this.taskBeganAt = System.currentTimeMillis();
    }

    public void beginTask(String title, int total) {
        this.endTask();
        this.msg = title;
        this.lastWorked = 0;
        this.totalWork = total;
    }

    public void update(int completed) {
        if (this.msg == null) {
            return;
        }
        int cmp = this.lastWorked + completed;
        if (!this.output && System.currentTimeMillis() - this.taskBeganAt < 500L) {
            return;
        }
        if (this.totalWork == 0) {
            this.display(cmp);
            System.err.flush();
        } else if (cmp * 100 / this.totalWork != this.lastWorked * 100 / this.totalWork) {
            this.display(cmp);
            System.err.flush();
        }
        this.lastWorked = cmp;
        this.output = true;
    }

    private void display(int cmp) {
        StringBuilder m = new StringBuilder();
        m.append('\r');
        m.append(this.msg);
        m.append(": ");
        while (m.length() < 25) {
            m.append(' ');
        }
        if (this.totalWork == 0) {
            m.append(cmp);
        } else {
            String twstr = String.valueOf(this.totalWork);
            String cmpstr = String.valueOf(cmp);
            while (cmpstr.length() < twstr.length()) {
                cmpstr = " " + cmpstr;
            }
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append(cmpstr);
            m.append("/");
            m.append(twstr);
            m.append(")");
        }
        System.err.print(m);
    }

    public boolean isCancelled() {
        return false;
    }

    public void endTask() {
        if (this.output) {
            if (this.totalWork != 0) {
                this.display(this.totalWork);
            }
            System.err.println();
        }
        this.output = false;
        this.msg = null;
    }
}

