/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import org.spearce.jgit.errors.CorruptObjectException;
import org.spearce.jgit.lib.ObjectId;
import org.spearce.jgit.lib.PackFile;
import org.spearce.jgit.lib.PackedObjectLoader;
import org.spearce.jgit.lib.UnpackedObjectCache;
import org.spearce.jgit.lib.WindowCursor;

class WholePackedObjectLoader
extends PackedObjectLoader {
    private static final int OBJ_COMMIT = 1;

    WholePackedObjectLoader(WindowCursor curs, PackFile pr, long dataOffset, long objectOffset, int type, int size) {
        super(curs, pr, dataOffset, objectOffset);
        this.objectType = type;
        this.objectSize = size;
    }

    public byte[] getCachedBytes() throws IOException {
        UnpackedObjectCache.Entry cache;
        if (this.objectType != 1 && (cache = this.pack.readCache(this.dataOffset)) != null) {
            this.curs.release();
            return cache.data;
        }
        try {
            byte[] data = this.pack.decompress(this.dataOffset, this.objectSize, this.curs);
            this.curs.release();
            if (this.objectType != 1) {
                this.pack.saveCache(this.dataOffset, data, this.objectType);
            }
            return data;
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException("Object at " + this.dataOffset + " in " + this.pack.getPackFile() + " has bad zlib stream");
            coe.initCause(dfe);
            throw coe;
        }
    }

    public int getRawType() {
        return this.objectType;
    }

    public long getRawSize() {
        return this.objectSize;
    }

    public ObjectId getDeltaBase() {
        return null;
    }
}

